/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.OutSignal;
import se.ericsson.cello.support.control.Control;
import se.ericsson.cello.support.debug.ThreadsContainer;
import se.ericsson.cello.support.debug.trace.ThreadsContainerForLinux;
import se.ericsson.cello.support.debug.trace.ThreadsContainerForOse;

public class MessageLog {
    static final ThreadsContainer threadsContainer = Control.getOs() == 0 ? new ThreadsContainerForOse() : new ThreadsContainerForLinux();

    public static boolean isReturnEnabled(Class clazz) {
        return threadsContainer.isReturnEnabled(clazz);
    }

    public static boolean isEnterEnabled(Class clazz) {
        return threadsContainer.isEnterEnabled(clazz);
    }

    public static boolean isStateEnabled(Class clazz) {
        return threadsContainer.isStateEnabled(clazz);
    }

    public static boolean isParamEnabled(Class clazz) {
        return threadsContainer.isParamEnabled(clazz);
    }

    public static boolean isRecSigEnabled(Class clazz) {
        return threadsContainer.isRecSigEnabled(clazz);
    }

    public static boolean isSendSigEnabled(Class clazz) {
        return threadsContainer.isSendSigEnabled(clazz);
    }

    public static boolean isTraceEnabled(Class clazz) {
        return threadsContainer.isTraceEnabled(clazz);
    }

    public static boolean isTraceGroupEnabled(int n, Class clazz) {
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("The group number must be between 0 and 9 (inclusive). Now it is " + n + ".");
        }
        return threadsContainer.isTraceGroupEnabled(n, clazz);
    }

    public static void trace(int n, Class clazz, String string) {
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException("The group number must be between 0 and 9 (inclusive). Now it is " + n + ".");
        }
        threadsContainer.traceGroup(n, clazz, string);
    }

    public static void traceError(Class clazz, String string, Throwable throwable) {
        threadsContainer.traceError(clazz, string, throwable);
    }

    public static void traceError(Class clazz, String string) {
        MessageLog.traceError(clazz, string, null);
    }

    public static void info(Class clazz, String string) {
        threadsContainer.traceInfo(clazz, string);
    }

    public static void traceEnter(Class clazz, String string) {
        threadsContainer.traceEnter(clazz, string);
    }

    public static void traceReturn(Class clazz, String string) {
        threadsContainer.traceReturn(clazz, string);
    }

    public static void traceState(Class clazz, String string) {
        threadsContainer.traceState(clazz, string);
    }

    public static void traceParam(Class clazz, String string) {
        threadsContainer.traceParam(clazz, string);
    }

    public static void traceSendSig(Class clazz, String string, OutSignal outSignal, OseProcess oseProcess) {
        threadsContainer.traceSendSig(clazz, string, outSignal, oseProcess);
    }

    public static void traceRecSig(Class clazz, String string, InSignal inSignal) {
        threadsContainer.traceRecSig(clazz, string, inSignal);
    }

    public static void info(String string) {
        MessageLog.info(MessageLog.class, string);
    }

    public static void trace(int n, Class clazz, String string, Exception exception) {
        if (exception == null) {
            MessageLog.info(clazz, string);
        } else {
            MessageLog.traceError(clazz, string, exception);
        }
    }

    public static void flush() {
    }

    public static void close() {
    }

    public static void dump() {
    }
}

