/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.sigutil;

import enea.ose.system.OseProcess;
import enea.ose.system.SignalPort;
import enea.ose.system.SignalRegistry;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.MessageReceiver;
import se.ericsson.cello.support.sigutil.ObserverList;
import se.ericsson.cello.support.sigutil.PortListenerSupervisor;
import se.ericsson.cello.support.sigutil.signals.NsAddServiceReply;
import se.ericsson.cello.support.sigutil.signals.NsAddServiceReq;
import se.ericsson.cello.support.sigutil.signals.UpdateSignal;

class PortListener
implements Runnable {
    static final String CELLO_SIGNALPORT_SERVICE_NAME = "CelloJavaSignalPort";
    private static final String MAILBOX_NAME = "Osa_javaSignalPort_proc";
    private static final String OSE_NAME_SERVER = "ose_ns";
    private static final String LINX_NAME_SERVER = "linx_ns";
    private static final int RECEIVE_TIMEOUT = 10000;
    private OseProcess portProc = null;
    private ObserverList oList;
    private Object ready = new int[1];

    PortListener(ObserverList observerList) {
        this.oList = observerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SignalRegistry signalRegistry = new SignalRegistry();
        SignalPort signalPort = new SignalPort(MAILBOX_NAME);
        this.portProc = OseProcess.hunt(MAILBOX_NAME);
        OseProcess oseProcess = OseProcess.hunt(OSE_NAME_SERVER);
        oseProcess.post(new NsAddServiceReq(CELLO_SIGNALPORT_SERVICE_NAME), this.portProc);
        signalRegistry.add(NsAddServiceReply.class);
        NsAddServiceReply nsAddServiceReply = (NsAddServiceReply)signalPort.receive(signalRegistry, 10000);
        if (nsAddServiceReply == null || nsAddServiceReply.getStatus() == 1L) {
            MessageLog.traceError(PortListener.class, "Name Server registration failure", null);
        }
        Object object = this.ready;
        synchronized (object) {
            MessageLog.trace(9, this.getClass(), "notifyAll() in PortListener.run()");
            this.ready.notifyAll();
        }
        object = new PortListenerSupervisor();
        new MessageReceiver((PortListenerSupervisor)object, this.oList, signalPort).start();
        ((PortListenerSupervisor)object).supervise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OseProcess getOseProcess() {
        while (this.portProc == null) {
            try {
                Object object = this.ready;
                synchronized (object) {
                    this.ready.wait(100L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return this.portProc;
    }

    void update() {
        this.getOseProcess().post(new UpdateSignal());
    }
}

