/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.sigutil;

import enea.ose.system.InSignal;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.MessageReceiver;
import se.ericsson.cello.support.sigutil.SignalObserver;

public class PortListenerSupervisor {
    MessageReceiver mr = null;
    String signalName = null;
    String soName = null;
    public final long SUPERVISE_TIMEOUT = 10000L;
    static int callCounter = 0;

    public void supervise() {
        while (true) {
            this.waitForTimeout();
        }
    }

    private synchronized void performTimeout() {
        int n = callCounter;
        try {
            MessageLog.trace(7, this.getClass(), "performTimeout()[" + callCounter + "]:wait()");
            this.wait(10000L);
            MessageLog.trace(7, this.getClass(), "performTimeout(). [" + callCounter + "]:woken.");
        }
        catch (InterruptedException interruptedException) {
            MessageLog.traceError(this.getClass(), "Unexpected exception", interruptedException);
        }
        MessageLog.trace(7, this.getClass(), "mr=" + this.mr + ". [" + callCounter + "]");
        if (this.mr == null || callCounter != n) {
            return;
        }
        MessageLog.info(this.getClass(), "The message receiver called " + this.soName + ".signalReceived(" + this.signalName + ") and blocked for " + "more than " + 10000L + "ms. Create a new " + "message receiver thread and let the previous thread " + "complete the blocking call.");
        this.mr.setInvalid();
        new MessageReceiver(this.mr).start();
        this.mr = null;
    }

    private synchronized void waitForTimeout() {
        while (this.mr == null) {
            try {
                this.wait();
                MessageLog.trace(7, this.getClass(), "waitForTimeout()[" + callCounter + "]");
            }
            catch (InterruptedException interruptedException) {
                MessageLog.traceError(this.getClass(), "Unexpected exception", interruptedException);
            }
        }
        this.performTimeout();
    }

    synchronized void startTimeout(MessageReceiver messageReceiver, InSignal inSignal, SignalObserver signalObserver) {
        this.mr = messageReceiver;
        this.signalName = inSignal.getClass().getName();
        this.soName = signalObserver.getClass().getName();
        MessageLog.trace(7, this.getClass(), "Started timeout [" + ++callCounter + "] for " + this.soName);
        this.notify();
    }

    synchronized void stopTimeout(MessageReceiver messageReceiver) {
        if (this.mr == messageReceiver) {
            this.mr = null;
            MessageLog.trace(7, this.getClass(), "Stopped timeout [" + callCounter + "] for " + this.soName);
            this.notify();
        }
    }
}

