/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sync;

import se.ericsson.cello.equipment.CbuMo;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.iptransport.ExchangeTerminalIpMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.mom.IpAccessHostEt;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv6Address;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.sync.PacketFrequencySyncRefMoGen;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.sync.TimingUnitMo;
import se.ericsson.cello.transaction.Coordinator;

public class PacketFrequencySyncRefMoImpl
extends PacketFrequencySyncRefMoGen
implements FroInfo,
SyncReservable {
    private static final int MIN_LENGTH_SERVER_IPADDRESS = 0;
    private static final int MAX_LENGTH_SERVER_IPADDRESS = 255;

    public PacketFrequencySyncRefMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, attrList, maoFroIndicationHandler);
    }

    public PacketFrequencySyncRefMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, froProxy, maoFroIndicationHandler);
    }

    protected int findTuFroID(ManagedObject managedObject) throws MoAccessException {
        ManagedObject managedObject2 = null;
        if (managedObject instanceof IpInterfaceMo) {
            managedObject2 = ((IpInterfaceMo)managedObject).getParent();
        } else if (managedObject instanceof Ipv6InterfaceMo) {
            managedObject2 = ((Ipv6InterfaceMo)managedObject).getEthernetRef(null);
        }
        ExchangeTerminalIpMo exchangeTerminalIpMo = (ExchangeTerminalIpMo)managedObject2.getParent();
        PlugInUnitMo plugInUnitMo = null;
        plugInUnitMo = exchangeTerminalIpMo.getParent() instanceof PiuDeviceMo ? (PlugInUnitMo)exchangeTerminalIpMo.getParent().getParent() : (PlugInUnitMo)exchangeTerminalIpMo.getParent();
        MoIterator moIterator = plugInUnitMo.getChildren();
        ManagedObject managedObject3 = null;
        Object var7_7 = null;
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                managedObject3 = moIterator.nextMo();
                if (managedObject3 instanceof TimingUnitMo) {
                    return ((FroInfo)managedObject3).getFroId(null);
                }
                if (!(managedObject3 instanceof CbuMo)) continue;
                MoIterator moIterator2 = managedObject3.getChildren();
                while (moIterator2.hasMoreElements()) {
                    ManagedObject managedObject4 = moIterator2.nextMo();
                    if (!(managedObject4 instanceof TimingUnitMo)) continue;
                    return ((FroInfo)managedObject4).getFroId(null);
                }
            }
        }
        return 0;
    }

    protected String validateServerAddress(AttrList attrList, String string, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"serverAddress", (int)255, (int)0, (String)"PacketFrequencySyncRef");
        String string2 = ((IpAccessHostEt)managedObject).getIpAddress(coordinator);
        try {
            Ipv6Address.validate((String)string);
            if (Ipv6Address.isIpv4((String)string2) && !Ipv6Address.isIpv4((String)string) || Ipv6Address.isIpv6((String)string2) && !Ipv6Address.isIpv6((String)string)) {
                throw new ConfigurationMismatchException("the IP address in this attribute must be of same format as the referenced IpAccessHostEt MO", "PacketFrequencySyncRef");
            }
            return string;
        }
        catch (IpFormatException ipFormatException) {
            PacketFrequencySyncRefMoImpl.checkForValidDomainName(string);
            return string;
        }
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reserve(managedObject, coordinator);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.release(managedObject, coordinator);
    }

    private static void checkForValidDomainName(String string) throws ConfigurationMismatchException, MoAccessException {
        if (string.length() == 0) {
            return;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(string.length() - 1);
        if (!Character.isLetterOrDigit(c)) {
            throw new ConfigurationMismatchException("serverAddress must be either a valid IP address or a valid domain name. First character must be a letter or a digit.", "PacketFrequencySyncRef");
        }
        if (!Character.isLetterOrDigit(c2)) {
            throw new ConfigurationMismatchException("serverAddress must be either a valid IP address or a valid domain name. Last character must be a letter or a digit.", "PacketFrequencySyncRef");
        }
        int n = string.indexOf(" ");
        if (n != -1) {
            throw new ConfigurationMismatchException("serverAddress must be either a valid IP address or a valid domain name. Space characters are not allowed in the domain name.", "PacketFrequencySyncRef");
        }
        PacketFrequencySyncRefMoImpl.checkDomain(string);
    }

    private static void checkDomain(String string) throws ConfigurationMismatchException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '.') continue;
            throw new ConfigurationMismatchException("serverIpAddress must be either a valid IP address or a valid domain name. The domain name contains an invalid character.", "PacketFrequencySyncRef");
        }
    }

    protected int validatePtpDomain(AttrList attrList, int n, Coordinator coordinator) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"ptpDomain", (int)n, (int)0, (int)255, (String)"PacketFrequencySyncRef");
        return n;
    }
}

