/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.common;

import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.StringTable;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.persistence.DbStringWrapper;
import se.ericsson.cello.transaction.Coordinator;

public class RealStringTable
implements StringTable {
    private DbStringWrapper wrapper;
    private String tableName;

    public RealStringTable(String string) throws AueException {
        this.tableName = string;
        try {
            this.wrapper = new DbStringWrapper(string);
        }
        catch (DbAccessException dbAccessException) {
            throw new AueException("Unable to create wrapper for table '" + string + "'", dbAccessException);
        }
    }

    public int[] getAllPrimaryKeys() throws AueException {
        int[] nArray = null;
        try {
            this.wrapper.connectToDatabase();
            nArray = this.wrapper.retrieveAllPrimaryKeys();
            this.wrapper.disconnectFromDatabase();
        }
        catch (DbAccessException dbAccessException) {
            throw new AueException("Unable to retrieve primary keys from table '" + this.tableName + "'", dbAccessException);
        }
        return nArray;
    }

    public void writeRow(int n, String string, Coordinator coordinator) throws AueException {
        try {
            boolean bl = this.primaryKeyExists(n);
            this.wrapper.connectToDatabase();
            if (bl) {
                this.wrapper.updateRow(coordinator.getTransactionID(), n, string);
            } else {
                this.wrapper.createRow(coordinator.getTransactionID(), n, string);
            }
            this.wrapper.disconnectFromDatabase();
        }
        catch (DbAccessException dbAccessException) {
            throw new AueException("Unable to write row " + n + " in '" + this.tableName + "'", dbAccessException);
        }
    }

    public void deleteRow(int n, Coordinator coordinator) throws AueException {
        try {
            this.wrapper.connectToDatabase();
            this.wrapper.deleteRow(coordinator.getTransactionID(), n);
            this.wrapper.disconnectFromDatabase();
        }
        catch (DbAccessException dbAccessException) {
            throw new AueException("Unable to delete row " + n + " from '" + this.tableName + "'.", dbAccessException);
        }
    }

    public String readRow(int n, Coordinator coordinator) throws AueException {
        String string = null;
        try {
            this.wrapper.connectToDatabase();
            string = this.wrapper.retrieveRow(n);
            this.wrapper.disconnectFromDatabase();
        }
        catch (DbAccessException dbAccessException) {
            throw new AueException("Unable to read row " + n + " in '" + this.tableName + "'.", dbAccessException);
        }
        return string;
    }

    public boolean primaryKeyExists(int n) throws AueException {
        try {
            this.wrapper.connectToDatabase();
            int[] nArray = this.wrapper.retrieveAllPrimaryKeys();
            this.wrapper.disconnectFromDatabase();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                return true;
            }
        }
        catch (DbAccessException dbAccessException) {
            throw new AueException("Unable to retrieve primary keys from table '" + this.tableName + "'", dbAccessException);
        }
        return false;
    }
}

