/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ChangeBasedUpgradePath;
import se.ericsson.cello.aueframework.converter.ChangeSet;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.ModularStep;
import se.ericsson.cello.aueframework.converter.UpgradePath;
import se.ericsson.cello.aueframework.converter.UpgradePathCalculator;

public class ConversionTree
implements UpgradePathCalculator {
    private ModularStep[] steps;
    private ChangeSetComparator comparator;
    public static final ChangeSetComparator DEFAULT_COMPARATOR = new ClassComparator();

    public ConversionTree(ModularStep[] modularStepArray) {
        this(modularStepArray, DEFAULT_COMPARATOR);
    }

    public ConversionTree(ModularStep[] modularStepArray, ChangeSetComparator changeSetComparator) {
        this.steps = modularStepArray;
        this.comparator = changeSetComparator;
    }

    public UpgradePath findUpgradePath(String string, String string2, ConverterContext converterContext) throws AueException {
        Collection collection = this.collectChangesInToState(string2);
        Collection collection2 = this.collectChangesInFromState(string);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            if (this.remove(collection, iterator.next())) continue;
            throw new AueException("Unable to find an upgrade path from " + string + " to " + string2 + ", the from-state has changes that the to-state doesn't.");
        }
        return new ChangeBasedUpgradePath(collection);
    }

    private boolean remove(Collection collection, Object object) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.comparator.areEquivalent((ChangeSet)iterator.next(), (ChangeSet)object)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public ModularStep findStepTo(String string) {
        for (int i = 0; i < this.steps.length; ++i) {
            if (!this.steps[i].getToRevision().equals(string)) continue;
            return this.steps[i];
        }
        return null;
    }

    private Collection collectChangesInToState(String string) throws AueException {
        LinkedList<ChangeSet> linkedList = new LinkedList<ChangeSet>();
        ModularStep modularStep = this.findStepTo(string);
        if (modularStep == null && !this.existsAsFromRevision(string)) {
            throw new AueException("Unknown to-revision " + string);
        }
        while (modularStep != null) {
            ChangeSet[] changeSetArray = modularStep.changes();
            for (int i = changeSetArray.length - 1; i >= 0; --i) {
                linkedList.addFirst(changeSetArray[i]);
            }
            modularStep = this.findStepTo(modularStep.getFromRevision());
        }
        return linkedList;
    }

    private Collection collectChangesInFromState(String string) throws AueException {
        HashSet<ChangeSet> hashSet = new HashSet<ChangeSet>();
        ModularStep modularStep = this.findStepTo(string);
        if (modularStep == null && !this.existsAsFromRevision(string)) {
            throw new AueException("Unknown from-revision " + string);
        }
        while (modularStep != null) {
            ChangeSet[] changeSetArray = modularStep.changes();
            for (int i = 0; i < changeSetArray.length; ++i) {
                hashSet.add(changeSetArray[i]);
            }
            modularStep = this.findStepTo(modularStep.getFromRevision());
        }
        return hashSet;
    }

    private boolean existsAsFromRevision(String string) {
        for (int i = 0; i < this.steps.length; ++i) {
            if (!this.steps[i].getFromRevision().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static class ClassComparator
    implements ChangeSetComparator {
        public boolean areEquivalent(ChangeSet changeSet, ChangeSet changeSet2) {
            return changeSet.getClass() == changeSet2.getClass();
        }
    }

    public static interface ChangeSetComparator {
        public boolean areEquivalent(ChangeSet var1, ChangeSet var2);
    }
}

