/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import se.ericsson.cello.emas.sm.applications.AddLicenseView;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Transaction;

public class AddLicenseController
extends AbstractApplicationController
implements ActionListener {
    private AddLicenseView view;
    MOProxy licensingMo;
    private String ldn = "ManagedElement=1,SystemFunctions=1";

    protected void init() {
        this.view = (AddLicenseView)this.getView();
        this.getApplication().setTitle("ADDLICENSE_APPLICATION_TITLE", null);
        this.setButtonListeners();
        this.setActionListeners();
        this.view.okButton.setEnabled(false);
    }

    private void setButtonListeners() {
        this.view.okButton.setActionListener((ActionListener)this, "OK");
        this.view.cancelButton.setActionListener((ActionListener)this, "CANCEL");
    }

    private void setActionListeners() {
        this.view.name.setActionListener((ActionListener)this, "ENTRYFIELD_FILLEDIN");
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("OK")) {
            this.addLicense();
            this.getApplication().stopApplication();
        } else if (event.getActionCommand().equals("CANCEL")) {
            this.getApplication().stopApplication();
        }
        this.setButtonStatus();
    }

    public boolean canStop() {
        return true;
    }

    public void setButtonStatus() {
        this.view.okButton.setEnabled(true);
        this.view.cancelButton.setEnabled(true);
    }

    private void addLicense() {
        Transaction createTransaction = null;
        try {
            createTransaction = new Transaction();
            this.licensingMo = new MOProxy(MOProxy.genLDN((String)this.ldn, (String)"Licensing"));
            if (this.view.name.getValue().length() > 0) {
                ArrayList<NameValue> createArgs = new ArrayList<NameValue>(1);
                createArgs.add(new NameValue("userLabel", (Object)this.view.name.getValue()));
                NameValue[] createArgsArray = createArgs.toArray(new NameValue[createArgs.size()]);
                this.licensingMo.create(createArgsArray, createTransaction.session);
                createTransaction.commit();
                createTransaction.end();
            } else {
                this.licensingMo.create(createTransaction.session);
                createTransaction.commit();
                createTransaction.end();
            }
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "SWIPEOSPFAREA_CREATE_ERROR_MSG", null);
            try {
                createTransaction.rollback();
                createTransaction.end();
            }
            catch (Exception be) {
                Log.logError((String)"Error rolling back transaction");
            }
            this.getApplication().stopApplication();
        }
    }
}

