/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import se.ericsson.cello.emas.sm.elements.ConfigurationVersionElement;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.EmasViewElementInterface;

public class RestoreWizardApplicationAction
extends AbstractAction {
    private String action;
    private String application;
    private EmasViewElementInterface element;
    private ConfigurationVersionElement CvElement;
    private static MainWindowController mainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();

    public RestoreWizardApplicationAction(String action, EmasViewElementInterface element) {
        this.action = action;
        this.element = element;
        if (this.action.equals("action.restore")) {
            this.CvElement = (ConfigurationVersionElement)element;
        }
        this.putValue("Name", element.getProperty(action + ".tag"));
        this.application = element.getProperty(action + ".application");
        if (this.application == null) {
            Log.logError((String)("Parse error: property " + action + ".application is null"));
        }
    }

    public void actionPerformed(ActionEvent event) {
        String CvIndex = null;
        String CvName = null;
        if (this.application == null) {
            Log.logError((String)"Application not defined!");
            return;
        }
        if (RestoreWizardApplicationAction.restoreWizardIsAlreadyOpen()) {
            mainWindowController.showMessageDialog("CV_RESTORE_WIZARD_ALREADY_OPEN_MSG", null, "CV_RESTORE_WIZARD_ALREADY_OPEN_TITLE", null, 1, null);
            return;
        }
        String ldn = this.element.getDN();
        if (this.action.equals("action.restore")) {
            CvIndex = this.CvElement.getElementIndex().toString();
            CvName = this.CvElement.getName();
        }
        Object[][] parameters = new Object[][]{{"LDNLIST", ldn}, {"VIEWELEMENT", this.element}, {"ACTION", this.action}, {"CV_INDEX", CvIndex}, {"CV_NAME", CvName}};
        mainWindowController.startApplication(this.application, parameters, false);
    }

    protected static boolean restoreWizardIsAlreadyOpen() {
        boolean open = false;
        Vector allApplications = mainWindowController.getApplications();
        for (int i = 0; i < allApplications.size(); ++i) {
            if (!"se.ericsson.cello.emas.sm.applications.RestoreWizardApplication".equals(allApplications.elementAt(i).getClass().getName())) continue;
            open = true;
            break;
        }
        return open;
    }
}

