/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.util.Properties;
import javax.swing.Action;
import javax.swing.ImageIcon;
import se.ericsson.cello.emas.sm.elements.ConfigurationVersionElementCreator;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementCreator;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.mgr.TimeConverter;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;

public class ConfigurationVersionElement
extends EmasViewElement {
    private Integer type;
    private String comment;
    private String userLabel;
    private static String currentLoadedCV;
    private static String currentStartableCV;
    private Struct[] cvList;
    protected Integer rollbackListPos;
    private Integer selectedCV;
    private MOProxy cvMO;

    public ConfigurationVersionElement(MOComposite moc, Properties properties, ConfigurationVersionElementCreator creator, Integer index, AttributeBuffer buffer) throws CSException {
        super(moc, properties, (EmasViewElementCreator)creator);
        this.selectedCV = index;
        this.cvMO = moc.getMO("ConfigurationVersion");
        this.cvList = (Struct[])buffer.getAttribute("storedConfigurationVersions");
        currentLoadedCV = (String)buffer.getAttribute("currentLoadedConfigurationVersion");
        currentStartableCV = (String)buffer.getAttribute("startableConfigurationVersion");
        this.refreshData();
    }

    public String getName() {
        String eName = "";
        try {
            eName = (String)this.cvList[this.selectedCV].getElementValue("name");
        }
        catch (NoSuchFieldException nfse) {
            Log.logError((String)"Error getting value for :", (Throwable)nfse);
        }
        return eName;
    }

    public Object getAttributeValue(String aName) {
        Object retVal = new Object();
        try {
            if (aName.equals("ATTR_DATE")) {
                String date = (String)this.cvList[this.selectedCV].getElementValue("date");
                retVal = new TimeConverter().formatTime(date);
            } else if (aName.equals("ATTR_TYPE")) {
                retVal = this.translate(this.cvList[this.selectedCV].getElementValue("type").toString());
            } else if (aName.equals("ATTR_OPERATOR")) {
                retVal = this.cvList[this.selectedCV].getElementValue("operatorName");
            } else if (aName.equals("ATTR_RBL_POSITION")) {
                retVal = this.rollbackListPos != null ? new Integer(this.rollbackListPos + 1) : "";
            } else if (aName.equals("ATTR_UP_BASE")) {
                retVal = (String)this.cvList[this.selectedCV].getElementValue("upgradePackageId");
            } else if (aName.equals("ATTR_USERLABEL")) {
                retVal = this.userLabel;
            }
        }
        catch (Exception e) {
            Log.logError((String)("Error getting value for :" + aName));
        }
        return retVal;
    }

    public void refresh() {
        try {
            this.refreshData();
        }
        catch (CSException e) {
            Log.logError((String)"refresh failed", (Throwable)e);
        }
    }

    private void refreshData() throws CSException {
        this.fireElementChanged();
        this.rollbackListPos = null;
        if (this.cvList.length > 0) {
            String[] rbList = null;
            rbList = (String[])this.cvMO.getAttribute("rollbackList", null);
            String name = "";
            try {
                name = (String)this.cvList[this.selectedCV].getElementValue("name");
            }
            catch (NoSuchFieldException nfse) {
                Log.logError((String)"Error no such field:", (Throwable)nfse);
            }
            if (rbList != null && rbList.length > 0) {
                for (int index = 0; index < rbList.length; ++index) {
                    if (!rbList[index].equals(name)) continue;
                    this.rollbackListPos = new Integer(index);
                }
            }
        }
        this.userLabel = (String)this.cvMO.getAttribute("userLabel", null);
        this.disableAndEnableActions();
    }

    private void disableAndEnableActions() {
        Action remove = this.getAction("REMOVE_CV_MNU");
        try {
            String cv = (String)this.cvList[this.selectedCV].getElementValue("name");
            if (cv.equals(currentStartableCV) || cv.equals(currentLoadedCV) || this.rollbackListPos != null) {
                if (remove != null) {
                    remove.setEnabled(false);
                }
                this.getAction("SET_LOADABLE_MNU").setEnabled(true);
            } else {
                if (remove != null) {
                    remove.setEnabled(true);
                }
                this.getAction("SET_LOADABLE_MNU").setEnabled(true);
            }
            if (this.rollbackListPos == null) {
                this.getAction("REMOVE_MNU").setEnabled(false);
            } else {
                this.getAction("REMOVE_MNU").setEnabled(true);
            }
        }
        catch (NoSuchFieldException nsfe) {
            Log.logError((String)"Error geting the name ", (Throwable)nsfe);
        }
    }

    public void setCVIndex(Struct[] cvList, int index) {
        this.cvList = cvList;
        this.selectedCV = new Integer(index);
    }

    public Integer getElementIndex() {
        return new Integer(this.selectedCV);
    }

    public Comparable getSortKey() {
        return this.getName();
    }

    public void setRollbackListPos(Integer index) {
        this.rollbackListPos = index;
    }

    public Integer getRollbackListPos() {
        return this.rollbackListPos;
    }

    public ImageIcon getIcon() {
        ImageIcon icon = null;
        String iconFile = null;
        String cvName = this.getName();
        iconFile = cvName.equals(currentLoadedCV) ? (cvName.equals(currentStartableCV) ? this.getProperty("icon.currentstartable") : this.getProperty("icon.current")) : (cvName.equals(currentStartableCV) ? this.getProperty("icon.startable") : this.getProperty("icon.stored"));
        try {
            icon = (ImageIcon)IconHelper.createIcon((String)iconFile);
        }
        catch (Exception e) {
            Log.logError((String)("getIcon(): Cannot create ImageIcon from file: " + iconFile), (Throwable)e);
        }
        return icon;
    }

    public void attributesChanged(MOProxy aMO, NameValue[] nameValue) {
        try {
            for (int i = 0; i < nameValue.length; ++i) {
                if (nameValue[i].name.equals("startableConfigurationVersion")) {
                    currentStartableCV = (String)nameValue[i].value;
                    this.fireViewElementUpdated();
                    this.disableAndEnableActions();
                    continue;
                }
                if (nameValue[i].name.equals("currentLoadedConfigurationVersion")) {
                    currentLoadedCV = (String)nameValue[i].value;
                    this.fireViewElementUpdated();
                    continue;
                }
                if (nameValue[i].name.equals("rollbackList")) {
                    this.fireViewElementUpdated();
                    this.disableAndEnableActions();
                    continue;
                }
                if (nameValue[i].name.equals("storedConfigurationVersions")) {
                    this.fireViewElementUpdated();
                    this.disableAndEnableActions();
                    continue;
                }
                if (!nameValue[i].name.equals("userLabel")) continue;
                this.fireViewElementUpdated();
            }
        }
        catch (Exception e) {
            Log.logError((String)"update failed", (Throwable)e);
        }
    }

    public boolean isCurrentLoadedCV() {
        return currentLoadedCV.equals(this.getName());
    }
}

