/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import se.ericsson.cello.emas.sm.elements.EmasElementCreator;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.TopologyModel;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementInterface;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class FanElementCreator
extends EmasElementCreator {
    private MOProxy swAllocation = null;
    private Hashtable fanChildElements;

    public FanElementCreator(Properties p) {
        super(p);
    }

    public void dispose() {
        if (this.swAllocation != null) {
            this.swAllocation.removeMOListener((MOProxy.MOListener)this);
        }
    }

    public AbstractViewElement[] createInstances(AbstractViewElement parent) {
        MOProxy[] fanList = null;
        Vector<EmasViewElementInterface> newElements = new Vector<EmasViewElementInterface>();
        EmasViewElementInterface parentElement = (EmasViewElementInterface)parent;
        this.swAllocation = ((EmasViewElement)parentElement).getMO("SwAllocation");
        String dn = this.swAllocation.getDN();
        Log.trace((String)("parent LDN=" + this.swAllocation.getDN()));
        if (this.parentElements.containsKey(dn)) {
            Log.trace((String)"already subscribed");
        } else {
            this.parentElements.put(dn, parentElement);
            this.swAllocation.addMOListener((MOProxy.MOListener)this);
            Log.trace((String)("addMOListener to LDN=" + this.swAllocation.getDN()));
        }
        try {
            fanList = (MOProxy[])this.swAllocation.getAttribute("slotList", null);
        }
        catch (CSException e) {
            Log.logError((String)(((Object)((Object)this)).getClass().getName() + "::createInstances failed"), (Throwable)e);
            return newElements.toArray(new AbstractViewElement[0]);
        }
        for (int index = 0; index < fanList.length; ++index) {
            if (!fanList[index].getType().equals("Fan")) continue;
            EmasViewElementInterface newElement = null;
            try {
                newElement = this.createFanElement(fanList[index]);
                if (newElement == null) continue;
                newElements.add(newElement);
                this.addElement(newElement);
                continue;
            }
            catch (Exception e) {
                Log.logError((String)("Fan Element " + this.getClassName() + " could not be created"), (Throwable)e);
            }
        }
        return newElements.toArray(new AbstractViewElement[0]);
    }

    public void attributesChanged(MOProxy anMO, NameValue[] nameValue) {
        AbstractViewElement swa = (AbstractViewElement)this.parentElements.get(anMO.getDN());
        MOProxy[] fanList = null;
        try {
            for (int i = 0; i < nameValue.length; ++i) {
                if (!nameValue[i].name.equals("slotList")) continue;
                fanList = Array.getLength(nameValue[i].value) > 0 ? (MOProxy[])nameValue[i].value : new MOProxy[]{};
                this.updateSwAllocation(swa, fanList);
            }
        }
        catch (Exception e) {
            Log.logError((String)"update failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSwAllocation(AbstractViewElement swa, MOProxy[] fanList) {
        if (fanList != null) {
            AbstractViewElement abstractViewElement = swa;
            synchronized (abstractViewElement) {
                TopologyModel topologyModel = swa.getModel();
                synchronized (topologyModel) {
                    AbstractViewElement[] children = swa.getChildren();
                    Vector<MOProxy> fans = new Vector<MOProxy>(Arrays.asList(fanList));
                    for (int i = 0; i < children.length; ++i) {
                        EmasViewElement child = (EmasViewElement)children[i];
                        if (child.getMO("Fan") != null) {
                            if (fans.contains(child.getMO("Fan"))) {
                                fans.remove(child.getMO("Fan"));
                                continue;
                            }
                            swa.removeChild((AbstractViewElement)child);
                            this.deleteElement((EmasViewElementInterface)child);
                            continue;
                        }
                        if (!fans.contains(child.getMO("Slot"))) continue;
                        fans.remove(child.getMO("Slot"));
                    }
                    MOProxy[] newFans = fans.toArray(new MOProxy[0]);
                    for (int i = 0; i < newFans.length; ++i) {
                        MOProxy fan = newFans[i];
                        if (!fan.getType().equals("Fan")) continue;
                        EmasViewElementInterface newElement = this.createFanElement(fan);
                        swa.addChild((AbstractViewElement)newElement);
                        this.addElement(newElement);
                    }
                }
            }
        }
    }

    private EmasViewElementInterface createFanElement(MOProxy fan) {
        EmasViewElementInterface newElement = null;
        try {
            MOComposite moc = new MOComposite();
            moc.add(fan);
            this.fanChildElements = new Hashtable();
            MOProxy childElement = fan;
            String key = fan.getDN();
            this.fanChildElements.put(key, childElement);
            Object[] args = new Object[]{moc, this.getProperties(), this};
            Class<?> c = Class.forName(this.getClassName());
            Vector v = new Vector();
            for (int i = 0; i < args.length; ++i) {
                v.add(args[i].getClass());
            }
            Constructor<?> constructor = c.getConstructor(v.toArray(new Class[0]));
            newElement = (EmasViewElementInterface)constructor.newInstance(args);
        }
        catch (Exception e) {
            Log.logError((String)("Fan Element " + this.getClassName() + " could not be created"), (Throwable)e);
        }
        return newElement;
    }
}

