/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.common;

import java.io.BufferedInputStream;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ExternalCommandHelper {
    private static final Class THIS_CLASS = ExternalCommandHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private ExternalCommandHelper() {
    }

    public static CommandOutput runCommand(String command) {
        logger.traceEnter(THIS_CLASS, "runCommand(" + command + ")");
        StringBuffer stdOut = new StringBuffer();
        StringBuffer stdErr = new StringBuffer();
        try {
            Process process = Runtime.getRuntime().exec(command);
            process.waitFor();
            byte[] chunk = new byte[1024];
            BufferedInputStream stdOutStream = new BufferedInputStream(process.getInputStream());
            int readLength = stdOutStream.read(chunk);
            while (readLength > 0) {
                stdOut.append(new String(chunk, 0, readLength));
                readLength = stdOutStream.read(chunk);
            }
            BufferedInputStream stdErrStream = new BufferedInputStream(process.getErrorStream());
            int readLength2 = stdErrStream.read(chunk);
            while (readLength2 > 0) {
                stdErr.append(new String(chunk, 0, readLength2));
                readLength2 = stdErrStream.read(chunk);
            }
        }
        catch (Exception e) {
            stdErr.append(ExceptionHelper.convertToString((Throwable)e));
        }
        logger.traceReturn(THIS_CLASS, "runCommand(" + command + ")");
        return new CommandOutput(command, stdOut, stdErr);
    }

    public static class CommandOutput {
        public final String command;
        public final String stdOut;
        public final String stdErr;

        public CommandOutput(String inputCommand, StringBuffer inputStdOut, StringBuffer inputStdErr) {
            this.command = inputCommand;
            this.stdOut = inputStdOut.toString();
            this.stdErr = inputStdErr.toString();
        }
    }
}

