/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.common.StringHelper;

public class FileHelper
extends se.ericsson.crbs.common.FileHelper {
    public static final String AVOID_PMD = "";

    private FileHelper() {
    }

    public static String getFileContents(File fileToRead) throws IOException {
        FileInputStream fis = new FileInputStream(fileToRead);
        byte[] chunk = new byte[1024];
        int readLength = 0;
        StringBuffer fileContents = new StringBuffer((int)(fileToRead.length() + 10L));
        readLength = fis.read(chunk);
        while (readLength > 0) {
            fileContents.append(new String(chunk, 0, readLength));
            readLength = fis.read(chunk);
        }
        fis.close();
        return fileContents.toString();
    }

    public static String getInitialFileContents(File fileToRead, long numberOfBytesToRead) throws IOException {
        long truncatedBytesToRead = Math.min(numberOfBytesToRead, fileToRead.length());
        FileInputStream fis = new FileInputStream(fileToRead);
        int chunkSize = 1024;
        if (truncatedBytesToRead < (long)chunkSize) {
            chunkSize = (int)truncatedBytesToRead;
        }
        byte[] chunk = new byte[chunkSize];
        int readLength = 0;
        StringBuffer fileContents = new StringBuffer();
        long writtenNumberOfBytes = 0L;
        readLength = fis.read(chunk);
        while (readLength > 0) {
            if (writtenNumberOfBytes + (long)readLength > truncatedBytesToRead) {
                int lengthToWrite = (int)(truncatedBytesToRead - writtenNumberOfBytes);
                fileContents.append(new String(chunk, 0, lengthToWrite));
                writtenNumberOfBytes += (long)lengthToWrite;
            } else {
                fileContents.append(new String(chunk, 0, readLength));
                writtenNumberOfBytes += (long)readLength;
            }
            if (writtenNumberOfBytes >= truncatedBytesToRead) break;
            readLength = fis.read(chunk);
        }
        fis.close();
        return fileContents.toString();
    }

    public static void deleteFilesInDirectory(File directory) throws FileHelper.FileException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new FileHelper.FileException("Deletion must start from a directory.");
            }
            List<File> list = Arrays.asList(directory.listFiles());
            for (int i = 0; i < list.size(); ++i) {
                File file = list.get(i);
                if (!file.isFile() || file.delete()) continue;
                throw new FileHelper.FileException("Could not delete file: " + StringHelper.doubleQuote((String)file.getPath()));
            }
        }
    }

    public static void deleteFilesInDirectory(String fileExtension, File directory) throws FileHelper.FileException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new FileHelper.FileException("Deletion must start from a directory.");
            }
            List<File> list = Arrays.asList(directory.listFiles());
            for (int i = 0; i < list.size(); ++i) {
                File file = list.get(i);
                if (!file.isFile() || !file.getName().toLowerCase(Locale.getDefault()).endsWith(fileExtension.toLowerCase(Locale.getDefault())) || file.delete()) continue;
                throw new FileHelper.FileException("Could not delete file: " + StringHelper.doubleQuote((String)file.getPath()));
            }
        }
    }
}

