/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.crbs.cat.common.FileHelper;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.AntennaSystemConfigurationFailedException;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaNearUnitData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaSubUnitData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaSystemData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaUnitData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaUnitGroupData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AuPortData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AuPortRefData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.ExtTmaConnectorData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.ExternalTmaData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.RetSubUnitData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.RfBranchData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.TmaSubUnitData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.helper.AntennaSystemConfigurationHelper;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.helper.AntennaSystemConfigurationParserHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.ParserFactory;
import se.ericsson.crbs.omf.mao.xml.ParserFactoryImpl;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class AntennaSystemDataFinder {
    private final ParserFactory parserFactory = new ParserFactoryImpl();
    private MoRepositoryWrapper aMoRepository;
    private static final Class THIS_CLASS = AntennaSystemDataFinder.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public AntennaSystemData parseAntennaSystemXmlFile(String filePath, MoRepositoryWrapper inputMoRepository) throws IOException, AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "parseAntennaSystemXmlFile()");
        this.aMoRepository = inputMoRepository;
        AntennaSystemData antennaSystemData = null;
        String fileDir = FileHelper.extractFileDirFromFilePath((String)filePath);
        String fileName = FileHelper.extractFileNameFromFilePath((String)filePath);
        Parser parser = this.parserFactory.createParser(fileName, fileDir);
        List xmlList = parser.getXMLelements();
        Iterator xmlIter = xmlList.iterator();
        while (xmlIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlIter.next();
            if (!"CommonAntennaSystem".equalsIgnoreCase(xmlChild.getType())) continue;
            antennaSystemData = this.parseAntennaSystemData(xmlChild);
        }
        if (antennaSystemData != null) {
            AntennaSystemConfigurationParserHelper.checkMandatoryAttribute("CommonAntennaSystem", antennaSystemData);
        }
        logger.traceReturn(THIS_CLASS, "parseAntennaSystemXmlFile()");
        return antennaSystemData;
    }

    protected Parser createParser(String filePath) throws IOException {
        File xmlFile = new File(filePath);
        if (!xmlFile.exists()) {
            throw new IOException("Unable to find file: " + filePath);
        }
        if (xmlFile.isDirectory()) {
            throw new IOException("Provided path is not a file! " + filePath);
        }
        String fileDir = FileHelper.extractFileDirFromFilePath((String)filePath);
        String fileName = FileHelper.extractFileNameFromFilePath((String)filePath);
        return this.parserFactory.createParser(fileName, fileDir);
    }

    private AntennaSystemData parseAntennaSystemData(XMLElement xmlElement) throws IOException, AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "parseAntennaSystemData()");
        Object[] antennaUnitGroupData = null;
        List xmlChildren = xmlElement.getChildren();
        Iterator xmlChildIter = xmlChildren.iterator();
        ArrayList<AntennaUnitGroupData> antennaUnitGroupList = new ArrayList<AntennaUnitGroupData>();
        while (xmlChildIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlChildIter.next();
            String xmlChildType = xmlChild.getType();
            if (!"AntennaUnitGroup".equalsIgnoreCase(xmlChildType)) continue;
            AntennaUnitGroupData antennaUnitGroup = this.parseAntennaUnitGroupData(xmlChild);
            antennaUnitGroupList.add(antennaUnitGroup);
        }
        if (!antennaUnitGroupList.isEmpty()) {
            antennaUnitGroupData = new AntennaUnitGroupData[antennaUnitGroupList.size()];
            antennaUnitGroupData = (AntennaUnitGroupData[])antennaUnitGroupList.toArray(antennaUnitGroupData);
        }
        AntennaSystemConfigurationParserHelper.checkCardinality("CommonAntennaSystem.AntennaUnitGroup", antennaUnitGroupData, 0, 24);
        AntennaSystemData antennaSystemData = new AntennaSystemData((AntennaUnitGroupData[])antennaUnitGroupData);
        logger.traceReturn(THIS_CLASS, "parseAntennaSystemData()");
        return antennaSystemData;
    }

    private AntennaUnitGroupData parseAntennaUnitGroupData(XMLElement xmlElement) throws IOException, AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "parseAntennaUnitGroupData()");
        String antennaUnitGroupId = null;
        AttributesImpl attributes = xmlElement.getAttributes();
        antennaUnitGroupId = this.parseAntennaUnitGroupId(attributes);
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.antennaUnitGroupId", (String)antennaUnitGroupId);
        ArrayList<AntennaUnitData> antennaUnitList = new ArrayList<AntennaUnitData>();
        ArrayList<RfBranchData> rfBranchList = new ArrayList<RfBranchData>();
        ArrayList<AntennaNearUnitData> antennaNearUnitList = new ArrayList<AntennaNearUnitData>();
        ArrayList<ExternalTmaData> externalTmaList = new ArrayList<ExternalTmaData>();
        List xmlChildren = xmlElement.getChildren();
        Iterator xmlChildIter = xmlChildren.iterator();
        while (xmlChildIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlChildIter.next();
            String xmlChildType = xmlChild.getType();
            if ("AntennaUnit".equalsIgnoreCase(xmlChildType)) {
                AntennaUnitData aud = this.parseAntennaUnitData(xmlChild);
                antennaUnitList.add(aud);
                continue;
            }
            if ("RfBranch".equalsIgnoreCase(xmlChildType)) {
                RfBranchData rbd = this.parseRfBranchData(xmlChild);
                rfBranchList.add(rbd);
                continue;
            }
            if ("AntennaNearUnit".equalsIgnoreCase(xmlChildType)) {
                AntennaNearUnitData anud = this.parseAntennaNearUnitData(xmlChild);
                antennaNearUnitList.add(anud);
                continue;
            }
            if (!"ExternalTMA".equalsIgnoreCase(xmlChildType)) continue;
            ExternalTmaData etd = this.parseExternalTmaData(xmlChild);
            externalTmaList.add(etd);
        }
        Object[] antennaUnitData = new AntennaUnitData[antennaUnitList.size()];
        antennaUnitList.toArray(antennaUnitData);
        Object[] rfBranchData = new RfBranchData[rfBranchList.size()];
        rfBranchList.toArray(rfBranchData);
        Object[] antennaNearUnitData = new AntennaNearUnitData[antennaNearUnitList.size()];
        antennaNearUnitList.toArray(antennaNearUnitData);
        Object[] externalTmaData = new ExternalTmaData[externalTmaList.size()];
        externalTmaList.toArray(externalTmaData);
        AntennaSystemConfigurationParserHelper.checkCardinality("CommonAntennaSystem.AntennaUnitGroup.AntennaUnit", antennaUnitData, 1, 8);
        AntennaSystemConfigurationParserHelper.checkCardinality("CommonAntennaSystem.AntennaUnitGroup.RfBranch", rfBranchData, 1, 24);
        AntennaSystemConfigurationParserHelper.checkCardinality("CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit", antennaNearUnitData, 0, 48);
        AntennaSystemConfigurationParserHelper.checkCardinality("CommonAntennaSystem.AntennaUnitGroup.ExternalTMA", externalTmaData, 0, 24);
        AntennaUnitGroupData antennaUnitGroupData = new AntennaUnitGroupData((AntennaUnitData[])antennaUnitData, (RfBranchData[])rfBranchData, (AntennaNearUnitData[])antennaNearUnitData, (ExternalTmaData[])externalTmaData, antennaUnitGroupId);
        logger.traceReturn(THIS_CLASS, "parseAntennaUnitGroupData()");
        return antennaUnitGroupData;
    }

    private String parseAntennaUnitGroupId(AttributesImpl attributes) {
        logger.traceEnter(THIS_CLASS, "parseAntennaUnitGroupId()");
        String antennaUnitGroupId = null;
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!"antennaUnitGroupId".equalsIgnoreCase(attributes.getQName(index))) continue;
            antennaUnitGroupId = StringHelper.emptyStringToNull((String)attributes.getValue(index));
        }
        logger.traceReturn(THIS_CLASS, "parseAntennaUnitGroupId()");
        return antennaUnitGroupId;
    }

    private AntennaUnitData parseAntennaUnitData(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseAntennaUnitData()");
        String antennaUnitId = null;
        String defaultmechanicalAntennaTilt = "0";
        String mechanicalAntennaTilt = "0";
        AttributesImpl attributes = xmlElement.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            if ("antennaUnitId".equalsIgnoreCase(attributes.getQName(index))) {
                antennaUnitId = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if (!"mechanicalAntennaTilt".equalsIgnoreCase(attributes.getQName(index))) continue;
            mechanicalAntennaTilt = StringHelper.emptyStringToDefault((String)attributes.getValue(index), (String)"0");
        }
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaUnit.antennaUnitId", antennaUnitId);
        AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaUnit.mechanicalAntennaTilt", (String)mechanicalAntennaTilt);
        Object[] antennaSubUnitData = null;
        ArrayList<AntennaSubUnitData> antennaSubUnitList = new ArrayList<AntennaSubUnitData>();
        List xmlChildren = xmlElement.getChildren();
        Iterator xmlChildIter = xmlChildren.iterator();
        while (xmlChildIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlChildIter.next();
            String xmlChildType = xmlChild.getType();
            if (!"AntennaSubUnit".equalsIgnoreCase(xmlChildType)) continue;
            AntennaSubUnitData asud = this.parseAntennaSubUnitData(xmlChild);
            antennaSubUnitList.add(asud);
        }
        if (!antennaSubUnitList.isEmpty()) {
            antennaSubUnitData = new AntennaSubUnitData[antennaSubUnitList.size()];
            antennaSubUnitData = (AntennaSubUnitData[])antennaSubUnitList.toArray(antennaSubUnitData);
        }
        AntennaSystemConfigurationParserHelper.checkCardinality("CommonAntennaSystem.AntennaUnitGroup.AntennaUnit.AntennaSubUnit", antennaSubUnitData, 0, 8);
        AntennaUnitData antennaUnitData = new AntennaUnitData((AntennaSubUnitData[])antennaSubUnitData, antennaUnitId, AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"", (String)mechanicalAntennaTilt));
        logger.traceReturn(THIS_CLASS, "parseAntennaUnitData()");
        return antennaUnitData;
    }

    private AntennaSubUnitData parseAntennaSubUnitData(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseAntennaSubUnitData()");
        String antennaSubUnitId = null;
        String defaultMinTotalTilt = "0";
        String defaultMaxTotalTilt = "0";
        String minTotalTilt = "0";
        String maxTotalTilt = "0";
        AttributesImpl attributes = xmlElement.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            if ("antennaSubUnitId".equalsIgnoreCase(attributes.getQName(index))) {
                antennaSubUnitId = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("minTotalTilt".equalsIgnoreCase(attributes.getQName(index))) {
                minTotalTilt = StringHelper.emptyStringToDefault((String)attributes.getValue(index), (String)"0");
                continue;
            }
            if (!"maxTotalTilt".equalsIgnoreCase(attributes.getQName(index))) continue;
            maxTotalTilt = StringHelper.emptyStringToDefault((String)attributes.getValue(index), (String)"0");
        }
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaUnit.AntennaSubUnit.antennaSubUnitId", antennaSubUnitId);
        ArrayList<AuPortData> auPortList = new ArrayList<AuPortData>();
        List xmlChildren = xmlElement.getChildren();
        Iterator xmlChildIter = xmlChildren.iterator();
        while (xmlChildIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlChildIter.next();
            String xmlChildType = xmlChild.getType();
            if (!"AuPort".equalsIgnoreCase(xmlChildType)) continue;
            AuPortData apd = this.parseAuPortData(xmlChild);
            auPortList.add(apd);
        }
        Object[] auPortData = new AuPortData[auPortList.size()];
        auPortList.toArray(auPortData);
        AntennaSystemConfigurationParserHelper.checkCardinality("CommonAntennaSystem.AntennaUnitGroup.AntennaUnit.AntennaSubUnit.AuPort", auPortData, 0, 8);
        AntennaSubUnitData antennaSubUnitData = new AntennaSubUnitData((AuPortData[])auPortData, antennaSubUnitId, AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)minTotalTilt), AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)maxTotalTilt));
        logger.traceReturn(THIS_CLASS, "parseAntennaSubUnitData()");
        return antennaSubUnitData;
    }

    private AuPortData parseAuPortData(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseAuPortData()");
        String auPortId = null;
        AttributesImpl attributes = xmlElement.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!"auPortId".equalsIgnoreCase(attributes.getQName(index))) continue;
            auPortId = StringHelper.emptyStringToNull((String)attributes.getValue(index));
        }
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaUnit.AntennaSubUnit.AuPort.auPortId", auPortId);
        AuPortData auPortData = new AuPortData(auPortId);
        logger.traceReturn(THIS_CLASS, "parseAuPortData()");
        return auPortData;
    }

    private RfBranchData parseRfBranchData(XMLElement xmlElement) throws IOException, AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "parseRfBranchData()");
        String rfBranchId = null;
        String rfPortRef = null;
        String strDlAttenuation = null;
        String strUlAttenuation = null;
        String strDlTrafficDelay = null;
        String strUlTrafficDelay = null;
        String defaultVswrSupervisionActive = "NO";
        String vswrSupervisionActive = "NO";
        String defaultVswrSupervisionSensitivity = "1";
        String vswrSupervisionSensitivity = "1";
        AttributesImpl attributes = xmlElement.getAttributes();
        rfBranchId = StringHelper.emptyStringToNull((String)attributes.getValue("rfBranchId"));
        rfPortRef = StringHelper.emptyStringToNull((String)attributes.getValue("rfPortRef"));
        strDlAttenuation = StringHelper.emptyStringToNull((String)attributes.getValue("dlAttenuation"));
        strUlAttenuation = StringHelper.emptyStringToNull((String)attributes.getValue("ulAttenuation"));
        String dlTrafficDelay = attributes.getValue("dlTrafficDelay");
        String trafficDlDelay = attributes.getValue("trafficDlDelay");
        strDlTrafficDelay = dlTrafficDelay == null ? StringHelper.emptyStringToNull((String)trafficDlDelay) : StringHelper.emptyStringToNull((String)dlTrafficDelay);
        String ulTrafficDelay = attributes.getValue("ulTrafficDelay");
        String trafficUlDelay = attributes.getValue("trafficUlDelay");
        strUlTrafficDelay = ulTrafficDelay == null ? StringHelper.emptyStringToNull((String)trafficUlDelay) : StringHelper.emptyStringToNull((String)ulTrafficDelay);
        vswrSupervisionActive = StringHelper.emptyStringToDefault((String)attributes.getValue("vswrSupervisionActive"), (String)"NO");
        vswrSupervisionSensitivity = StringHelper.emptyStringToDefault((String)attributes.getValue("vswrSupervisionSensitivity"), (String)"1");
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.RfBranch.rfBranchId", (String)rfBranchId);
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.RfBranch.rfPortRef", (String)rfPortRef);
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.RfBranch.dlAttenuation", (String)strDlAttenuation);
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.RfBranch.ulAttenuation", (String)strUlAttenuation);
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.RfBranch.dlTrafficDelay", (String)strDlTrafficDelay);
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.RfBranch.ulTrafficDelay", (String)strUlTrafficDelay);
        Integer[] dlAttenuationArray = AntennaSystemConfigurationHelper.stringToIntArray("CommonAntennaSystem.AntennaUnitGroup.RfBranch.dlAttenuation", strDlAttenuation);
        Integer[] ulAttenuationArray = AntennaSystemConfigurationHelper.stringToIntArray("CommonAntennaSystem.AntennaUnitGroup.RfBranch.ulAttenuation", strUlAttenuation);
        Integer[] dlTrafficDelayArray = AntennaSystemConfigurationHelper.stringToIntArray("CommonAntennaSystem.AntennaUnitGroup.RfBranch.dlTrafficDelay", strDlTrafficDelay);
        Integer[] ulTrafficDelayArray = AntennaSystemConfigurationHelper.stringToIntArray("CommonAntennaSystem.AntennaUnitGroup.RfBranch.ulTrafficDelay", strUlTrafficDelay);
        Object[] auPortRefData = this.getAuPortRefChildren(xmlElement);
        AntennaSystemConfigurationParserHelper.checkCardinality("CommonAntennaSystem.AntennaUnitGroup.RfBranch.AuPortRef", auPortRefData, 0, 4);
        RfBranchData rfBranchData = new RfBranchData(this.aMoRepository, (AuPortRefData[])auPortRefData, rfBranchId, rfPortRef, dlAttenuationArray, ulAttenuationArray, dlTrafficDelayArray, ulTrafficDelayArray, AntennaSystemConfigurationParserHelper.convertOptionBoolean((String)"vswrSupervisionActive", (String)vswrSupervisionActive), AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"vswrSupervisionSensitivity", (String)vswrSupervisionSensitivity));
        logger.traceReturn(THIS_CLASS, "parseRfBranchData()");
        return rfBranchData;
    }

    private AuPortRefData[] getAuPortRefChildren(XMLElement xmlElement) throws IOException {
        ArrayList<AuPortRefData> auPortRefList = new ArrayList<AuPortRefData>();
        List xmlChildren = xmlElement.getChildren();
        Iterator xmlChildIter = xmlChildren.iterator();
        while (xmlChildIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlChildIter.next();
            String xmlChildType = xmlChild.getType();
            if (!"AuPortRef".equalsIgnoreCase(xmlChildType)) continue;
            AuPortRefData aprd = this.parseAuPortRefData(xmlChild);
            auPortRefList.add(aprd);
        }
        AuPortRefData[] auPortRefData = new AuPortRefData[auPortRefList.size()];
        auPortRefList.toArray(auPortRefData);
        return auPortRefData;
    }

    private AntennaNearUnitData parseAntennaNearUnitData(XMLElement xmlElement) throws IOException, AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "parseAntennaNearUnitData()");
        String antennaNearUnitId = null;
        String rfPortRef = null;
        String defaultAnuType = "IUANT";
        String strAnuType = "IUANT";
        String iuantDeviceType = null;
        String uniqueId = null;
        AttributesImpl attributes = xmlElement.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            if ("antennaNearUnitId".equalsIgnoreCase(attributes.getQName(index))) {
                antennaNearUnitId = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("rfPortRef".equalsIgnoreCase(attributes.getQName(index))) {
                rfPortRef = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("anuType".equalsIgnoreCase(attributes.getQName(index))) {
                strAnuType = StringHelper.emptyStringToDefault((String)attributes.getValue(index), (String)"IUANT");
                continue;
            }
            if ("iuantDeviceType".equalsIgnoreCase(attributes.getQName(index))) {
                iuantDeviceType = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if (!"uniqueId".equalsIgnoreCase(attributes.getQName(index))) continue;
            uniqueId = StringHelper.emptyStringToNull((String)attributes.getValue(index));
        }
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.antennaNearUnitId", antennaNearUnitId);
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.rfPortRef", rfPortRef);
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.iuantDeviceType", iuantDeviceType);
        Integer anuType = this.convertAnuType(strAnuType);
        Integer intIuantDeviceType = AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.iuantDeviceType", iuantDeviceType);
        ArrayList tmaSubUnitList = new ArrayList();
        ArrayList retSubUnitList = new ArrayList();
        this.getRetAndTmaChildren(xmlElement, tmaSubUnitList, retSubUnitList);
        Object[] retSubUnitData = new RetSubUnitData[retSubUnitList.size()];
        retSubUnitList.toArray(retSubUnitData);
        Object[] tmaSubUnitData = new TmaSubUnitData[tmaSubUnitList.size()];
        tmaSubUnitList.toArray(tmaSubUnitData);
        this.checkRetTma((RetSubUnitData[])retSubUnitData, (TmaSubUnitData[])tmaSubUnitData);
        AntennaSystemConfigurationParserHelper.checkCardinality("CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.RetSubUnit", retSubUnitData, 0, 8);
        AntennaSystemConfigurationParserHelper.checkCardinality("CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.TmaSubUnit", tmaSubUnitData, 0, 4);
        AntennaNearUnitData antennaNearUnitData = new AntennaNearUnitData(this.aMoRepository, (TmaSubUnitData[])tmaSubUnitData, (RetSubUnitData[])retSubUnitData, antennaNearUnitId, rfPortRef, anuType, intIuantDeviceType, uniqueId);
        logger.traceReturn(THIS_CLASS, "parseAntennaNearUnitData()");
        return antennaNearUnitData;
    }

    private void getRetAndTmaChildren(XMLElement xmlElement, List tmaSubUnitList, List retSubUnitList) throws IOException, AntennaSystemConfigurationFailedException {
        List xmlChildren = xmlElement.getChildren();
        Iterator xmlChildIter = xmlChildren.iterator();
        while (xmlChildIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlChildIter.next();
            String xmlChildType = xmlChild.getType();
            if ("RetSubUnit".equalsIgnoreCase(xmlChildType)) {
                RetSubUnitData rsud = this.parseRetSubUnitData(xmlChild);
                retSubUnitList.add(rsud);
                continue;
            }
            if (!"TmaSubUnit".equalsIgnoreCase(xmlChildType)) continue;
            TmaSubUnitData tsud = this.parseTmaSubUnitData(xmlChild);
            tmaSubUnitList.add(tsud);
        }
    }

    private void checkRetTma(RetSubUnitData[] ret, TmaSubUnitData[] tma) throws IOException {
        if (ret != null && ret.length > 0 && tma != null && tma.length > 0) {
            throw new IOException("Invalid XML file: Only one of either RetSubUnit and TmaSubUnit can exist.");
        }
    }

    private Integer convertAnuType(String strAnuType) throws IOException {
        Integer result2 = null;
        if (!"IUANT".equalsIgnoreCase(strAnuType)) {
            throw new IOException("Invalid XML file: CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.anuType is not a correct value.");
        }
        result2 = new Integer(0);
        return result2;
    }

    private RetSubUnitData parseRetSubUnitData(XMLElement xmlElement) throws IOException, AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "parseRetSubUnitData()");
        String retSubUnitId = null;
        String antennaSubUnitRef = null;
        String defaultElecricalAntennaTilt = "0";
        String elecricalAntennaTilt = "0";
        String defaultAntennaConfigurationFile = "";
        String antennaConfigurationFile = "";
        AttributesImpl attributes = xmlElement.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            if ("retSubUnitId".equalsIgnoreCase(attributes.getQName(index))) {
                retSubUnitId = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("antennaSubUnitRef".equalsIgnoreCase(attributes.getQName(index))) {
                antennaSubUnitRef = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("electricalAntennaTilt".equalsIgnoreCase(attributes.getQName(index))) {
                elecricalAntennaTilt = StringHelper.emptyStringToDefault((String)attributes.getValue(index), (String)"0");
                continue;
            }
            if (!"antennaConfigurationFile".equalsIgnoreCase(attributes.getQName(index))) continue;
            antennaConfigurationFile = StringHelper.emptyStringToDefault((String)attributes.getValue(index), (String)"");
        }
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.RetSubUnit.retSubUnitId", retSubUnitId);
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.RetSubUnit.antennaSubUnitRef", antennaSubUnitRef);
        Integer intElecricalAntennaTilt = AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.RetSubUnit.electricalAntennaTilt", (String)elecricalAntennaTilt);
        RetSubUnitData retSubUnitData = new RetSubUnitData(retSubUnitId, antennaSubUnitRef, intElecricalAntennaTilt, antennaConfigurationFile);
        logger.traceReturn(THIS_CLASS, "parseRetSubUnitData()");
        return retSubUnitData;
    }

    private TmaSubUnitData parseTmaSubUnitData(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseTmaSubUnitData()");
        String tmaSubUnitId = null;
        String rfBranchRef = null;
        String dlAttenuation = null;
        String dlTrafficDelay = null;
        String ulTrafficDelay = null;
        String tmaType = null;
        AttributesImpl attributes = xmlElement.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            if ("tmaSubUnitId".equalsIgnoreCase(attributes.getQName(index))) {
                tmaSubUnitId = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("rfBranchRef".equalsIgnoreCase(attributes.getQName(index))) {
                rfBranchRef = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("dlAttenuation".equalsIgnoreCase(attributes.getQName(index))) {
                dlAttenuation = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("dlTrafficDelay".equalsIgnoreCase(attributes.getQName(index))) {
                dlTrafficDelay = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("ulTrafficDelay".equalsIgnoreCase(attributes.getQName(index))) {
                ulTrafficDelay = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if (!"tmaType".equalsIgnoreCase(attributes.getQName(index))) continue;
            tmaType = StringHelper.emptyStringToNull((String)attributes.getValue(index));
        }
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.TmaSubUnit.tmaSubUnitId", tmaSubUnitId);
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.TmaSubUnit.rfBranchRef", rfBranchRef);
        Integer intDlAttenuation = AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.TmaSubUnit.dlAttenuation", dlAttenuation);
        Integer intDlTrafficDelay = AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.TmaSubUnit.dlTrafficDelay", dlTrafficDelay);
        Integer intUlTrafficDelay = AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.TmaSubUnit.ulTrafficDelay", ulTrafficDelay);
        Integer intTmaType = AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.AntennaNearUnit.TmaSubUnit.tmaType", tmaType);
        TmaSubUnitData retSubUnitData = new TmaSubUnitData(tmaSubUnitId, rfBranchRef, intDlAttenuation, intDlTrafficDelay, intUlTrafficDelay, intTmaType);
        logger.traceReturn(THIS_CLASS, "parseTmaSubUnitData()");
        return retSubUnitData;
    }

    private AuPortRefData parseAuPortRefData(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseAuPortRefData()");
        String auPortId = null;
        AttributesImpl attributes = xmlElement.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!"auPortId".equalsIgnoreCase(attributes.getQName(index))) continue;
            auPortId = StringHelper.emptyStringToNull((String)attributes.getValue(index));
        }
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.RfBranch.AuPortRef.auPortId", auPortId);
        AuPortRefData auPortRefData = new AuPortRefData(auPortId);
        logger.traceReturn(THIS_CLASS, "parseAuPortRefData()");
        return auPortRefData;
    }

    private ExternalTmaData parseExternalTmaData(XMLElement xmlElement) throws IOException, AntennaSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "parseExternalTmaData()");
        String externalTmaId = null;
        String rfPortRef = null;
        String defaultInternalPower = "NO";
        String internalPower = "NO";
        String defaultTmaDegradedSupporteded = "NO";
        String tmaDegradedSupporteded = "NO";
        String defaultPowerSupervisionSupported = "NO";
        String powerSupervisionSupported = "NO";
        AttributesImpl attributes = xmlElement.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            if ("externalTmaId".equalsIgnoreCase(attributes.getQName(index))) {
                externalTmaId = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("rfPortRef".equalsIgnoreCase(attributes.getQName(index))) {
                rfPortRef = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("internalPower".equalsIgnoreCase(attributes.getQName(index))) {
                internalPower = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("tmaDegradedSupported".equalsIgnoreCase(attributes.getQName(index))) {
                tmaDegradedSupporteded = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if (!"powerSupervisionSupported".equalsIgnoreCase(attributes.getQName(index))) continue;
            powerSupervisionSupported = StringHelper.emptyStringToDefault((String)attributes.getValue(index), (String)"NO");
        }
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.ExternalTMA.externalTmaId", externalTmaId);
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.ExternalTMA.rfPortRef", rfPortRef);
        Object[] extTmaConnectorData = this.getExternalTmaChildren(xmlElement);
        AntennaSystemConfigurationParserHelper.checkCardinality("CommonAntennaSystem.AntennaUnitGroup.ExternalTMA.ExtTmaConnector", extTmaConnectorData, 0, 2);
        ExternalTmaData externalTmaData = new ExternalTmaData(this.aMoRepository, (ExtTmaConnectorData[])extTmaConnectorData, externalTmaId, rfPortRef, AntennaSystemConfigurationParserHelper.convertOptionBoolean((String)"internalPower", (String)internalPower), AntennaSystemConfigurationParserHelper.convertOptionBoolean((String)"tmaDegradedSupported", (String)tmaDegradedSupporteded), AntennaSystemConfigurationParserHelper.convertOptionBoolean((String)"powerSupervisionSupported", (String)powerSupervisionSupported));
        logger.traceReturn(THIS_CLASS, "parseExternalTmaData()");
        return externalTmaData;
    }

    private ExtTmaConnectorData[] getExternalTmaChildren(XMLElement xmlElement) throws IOException {
        ArrayList<ExtTmaConnectorData> extTmaConnectorList = new ArrayList<ExtTmaConnectorData>();
        List xmlChildren = xmlElement.getChildren();
        Iterator xmlChildIter = xmlChildren.iterator();
        while (xmlChildIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlChildIter.next();
            String xmlChildType = xmlChild.getType();
            if (!"ExtTmaConnector".equalsIgnoreCase(xmlChildType)) continue;
            ExtTmaConnectorData etcd = this.parseExtTmaConnectorData(xmlChild);
            extTmaConnectorList.add(etcd);
        }
        ExtTmaConnectorData[] extTmaConnectorData = new ExtTmaConnectorData[extTmaConnectorList.size()];
        extTmaConnectorList.toArray(extTmaConnectorData);
        return extTmaConnectorData;
    }

    private ExtTmaConnectorData parseExtTmaConnectorData(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseExtTmaConnectorData()");
        String extTmaConnectorId = null;
        String dlAttenuation = null;
        String ulGain = null;
        String dlTrafficDelay = null;
        String ulTrafficDelay = null;
        AttributesImpl attributes = xmlElement.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            if ("extTmaConnectorId".equalsIgnoreCase(attributes.getQName(index))) {
                extTmaConnectorId = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("dlAttenuation".equalsIgnoreCase(attributes.getQName(index))) {
                dlAttenuation = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("ulGain".equalsIgnoreCase(attributes.getQName(index))) {
                ulGain = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if ("dlTrafficDelay".equalsIgnoreCase(attributes.getQName(index))) {
                dlTrafficDelay = StringHelper.emptyStringToNull((String)attributes.getValue(index));
                continue;
            }
            if (!"ulTrafficDelay".equalsIgnoreCase(attributes.getQName(index))) continue;
            ulTrafficDelay = StringHelper.emptyStringToNull((String)attributes.getValue(index));
        }
        AntennaSystemConfigurationParserHelper.checkMandatoryAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.ExternalTMA.ExtTmaConnector.extTmaConnectorId", extTmaConnectorId);
        Integer intDlAttenuation = AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.ExternalTMA.ExtTmaConnector.dlAttenuation", dlAttenuation);
        Integer intUlGain = AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.ExternalTMA.ExtTmaConnector.ulGain", ulGain);
        Integer intDlTrafficDelay = AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.ExternalTMA.ExtTmaConnector.dlTrafficDelay", dlTrafficDelay);
        Integer intUlTrafficDelay = AntennaSystemConfigurationParserHelper.convertIntegerAttribute((String)"CommonAntennaSystem.AntennaUnitGroup.ExternalTMA.ExtTmaConnector.ulTrafficDelay", ulTrafficDelay);
        ExtTmaConnectorData extTmaConnectorData = new ExtTmaConnectorData(extTmaConnectorId, intDlAttenuation, intUlGain, intDlTrafficDelay, intUlTrafficDelay);
        logger.traceReturn(THIS_CLASS, "parseExtTmaConnectorData()");
        return extTmaConnectorData;
    }
}

