/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.antennasystemconfiguration.helper;

import java.util.ArrayList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.Definitions;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.reportlogger.ReportLoggerHelper;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class AntennaSystemConfigurationLicenceHelper {
    private static final Class THIS_CLASS = AntennaSystemConfigurationLicenceHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private AntennaSystemConfigurationLicenceHelper() {
    }

    public static void activateOptionalFeatures(MoRepositoryWrapper moRepository, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "activateOptionalFeatures()");
        ArrayList<OptionalFeature> optionalFeatures = new ArrayList<OptionalFeature>();
        OptionalFeature retSupportFeature = new OptionalFeature("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,RetSupport=1", "RetSupport", "featureStateRetSupport");
        OptionalFeature tmaSupportFeature = new OptionalFeature("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,TmaSupport=1", "TmaSupport", "featureStateTmaSupport");
        OptionalFeature retCastcadingFeature = new OptionalFeature("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,RetCascading=1", "RetCascading", "featureStateRetCascading");
        OptionalFeature retConfigurationMgtFeature = new OptionalFeature("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,RetConfigurationMgt=1", "RetConfigurationMgt", "featureStateRetConfigurationMgt");
        OptionalFeature VswrSupervisionFeature = new OptionalFeature("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,VswrSupervision=1", "VswrSupervision", "featureStateVswrSupervision");
        optionalFeatures.add(retSupportFeature);
        optionalFeatures.add(tmaSupportFeature);
        optionalFeatures.add(retCastcadingFeature);
        optionalFeatures.add(retConfigurationMgtFeature);
        optionalFeatures.add(VswrSupervisionFeature);
        for (int index = 0; index < optionalFeatures.size(); ++index) {
            OptionalFeature optionalFeature = (OptionalFeature)optionalFeatures.get(index);
            ManagedObject optionalFeatureMo = moRepository.lookup(optionalFeature.featureLdn);
            if (optionalFeatureMo == null) {
                ReportLoggerHelper.getInstance().logFailure("Antenna feature activation", "Failed to activate feature " + optionalFeature.featureMoType + ". Feature MO not found.");
                continue;
            }
            try {
                optionalFeatureMo.setAttribute(optionalFeature.featureAttributeName, (Object)Definitions.ACTIVATED_VALUE, coordinator);
                ReportLoggerHelper.getInstance().logAttributes(optionalFeature.featureMoType, new String[]{optionalFeature.featureAttributeName}, new String[]{"ACTIVATED"});
                continue;
            }
            catch (MoAccessException mae) {
                ReportLoggerHelper.getInstance().logFailure("Antenna feature activation", "Failed to activate feature " + optionalFeature.featureMoType + ", " + ExceptionHelper.getExceptionMessage((Throwable)mae));
            }
        }
        logger.traceReturn(THIS_CLASS, "activateOptionalFeatures()");
    }

    protected static class OptionalFeature {
        protected final String featureLdn;
        protected final String featureAttributeName;
        protected final String featureMoType;

        protected OptionalFeature(String ldn, String moType, String attributeName) {
            this.featureLdn = ldn;
            this.featureAttributeName = attributeName;
            this.featureMoType = moType;
        }
    }
}

