/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.antennasystemconfiguration.reportlogger;

import se.ericsson.crbs.cat.mao.antennasystemconfiguration.reportlogger.AntennaSystemConfigurationReportLogger;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ReportLoggerHelper {
    private static final Class THIS_CLASS = ReportLoggerHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static ReportLoggerHelper instance;
    private static AntennaSystemConfigurationReportLogger reportLogger;

    private ReportLoggerHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportLoggerHelper getInstance() {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            if (instance == null) {
                instance = new ReportLoggerHelper();
            }
            return instance;
        }
    }

    public void registerReportLogger(AntennaSystemConfigurationReportLogger reportLogger2) {
        reportLogger = reportLogger2;
    }

    public void logAction(String moType, String action, String attribute, String attributeValue) {
        if (reportLogger == null) {
            logger.traceDebug(THIS_CLASS, moType + " - " + action);
        } else {
            reportLogger.logAction(moType, action, attribute, attributeValue);
        }
    }

    public void logAction(String moType, String action, String[] attributes, Object[] attributeValues) {
        if (reportLogger == null) {
            logger.traceDebug(THIS_CLASS, moType + " - " + action);
        } else {
            reportLogger.logAction(moType, action, attributes, attributeValues);
        }
    }

    public void logAttribute(String moType, String attributeName, String attributeValue) {
        if (reportLogger == null) {
            logger.traceDebug(THIS_CLASS, moType + " - set");
        } else {
            reportLogger.logAttribute(moType, attributeName, attributeValue);
        }
    }

    public void logAttributes(String moType, String[] attributeNames, Object[] attributeValues) {
        if (reportLogger == null) {
            logger.traceDebug(THIS_CLASS, moType + " - set");
        } else {
            reportLogger.logAttributes(moType, attributeNames, attributeValues);
        }
    }

    public void logFailure(String failureSlogan, String failureDescr) {
        if (reportLogger == null) {
            logger.traceDebug(THIS_CLASS, failureSlogan + " - " + failureDescr);
        } else {
            reportLogger.logFailure(failureSlogan, failureDescr);
        }
    }

    public void logInformation(String informationSlogan, String information) {
        if (reportLogger == null) {
            logger.traceDebug(THIS_CLASS, informationSlogan + " - " + information);
        } else {
            reportLogger.logInformation(informationSlogan, information);
        }
    }
}

