/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration;

import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.SensitiveDataHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.StateMachineParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.UpgradeParameters;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;

public class PersistentDataCleaner {
    private static final Class THIS_CLASS = PersistentDataCleaner.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int TX_TIMEOUT = 0;
    private final RbsConfigurationMao rbsConfigurationMao;
    private final TransactionFactory transFact;
    private final RbsConfigurationHelper helper;

    public PersistentDataCleaner(RbsConfigurationMao inRbsConfigurationMao) {
        this.rbsConfigurationMao = inRbsConfigurationMao;
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationHelper.class);
        this.transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
    }

    public void cleanPersistentAttributesAndRemoveFiles(String cleanUpReason) {
        logger.traceEnter(THIS_CLASS, "cleanPersistentAttributesAndRemoveFiles() " + cleanUpReason);
        boolean keepCleaning = true;
        while (keepCleaning) {
            try {
                Control control = this.transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                try {
                    this.cleanPersistentAttributesAndRemoveFiles(cleanUpReason, coordinator);
                    control.getTerminator().commit();
                    keepCleaning = false;
                }
                catch (MoAccessException e) {
                    control.getTerminator().rollback();
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Internal failure!", "Clean of sensitive data failed. Retrying.");
                }
            }
            catch (TransactionRolledBackException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Rollback failed!", "Transaction failure. Retrying.");
            }
            catch (InactiveTransactionException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Rollback failed!", "Transaction failure. Retrying.");
            }
            if (!keepCleaning) continue;
            this.helper.waitForRetry("cleanPersistentAttributes()");
        }
        logger.traceReturn(THIS_CLASS, "cleanPersistentAttributesAndRemoveFiles()");
    }

    public void cleanPersistentAttributesAndRemoveFiles(String cleanUpReason, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "cleanPersistentAttributesAndRemoveFiles() " + cleanUpReason + ", coordinator");
        this.clearSensitiveData(coordinator);
        this.cleanUpFiles(cleanUpReason);
        this.cleanAttributes(coordinator);
        logger.traceReturn(THIS_CLASS, "cleanPersistentAttributesAndRemoveFiles(coordinator)");
    }

    private void cleanAttributes(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "cleanAttributes()");
        ArrayList<String> attributesToClean = new ArrayList<String>();
        FileParameters.instance(this.rbsConfigurationMao).delete();
        UpgradeParameters.instance(this.rbsConfigurationMao).delete();
        SecurityParameters.instance(this.rbsConfigurationMao).delete();
        StateMachineParameters.instance(this.rbsConfigurationMao).delete();
        attributesToClean.add("remoteInitialSecurityConfigurationFilePath");
        attributesToClean.add("UpgradePackageId");
        attributesToClean.add("upMoExisted");
        logger.traceDebug(THIS_CLASS, "cleanAttributes() loop and remove");
        Iterator iterator = attributesToClean.iterator();
        while (iterator.hasNext()) {
            String attributeToClean = (String)iterator.next();
            this.rbsConfigurationMao.removeAdditionalAttribute(attributeToClean, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "cleanAttributes()");
    }

    private void cleanUpFiles(String cleanUpReason) {
        logger.traceEnter(THIS_CLASS, "cleanUpFiles() " + cleanUpReason);
        logger.traceDebug(THIS_CLASS, "cleanUpFiles() copyFile");
        FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
        this.helper.copyFile(fp.getSiteBasicFilePath(), this.helper.getLogDirPath() + cleanUpReason + "SiteBasic.xml");
        this.helper.copyFile(fp.getSiteEquipmentFilePath(), this.helper.getLogDirPath() + cleanUpReason + "SiteEquipment.xml");
        this.helper.copyFile(this.helper.getLocalPath() + "SummaryFile.xml", this.helper.getLogDirPath() + cleanUpReason + "SummaryFile.xml");
        logger.traceDebug(THIS_CLASS, "cleanUpFiles() removeFile - siteBasic and siteEquipment");
        this.helper.removeFile(fp.getSiteBasicFilePath());
        this.helper.removeFile(fp.getSiteEquipmentFilePath());
        this.helper.removeFile(this.helper.getLocalPath() + "SiteBasic.xml");
        this.helper.removeFile(this.helper.getLocalPath() + "SiteEquipment.xml");
        this.helper.removeFile(this.helper.getLocalPath() + "SummaryFile.xml");
        logger.traceDebug(THIS_CLASS, "cleanUpFiles() removeFile - security");
        this.helper.removeFile(this.helper.getLocalPath() + "ISCF.xml");
        SecurityParameters sp = SecurityParameters.instance(this.rbsConfigurationMao);
        this.helper.removeFile(sp.getLocalInitialSecurityConfigurationFile());
        logger.traceDebug(THIS_CLASS, "cleanUpFiles() removeFile - license");
        this.helper.removeFile(fp.getLicenseKeyFilePath());
        this.helper.removeFile(UpgradeParameters.instance(this.rbsConfigurationMao).getUpgradePackageFilePath());
        logger.traceReturn(THIS_CLASS, "cleanUpFiles()");
    }

    private void clearSensitiveData(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "clearSensitiveData()");
        SensitiveDataHelper sensitiveDataHelper = (SensitiveDataHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(SensitiveDataHelper.class);
        sensitiveDataHelper.clearSensitiveData(coordinator);
        logger.traceReturn(THIS_CLASS, "clearSensitiveData()");
    }
}

