/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.accesscontrol;

import java.io.IOException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.accesscontrol.AccessControl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AclEntriesData;

public class CreateInitialAclEntries
implements AccessControl {
    final String outerIpAddress;
    final String smrsAddress;

    public CreateInitialAclEntries(String outerIpAddressIn, String smrsAddressIn) {
        this.outerIpAddress = outerIpAddressIn;
        this.smrsAddress = smrsAddressIn;
    }

    public Struct[] createInitialAclEntries() throws RbsConfigurationFailedException {
        Struct[] aclEntriesData = new Struct[RbsConfigurationHelper.existsAndNotEmpty(this.smrsAddress) ? 6 : 5];
        try {
            int counter = 0;
            if (RbsConfigurationHelper.existsAndNotEmpty(this.smrsAddress)) {
                aclEntriesData[counter] = new AclEntriesData("BYPASS", "256", Integer.toString(0), this.outerIpAddress, "32", "0", PORT_FILTERING_FALSE, "TCP", this.smrsAddress, "32", "22", PORT_FILTERING_TRUE).getAclEntry();
                ++counter;
            }
            aclEntriesData[counter] = new AclEntriesData("DROP", "256", Integer.toString(1), "0.0.0.0", "0", "0", PORT_FILTERING_FALSE, "ANY", "0.0.0.0", "0", "22", PORT_FILTERING_TRUE).getAclEntry();
            aclEntriesData[++counter] = new AclEntriesData("DROP", "256", Integer.toString(2), "0.0.0.0", "0", "0", PORT_FILTERING_FALSE, "UDP", "0.0.0.0", "0", "17", PORT_FILTERING_TRUE).getAclEntry();
            aclEntriesData[++counter] = new AclEntriesData("DROP", "256", Integer.toString(3), "0.0.0.0", "0", "0", PORT_FILTERING_FALSE, "SCTP", "0.0.0.0", "0", "132", PORT_FILTERING_TRUE).getAclEntry();
            aclEntriesData[++counter] = new AclEntriesData("DROP", "256", Integer.toString(4), "0.0.0.0", "0", "0", PORT_FILTERING_FALSE, "SCTP", "0.0.0.0", "0", "2512", PORT_FILTERING_TRUE).getAclEntry();
            aclEntriesData[++counter] = new AclEntriesData("DROP", "256", Integer.toString(4), "0.0.0.0", "0", "0", PORT_FILTERING_FALSE, "SCTP", "0.0.0.0", "0", "23", PORT_FILTERING_TRUE).getAclEntry();
        }
        catch (IOException ioe) {
            throw new RbsConfigurationFailedException("O&M Prepare IP Configuration", "Unable to create ACL Entries", ioe);
        }
        return aclEntriesData;
    }
}

