/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.actions;

import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.RbsConfigurationAction;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.SensitiveDataHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public abstract class AbstractRbsConfigurationAction
implements RbsConfigurationAction {
    protected final AbstractLogger logger;
    protected final RbsConfigurationMao rbsConfigurationMao;
    protected final RbsConfigurationContext rbsConfigurationContext;
    protected final MoRepositoryWrapper moRepositoryWrapper;
    protected final RbsConfigurationHelper helper;
    protected final RbsConfigurationSmrsHelper smrsHelper;
    protected final SensitiveDataHelper sensitiveDataHelper;
    protected final StateHandler stateHandler;

    public AbstractRbsConfigurationAction(Class loggingClass, RbsConfigurationMao inrbsConfigurationMao) {
        this.logger = LoggingService.getLogger((String)loggingClass.getName());
        this.rbsConfigurationMao = inrbsConfigurationMao;
        this.rbsConfigurationContext = this.rbsConfigurationMao.getRbsConfigurationContext();
        this.moRepositoryWrapper = this.rbsConfigurationContext.getGenericMaoContext().getMoRepositoryWrapper();
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        this.smrsHelper = (RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationSmrsHelper.class);
        this.sensitiveDataHelper = (SensitiveDataHelper)this.rbsConfigurationContext.getHelper(SensitiveDataHelper.class);
        this.stateHandler = this.rbsConfigurationMao.getStateHandler();
    }

    protected void cleanAndReset() {
        this.rbsConfigurationMao.resetProgressInformation();
        this.rbsConfigurationMao.cleanPersistentAttributesAndRemoveFiles("failed");
    }

    public abstract void execute() throws RbsConfigurationFailedException;
}

