/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.actions;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.AbstractRbsConfigurationAction;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.ClientTimeSetter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages.SetLogicalNameTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AutoIntParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.UpgradeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportFileHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialcv.InitialAiCvFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.common.ExceptionHelper;

public abstract class AbstractStartIntegrationAction
extends AbstractRbsConfigurationAction {
    private static final Class THIS_CLASS = AbstractStartIntegrationAction.class;
    protected final Coordinator coordinator;

    public AbstractStartIntegrationAction(RbsConfigurationMao inRbsConfigurationMao, Coordinator inCoordinator) {
        super(THIS_CLASS, inRbsConfigurationMao);
        this.coordinator = inCoordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRbsIntegration(String actionName, AutoIntParameters autoIntParameters) throws RbsConfigurationFailedException {
        this.logger.traceEnter(THIS_CLASS, "startRbsIntegration()");
        ProgressReportFileHandler progressReportFileHandler = this.rbsConfigurationMao.getProgressReportFileHandler();
        ProgressReportHandler progressReportHandler = this.rbsConfigurationMao.getProgressReportHandler();
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            try {
                this.verifyStartableState();
                progressReportFileHandler.integrationStarted();
                this.setClientUtcTime(autoIntParameters.getNodeParameters().getClientUtcTime());
                this.storeParametersAndLogAction(actionName);
                this.rbsConfigurationMao.storePersistently("integrationLogFilePath", progressReportFileHandler.getLogFilePath());
                boolean activateSecurity = SecurityParameters.instance(this.rbsConfigurationMao).getActivateSecurityAsBoolean();
                boolean activateIpSecurity = SecurityParameters.instance(this.rbsConfigurationMao).getActivateIpSecurityAsBoolean();
                this.logger.traceDebug(THIS_CLASS, "startRbsAutoIntegration: calling progressReportHandler with activateSecurity = " + activateSecurity);
                progressReportHandler.setIntegrationStarted(Boolean.TRUE, activateSecurity, activateIpSecurity, true);
                this.helper.clearConfigFaultReason();
                InitialAiCvFactory.instance(this.rbsConfigurationMao).saveExecutingCvName();
                RbsConfigurationReportLoggerImpl.getInstance().removeOldBackupFiles(true);
                RbsConfigurationReportLoggerFactory.getLogger().finishAndSaveReportFile(false);
                RbsConfigurationReportLoggerFactory.getLogger().initiateConfigurationReport();
                ManagedObject licensingMo = this.moRepositoryWrapper.lookup("ManagedElement=1,SystemFunctions=1,Licensing=1");
                if (licensingMo == null) {
                    this.logger.traceError(THIS_CLASS, "Unable to find LicensingMo!");
                } else {
                    String fingerPrint = (String)licensingMo.getAttribute("fingerprint", null);
                    if (!autoIntParameters.getNodeParameters().getLogicalName().equals(fingerPrint)) {
                        TransactionHandler.run(new SetLogicalNameTp(autoIntParameters.getNodeParameters().getLogicalName(), this.moRepositoryWrapper));
                    }
                }
                this.rbsConfigurationMao.setReadOnlyAttribute("progressLevel", new Integer(0));
                this.helper.setConfigurationStateAndProgressLevel(10);
                this.createCv();
                this.stateHandler.start();
            }
            catch (MoAccessException mae) {
                this.rbsConfigurationMao.setIntegrationStarted(false);
                progressReportFileHandler.integrationFinishedOrFailed();
                progressReportHandler.setIntegrationCanBeStarted(Boolean.TRUE, true);
                this.cleanAndReset();
                this.helper.setConfigurationStateAndProgressLevel(0);
                throw new RbsConfigurationFailedException("Failed to start auto integration", "Original trace: " + mae.getVariablesAsString());
            }
        }
        this.logger.traceReturn(THIS_CLASS, "startRbsIntegration()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientUtcTime(String clientUtcTimeStr) {
        if (RbsConfigurationHelper.existsAndNotEmpty(clientUtcTimeStr)) {
            long currentUtcTime = System.currentTimeMillis();
            try {
                currentUtcTime = Long.parseLong(clientUtcTimeStr);
                ClientTimeSetter clientTimeSetter = new ClientTimeSetter(this.moRepositoryWrapper, this.helper);
                clientTimeSetter.setTime(currentUtcTime);
            }
            catch (Exception e) {
                this.logger.traceAbnormal(THIS_CLASS, "Failed to set client UTC time: " + ExceptionHelper.convertToString((Throwable)e));
            }
            finally {
                try {
                    this.rbsConfigurationMao.storePersistently("autoIntegrationStartTime", clientUtcTimeStr);
                }
                catch (MoAccessException e) {
                    this.logger.traceAbnormal(THIS_CLASS, "Failed to store the auto integration start time: " + ExceptionHelper.convertToString((Throwable)e));
                }
            }
        }
    }

    private void createCv() {
        this.logger.traceEnter(THIS_CLASS, "createCV()");
        String message = "CV autocreated during Initiate.";
        this.rbsConfigurationMao.getProgressReportHandler().updateProgressReportInformation(50, 3, "CV autocreated during Initiate.", true);
        this.rbsConfigurationMao.getProgressReportHandler().setIntegrationCanBeCancelled(Boolean.FALSE);
        InitialAiCvFactory.instance(this.rbsConfigurationMao).createInitialCv("RbsConfiguration_Initial", false, "CV autocreated during Initiate.", "Could not create the CV.");
        this.logger.traceReturn(THIS_CLASS, "createCV()");
    }

    private void storeParametersAndLogAction(String actionName) throws MoAccessException {
        NodeParameters np = NodeParameters.instance(this.rbsConfigurationMao);
        this.rbsConfigurationMao.setReadOnlyAttribute("dhcpClientIdentifier", np.getDhcpClientIdentifier());
        FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
        RbsConfigurationSmrsHelper rbsConfigurationSmrsHelper = (RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationSmrsHelper.class);
        rbsConfigurationSmrsHelper.storeSmrsDataPersistently(fp.getSmrsUserName(), fp.getSmrsPassword(), fp.getSmrsAddress(), fp.getSmrsSummaryFilePath());
        String[] attributes = new String[]{"vlanId", "logicalName", "activateSecurity", "activateIpSecurity", "smrsUserId", "smrsPassword", "smrsAddress", "smrsSummaryFilePath", "dnsServerAddress", "defDomainName", "dhcpClientIdentifier", "oamHostIpAddress", "oamSubnetmask", "oamNetworkPrefixLength", "defaultGateway", "outerDnsServer", "initialSecGwAdd", "initialSecGwFqdn", "outerIpAddress", "outerSubnetMask", "outerDefaultRouter0", "innerDnsServer", "innerIPAddress", "siteBasicFilePath", "siteEquipmentFilePath", "licenseKeyFilePath", "localUPFilePath", "rbsIntegrationCode"};
        IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
        UpgradeParameters up = UpgradeParameters.instance(this.rbsConfigurationMao);
        SecurityParameters sp = SecurityParameters.instance(this.rbsConfigurationMao);
        String licenseKeyFilePath = fp.getLicenseKeyFilePath();
        String localUpFilePath = up.getUpgradePackageFilePath();
        Object[] attributeValues = new String[]{Integer.toString(ip.getVlanId()), np.getLogicalName(), sp.getActivateSecurity(), sp.getActivateIpSecurity(), fp.getSmrsUserName(), "***", fp.getSmrsAddress(), fp.getSmrsSummaryFilePath(), ip.getDnsServerAddress(), ip.getDefaultDomainName(), np.getDhcpClientIdentifier(), ip.getIpAddress(), ip.getSubnetMask(), ip.getNetworkPrefixLength(), ip.getDefaultRouter(), ip.getOuterIpConfigurationData().getOuterDnsServer(), ip.getOuterIpConfigurationData().getInitialSecGwIpAdd(), ip.getOuterIpConfigurationData().getInitialSecGwFqdn(), ip.getOuterIpConfigurationData().getOuterIpAddress(), ip.getOuterIpConfigurationData().getOuterSubnetMask(), ip.getOuterIpConfigurationData().getOuterDefaultRouterZero(), ip.getInnerIpConfigurationData().getInnerDnsServer(), ip.getInnerIpConfigurationData().getInnerIpAddress(), ip.getConfigurationModeVpnInterface().toString(), fp.getSiteBasicFilePath(), fp.getSiteEquipmentFilePath(), "DoNoTuSeVaLuEfRoMsUmMaRy".equals(licenseKeyFilePath) ? "" : licenseKeyFilePath, "DoNoTuSeVaLuEfRoMsUmMaRy".equals(localUpFilePath) ? "" : localUpFilePath, "***"};
        RbsConfigurationReportLoggerFactory.getLogger().logAction("RbsConfiguration", actionName, attributes, attributeValues);
    }

    protected final void verifyStartableState() throws RbsConfigurationFailedException {
        this.helper.verifyConfigLevel(RbsConfigurationDefinitions.RBS_CL_BASIC_CV);
        if (this.integrationActive()) {
            throw new RbsConfigurationFailedException("Integration already active. Current state is: " + this.stateHandler.getConfigurationState());
        }
    }

    protected final boolean integrationActive() {
        this.logger.traceEnter(THIS_CLASS, "integrationActive()");
        int currentState = this.stateHandler.getConfigurationState();
        boolean res = currentState > 0 && currentState < 100;
        this.logger.traceReturn(THIS_CLASS, "integrationActive() = " + res);
        return res;
    }
}

