/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.actions;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.AbstractRbsConfigurationAction;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.RbsConfigurationNpcHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;

public class StartProductionTestConfigurationAction
extends AbstractRbsConfigurationAction {
    private static final Class THIS_CLASS = StartProductionTestConfigurationAction.class;
    private final String siteBasicFilePath;
    private final String rbsEquipmentFilePath;
    private final String productionTestConfFilePath;
    private final String logicalName;
    private final boolean validateXml;

    public StartProductionTestConfigurationAction(RbsConfigurationMao inputRbsConfigurationMao, String inputSiteBasicFilePath, String inputRbsEquipmentFilePath, String inputProductionTestConfFilePath, String inputLogicalName, boolean inputValidateXml) {
        super(THIS_CLASS, inputRbsConfigurationMao);
        this.siteBasicFilePath = inputSiteBasicFilePath.trim();
        this.rbsEquipmentFilePath = inputRbsEquipmentFilePath.trim();
        this.productionTestConfFilePath = inputProductionTestConfFilePath.trim();
        this.logicalName = inputLogicalName.trim();
        this.validateXml = inputValidateXml;
    }

    public void execute() throws RbsConfigurationFailedException {
        this.logger.traceEnter(THIS_CLASS, "execute()");
        try {
            this.rbsConfigurationMao.setReadOnlyAttribute("configurationReport", "");
            RbsConfigurationReportLoggerFactory.getLogger().finishAndSaveReportFile(false);
            RbsConfigurationReportLoggerFactory.getLogger().initiateConfigurationReport();
            this.helper.setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_NPC_CONFIGURATION);
            FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
            fp.setSiteBasicFilePath(this.siteBasicFilePath);
            fp.setSiteEquipmentFilePath(this.rbsEquipmentFilePath);
            this.rbsConfigurationMao.storePersistently("localProductionTestFilePath", this.productionTestConfFilePath);
        }
        catch (MoAccessException mae) {
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Failure when running startProductionTestConfiguration!", mae.getVariablesAsString());
            this.cleanAndReset();
            this.helper.setConfigurationStateAndProgressLevel(0);
            this.logger.traceDebug(THIS_CLASS, mae.getVariablesAsString());
            throw new RbsConfigurationFailedException("Could not run NPC configuration", mae.getVariablesAsString());
        }
        ((RbsConfigurationNpcHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationNpcHelper.class)).runNpcConfiguration(this.logicalName, this.validateXml);
        this.logger.traceReturn(THIS_CLASS, "execute()");
    }
}

