/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.actions;

import java.io.IOException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.AbstractStartIntegrationAction;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AutoIntParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.common.ExceptionHelper;

public class StartRbsIntegrationAction
extends AbstractStartIntegrationAction {
    private static final Class THIS_CLASS = StartRbsIntegrationAction.class;
    private final String parametersXml;

    public StartRbsIntegrationAction(RbsConfigurationMao inputRbsConfigurationMao, String inputParametersXml, Coordinator inputCoordinator) {
        super(inputRbsConfigurationMao, inputCoordinator);
        this.parametersXml = inputParametersXml.trim();
    }

    public void execute() throws RbsConfigurationFailedException {
        this.logger.traceEnter(THIS_CLASS, "execute()");
        this.rbsConfigurationMao.setIntegrationStarted(true);
        AutoIntParameters startRbsIntegrationParameters = AutoIntParameters.instance(this.rbsConfigurationMao);
        try {
            this.actionStartRbsIntegration(startRbsIntegrationParameters);
        }
        catch (IOException ioe) {
            String errorMsg = ExceptionHelper.appendReason((String)("Failed to parse input XML: " + StringHelper.doubleQuote((String)this.parametersXml)), (Throwable)ioe);
            this.logger.traceAbnormal(THIS_CLASS, errorMsg);
            throw new RbsConfigurationFailedException(errorMsg);
        }
        catch (RbsConfigurationFailedException rcfe) {
            throw rcfe;
        }
        catch (MoAccessException mae) {
            String errorMsg = ExceptionHelper.appendReason((String)"Failed to store cabinet MO product data", (Throwable)mae);
            this.logger.traceAbnormal(THIS_CLASS, errorMsg);
            throw new RbsConfigurationFailedException(errorMsg);
        }
        this.logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void actionStartRbsIntegration(AutoIntParameters startRbsIntegrationParameters) throws IOException, RbsConfigurationFailedException, MoAccessException, NoSuchAttributeException, NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        this.logger.traceEnter(THIS_CLASS, "actionStartRbsIntegration()");
        startRbsIntegrationParameters.parse(this.parametersXml);
        if (this.doFetchDhcpData() && IpParameters.instance(this.rbsConfigurationMao).getVlanId() == -2) {
            IpParameters.instance(this.rbsConfigurationMao).setVlanId(-1);
        }
        this.startRbsIntegration("actionStartRbsIntegration", startRbsIntegrationParameters);
        this.logger.traceReturn(THIS_CLASS, "actionStartRbsIntegration()");
    }

    private boolean doFetchDhcpData() {
        this.logger.traceEnter(THIS_CLASS, "doFetchDhcpData()");
        IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
        boolean result2 = RbsConfigurationHelper.existsAndNotEmpty(ip.getIpAddress()) || RbsConfigurationHelper.existsAndNotEmpty(ip.getSubnetMask()) || RbsConfigurationHelper.existsAndNotEmpty(ip.getDefaultRouter()) || ip.existsAndNotEmptyTempIpsecTunnelParameters();
        this.logger.traceReturn(THIS_CLASS, "doFetchDhcpData() " + result2);
        return result2;
    }
}

