/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.aicv;

import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.exception.FunctionBusyException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.su.mom.ConfigurationVersion;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.StateMachineParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class AbstractAiCv {
    private static final Class THIS_CLASS = AbstractAiCv.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String cvBusyFaultReason = "CV action is busy";
    private static final String cvActionFaultReason = "CV action failure";
    private static final String cvHandlingFaultReason = "CV handling failure";
    protected final RbsConfigurationMao rbsConfigurationMao;
    static /* synthetic */ Class class$se$ericsson$crbs$cat$mao$rbsconfiguration$aicv$AbstractAiCv$WaitForRetry;

    public AbstractAiCv(RbsConfigurationMao rbsConfigurationMaoIn) {
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
    }

    protected ConfigurationVersionMo getCvMo() {
        logger.traceEnter(THIS_CLASS, "getCvMo()");
        ConfigurationVersionMo cvMo = (ConfigurationVersionMo)this.rbsConfigurationMao.getRbsConfigurationContext().getMoRepositoryWrapper().lookup("ManagedElement=1,SwManagement=1,ConfigurationVersion=1");
        if (cvMo == null) {
            String msg = "Could not find the ConfigurationVersion Mo";
            this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvHandlingFaultReason, "Could not find the ConfigurationVersion Mo");
            logger.traceError(THIS_CLASS, "getCvMo(): Could not find the ConfigurationVersion Mo");
        }
        logger.traceReturn(THIS_CLASS, "getCvMo()");
        return cvMo;
    }

    protected String handleCreateCv(String newCvNameIn, boolean woLaptop, String cvComment, String cvFaultMsg, int cvIntegrationStep, ConfigurationVersion cvMo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleCreatedCv()" + newCvNameIn);
        this.waitIfUpgradePackageIsNotCompleted(cvIntegrationStep);
        String oldLoadedCvName = cvMo.getCurrentLoadedConfigurationVersion(null);
        String oldStartableCv = cvMo.getStartableConfigurationVersion(null);
        String lastCreated = cvMo.getLastCreatedCv(null);
        String newCvName = newCvNameIn;
        if (newCvNameIn.equalsIgnoreCase(lastCreated) || newCvNameIn.equalsIgnoreCase(oldLoadedCvName) || newCvNameIn.equalsIgnoreCase(oldStartableCv)) {
            newCvName = newCvName + "_";
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("CV already exists", "The configuration CV already exists, using alternative name instead.");
        }
        this.removeCvFromRollbackListAndDeleteCv(newCvName, cvFaultMsg, cvIntegrationStep, cvMo);
        RbsConfigurationReportLoggerFactory.getLogger().logAction("ConfigurationVersion", "Creating CV", "name", newCvName);
        this.doActionCreate(newCvName, cvComment, cvFaultMsg, cvIntegrationStep, cvMo);
        if (!woLaptop) {
            this.doActionSetStartable(newCvName, cvFaultMsg, cvIntegrationStep, cvMo);
            this.addCvInRollbackList(newCvName, oldLoadedCvName, cvFaultMsg, cvIntegrationStep, cvMo);
        }
        logger.traceReturn(THIS_CLASS, "handleCreatedCv() " + newCvName);
        return newCvName;
    }

    protected void waitIfUpgradePackageIsNotCompleted(int cvIntegrationStep) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "waitIfUpgradePackageIsNotCompleted()");
        UpgradePackageMo execUpMo = this.getExecutingUpgradePackageMo();
        if (execUpMo != null) {
            WaitForRetry waitForRetry = new WaitForRetry();
            int state = execUpMo.getState(null);
            while (state != 7) {
                String detail = "Wait as " + execUpMo.getLocalDistinguishedName() + " is not in state UPGRADE_COMPLETED";
                ProgressReportHandler.getInstance().updateProgressReportInformation(cvIntegrationStep, 4, detail, true);
                waitForRetry.waitForRetry("Wait as " + execUpMo.getLocalDistinguishedName() + " is not in state UPGRADE_COMPLETED", true);
                state = execUpMo.getState(null);
            }
        }
        logger.traceReturn(THIS_CLASS, "waitIfUpgradePackageIsNotCompleted()");
    }

    private UpgradePackageMo getExecutingUpgradePackageMo() throws MoAccessException {
        ConfigurationVersionMo cvMo;
        logger.traceEnter(THIS_CLASS, "getExecutingUpgradePackageMo()");
        UpgradePackageMo upMo = null;
        MoIterator cvIt = this.rbsConfigurationMao.getRbsConfigurationContext().getMoRepositoryWrapper().lookupType("ConfigurationVersion");
        if (cvIt != null && cvIt.hasMoreElements() && (cvMo = this.getCvMo()) != null) {
            upMo = (UpgradePackageMo)cvMo.getCurrentUpgradePackage(null);
        }
        logger.traceReturn(THIS_CLASS, "getExecutingUpgradePackageMo() " + (upMo == null ? "NULL" : upMo.getLocalDistinguishedName()));
        return upMo;
    }

    protected void removeCvFromRollbackListAndDeleteCv(String removeCvName, String cvFaultMsg, int cvIntegrationStep, ConfigurationVersion cvMo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "removeCvFromRollbackListAndDeleteCv() " + removeCvName);
        String[] cvsOnRollbackList = cvMo.getRollbackList(null);
        Struct[] currentCvs = cvMo.getStoredConfigurationVersions(null);
        for (int index = 0; index < currentCvs.length; ++index) {
            String currentCv = (String)currentCvs[index].getValue("name");
            if (currentCv.equals(StateMachineParameters.instance(this.rbsConfigurationMao).getCvName())) continue;
            if (removeCvName.equalsIgnoreCase(currentCv) || (removeCvName + "_").equalsIgnoreCase(currentCv)) {
                logger.traceDebug(THIS_CLASS, currentCv + " to be deleted");
                boolean cvOnStoredCvs = true;
                boolean cvOnRollbackList = false;
                for (int i = 0; i < cvsOnRollbackList.length; ++i) {
                    if (!currentCv.equals(cvsOnRollbackList[i])) continue;
                    cvOnRollbackList = true;
                    break;
                }
                this.doActionRemoveFromRollbackList(cvOnRollbackList, currentCv, cvFaultMsg, cvIntegrationStep, cvMo);
                this.doActionDelete(true, currentCv, cvFaultMsg, cvIntegrationStep, cvMo);
                continue;
            }
            logger.traceDebug(THIS_CLASS, currentCv + " not removed as it's startable, i.e wo laptop");
        }
        logger.traceReturn(THIS_CLASS, "removeCvFromRollbackListAndDeleteCv()");
    }

    protected void addCvInRollbackList(String newCvName, String oldCvName, String cvFaultMsg, int cvIntegrationStep, ConfigurationVersion cvMo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addCvInRollbackList() newCvName:" + newCvName + ", oldCvName" + oldCvName);
        String[] cvsOnRollbackList = cvMo.getRollbackList(null);
        if (cvsOnRollbackList.length > 0 && !oldCvName.equals(cvsOnRollbackList[0])) {
            this.doActionSetFirstRollbackList(oldCvName, cvFaultMsg, cvIntegrationStep, cvMo);
        }
        this.doActionSetFirstRollbackList(newCvName, cvFaultMsg, cvIntegrationStep, cvMo);
        logger.traceReturn(THIS_CLASS, "addCvInRollbackList()");
    }

    protected void doActionCreate(String newCvName, String cvComment, String cvFaultMsg, int cvIntegrationStep, ConfigurationVersion cvMo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "doActionCreate() newCvName:" + newCvName + ", cvComment:" + cvComment + ", cvIntegrationStep: " + cvIntegrationStep);
        WaitForRetry waitForRetry = new WaitForRetry();
        boolean doAction = true;
        while (doAction) {
            try {
                cvMo.actionCreate(newCvName, newCvName, 0, "RbsConfiguration", cvComment, null);
                doAction = false;
            }
            catch (FunctionBusyException cvce) {
                String detail = "Function Busy, Retry to create CV, CV name: " + newCvName;
                String errorMsg = cvFaultMsg + " " + (Object)((Object)cvce);
                if (cvIntegrationStep > 0) {
                    ProgressReportHandler.getInstance().updateProgressReportInformation(cvIntegrationStep, 4, errorMsg, true);
                    ProgressReportHandler.getInstance().setIntegrationCanBeCancelled(Boolean.TRUE);
                }
                waitForRetry.waitForRetry(detail);
            }
        }
        logger.traceReturn(THIS_CLASS, "doActionCreate()");
    }

    protected void doActionSetStartable(String newCvName, String cvFaultMsg, int cvIntegrationStep, ConfigurationVersion cvMo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "doActionSetStartable() " + newCvName);
        WaitForRetry waitForRetry = new WaitForRetry();
        boolean doAction = true;
        while (doAction) {
            try {
                cvMo.actionSetStartable(newCvName, null);
                doAction = false;
            }
            catch (FunctionBusyException cvce) {
                String detail = "Function Busy, Retry to set CV in startable state, CV name: " + newCvName;
                String errorMsg = cvFaultMsg + " " + (Object)((Object)cvce);
                if (cvIntegrationStep > 0) {
                    ProgressReportHandler.getInstance().updateProgressReportInformation(cvIntegrationStep, 4, errorMsg, true);
                    ProgressReportHandler.getInstance().setIntegrationCanBeCancelled(Boolean.TRUE);
                }
                this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "CV set startable failure", errorMsg);
                waitForRetry.waitForRetry(detail);
            }
        }
        logger.traceReturn(THIS_CLASS, "doActionSetStartable()");
    }

    protected boolean doActionRemoveFromRollbackList(boolean cvOnRollbackList, String currentCv, String cvFaultMsg, int cvIntegrationStep, ConfigurationVersion cvMo) {
        logger.traceEnter(THIS_CLASS, "doActionRemoveFromRollbackList() " + currentCv);
        boolean result2 = false;
        WaitForRetry waitForRetry = new WaitForRetry();
        boolean doAction = cvOnRollbackList;
        while (doAction) {
            String errorMsg;
            try {
                cvMo.actionRemoveFromRollbackList(currentCv, null);
                doAction = false;
                result2 = true;
            }
            catch (FunctionBusyException fbexc) {
                errorMsg = cvFaultMsg + " " + (Object)((Object)fbexc);
                if (cvIntegrationStep > 0) {
                    ProgressReportHandler.getInstance().updateProgressReportInformation(cvIntegrationStep, 4, errorMsg, true);
                }
                this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvBusyFaultReason, errorMsg);
                waitForRetry.waitForRetry("Function Busy, Retry to remove CV from rollback, CV name: " + currentCv);
            }
            catch (Exception exc) {
                errorMsg = cvFaultMsg + " " + exc;
                this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvActionFaultReason, errorMsg);
                logger.traceDebug(THIS_CLASS, "Unable to remove CV from rollback, CV name: " + currentCv);
                doAction = false;
            }
        }
        logger.traceReturn(THIS_CLASS, "doActionRemoveFromRollbackList() " + currentCv + ", " + result2);
        return result2;
    }

    protected void doActionDelete(boolean cvOnStoredCvs, String currentCv, String cvFaultMsg, int cvIntegrationStep, ConfigurationVersion cvMo) {
        logger.traceEnter(THIS_CLASS, "doActionDelete() " + currentCv);
        WaitForRetry waitForRetry = new WaitForRetry();
        boolean doAction = cvOnStoredCvs;
        while (doAction) {
            String errorMsg;
            try {
                cvMo.actionDelete(currentCv, null);
                doAction = false;
            }
            catch (FunctionBusyException fbexc) {
                errorMsg = cvFaultMsg + " " + (Object)((Object)fbexc);
                if (cvIntegrationStep > 0) {
                    ProgressReportHandler.getInstance().updateProgressReportInformation(cvIntegrationStep, 4, errorMsg, true);
                }
                this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvBusyFaultReason, errorMsg);
                waitForRetry.waitForRetry("Retry to delete CV, CV name: " + currentCv);
            }
            catch (Exception exc) {
                errorMsg = cvFaultMsg + " " + exc;
                this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvActionFaultReason, errorMsg);
                logger.traceDebug(THIS_CLASS, "Unable to remove CV, CV name: " + currentCv);
                doAction = false;
            }
        }
        logger.traceReturn(THIS_CLASS, "doActionDelete()");
    }

    protected void doActionSetFirstRollbackList(String cvName, String cvFaultMsg, int cvIntegrationStep, ConfigurationVersion cvMo) {
        logger.traceEnter(THIS_CLASS, "doActionSetFirstRollbackList()");
        WaitForRetry waitForRetry = new WaitForRetry();
        boolean doAction = true;
        while (doAction) {
            try {
                cvMo.actionSetFirstRollbackList(cvName, null);
                doAction = false;
            }
            catch (FunctionBusyException cvce) {
                String detail = "Function Busy, Retry to set the CV first in the rollback list, CV name: " + cvName;
                String errorMsg = cvFaultMsg + " " + (Object)((Object)cvce);
                if (cvIntegrationStep > 0) {
                    ProgressReportHandler.getInstance().updateProgressReportInformation(cvIntegrationStep, 4, errorMsg, true);
                }
                this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvActionFaultReason, errorMsg);
                waitForRetry.waitForRetry(detail);
            }
            catch (ConfigurationVersionException cve) {
                logger.traceDebug(THIS_CLASS, "The CV already exists in rollback list. " + (Object)((Object)cve));
                doAction = false;
            }
            catch (MoAccessException mae) {
                logger.traceDebug(THIS_CLASS, "Unable to add the CV " + cvName + " to the rollback list " + (Object)((Object)mae));
                doAction = false;
            }
        }
        logger.traceReturn(THIS_CLASS, "doActionSetFirstRollbackList()");
    }

    protected static boolean existsAndNotEmpty(String string) {
        return string != null && !"".equals(string) && !"-".equals(string);
    }

    protected void setFaultReason(Integer faultReason, String faultSlogan, String faultInformation) {
        logger.traceEnter(THIS_CLASS, "setFaultReason() - reason = " + faultReason + ", slogan = " + faultSlogan);
        this.setFaultReason(faultReason, faultSlogan, faultInformation, null);
        logger.traceReturn(THIS_CLASS, "setFaultReason()");
    }

    protected void setFaultReason(Integer faultReason, String faultSlogan, String faultInformation, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "setFaultReason() - reason = " + faultReason + ", slogan = " + faultSlogan);
        this.rbsConfigurationMao.setFaultReason(faultReason, faultSlogan, faultInformation, coordinator);
        logger.traceReturn(THIS_CLASS, "setFaultReason()");
    }

    public static class WaitForRetry {
        final Class THIS_INNER_CLASS = class$se$ericsson$crbs$cat$mao$rbsconfiguration$aicv$AbstractAiCv$WaitForRetry == null ? (class$se$ericsson$crbs$cat$mao$rbsconfiguration$aicv$AbstractAiCv$WaitForRetry = AbstractAiCv.class$("se.ericsson.crbs.cat.mao.rbsconfiguration.aicv.AbstractAiCv$WaitForRetry")) : class$se$ericsson$crbs$cat$mao$rbsconfiguration$aicv$AbstractAiCv$WaitForRetry;
        private int noOfRetries = 0;

        public void waitForRetry(String actionName) {
            this.waitForRetry(actionName, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForRetry(String actionName, boolean noLongWait) {
            logger.traceEnter(THIS_CLASS, "waitForRetry(action) - " + actionName);
            long time = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST")) ? 10L : (this.noOfRetries <= 3 || noLongWait ? 5000L : 100000L);
            try {
                logger.traceDebug(this.THIS_INNER_CLASS, "Sleeping for " + (double)time / 1000.0 + " seconds before new retry. This is the retry number " + this.noOfRetries + ".");
                Class clazz = this.THIS_INNER_CLASS;
                synchronized (clazz) {
                    this.THIS_INNER_CLASS.wait(time);
                }
            }
            catch (InterruptedException ie) {
                logger.traceError(this.THIS_INNER_CLASS, "waitForRetry(action - " + actionName + "):" + "Interrupted while waiting to retry action " + actionName, (Throwable)ie);
            }
            ++this.noOfRetries;
            logger.traceReturn(this.THIS_INNER_CLASS, "waitForRetry(action) - " + actionName);
        }
    }
}

