/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.text.DecimalFormat;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.sync.GpsSyncRefMo;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.AlarmHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.GeoLocationCheckHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.GpsPosition;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;

public class GeoLocationCheckHandlerImpl
implements GeoLocationCheckHandler,
Runnable {
    private final RbsConfigurationMao rbsConfigurationMao;
    private AlarmHandler alarmHandler = null;
    protected Thread geoLocCheckThread = null;
    private static int TIMER_BFR_RBS_POSITION_UNAVAILABLE_ALARM_RAISED = 30;
    private static int TIMER_AFTER_RBS_POSITION_UNAVAILABLE_ALARM_RAISED = 5;
    private static int TIMER_MAX_WAIT_GPS_TIME_SECONDS = 750;
    private static int POSITIVE_SIGN = 1;
    private static int NEGATIVE_SIGN = -1;
    private static int UNAVAILABLE_ALARM = 0;
    private static int MISMATCH_ALARM = 1;
    private static final Class THIS_CLASS = GeoLocationCheckHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
    private static final int TX_TIMEOUT = 0;
    protected Integer tolerance = new Integer(0);
    public int totalTimeElapsed = 0;
    protected int startReason = 0;
    protected Integer geoCheckResult = new Integer(0);
    private Boolean geoCheckResultReady = Boolean.FALSE;
    protected String actLongitudeCopy = "";
    protected String actLatitudeCopy = "";
    protected String actAltitudeCopy = "";
    protected String wantedLongitudeCopy = "";
    protected String wantedLatitudeCopy = "";
    protected String wantedAltitudeCopy = "";
    protected String hwSerialNumCopy = "";
    protected Sleeper sleeper = new SleeperImpl();

    public GeoLocationCheckHandlerImpl(int inStartReason, RbsConfigurationMao inRbsConfigurationMao, AlarmHandler inAlarmHandler) {
        this.rbsConfigurationMao = inRbsConfigurationMao;
        this.alarmHandler = inAlarmHandler;
        this.startReason = inStartReason;
    }

    public void start() {
        logger.traceEnter(THIS_CLASS, "start()");
        this.alarmHandler.readAlarmParameters(this.rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext());
        this.geoLocCheckThread = new Thread((Runnable)this, "CRBS_lmCatOamLmU_RbsConfiguration_GeoLocationCheck_start");
        this.geoLocCheckThread.start();
        logger.traceGeneral(THIS_CLASS, "Started geographic location check handling in a separate thread: " + StringHelper.doubleQuote((String)this.geoLocCheckThread.getName()));
        logger.traceReturn(THIS_CLASS, "start()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetVariables() {
        Boolean bl = this.geoCheckResultReady;
        synchronized (bl) {
            this.geoCheckResultReady = Boolean.FALSE;
        }
        this.geoCheckResult = new Integer(0);
        this.totalTimeElapsed = this.startReason == 2 ? TIMER_MAX_WAIT_GPS_TIME_SECONDS : 0;
    }

    public void run() {
        try {
            this.resetVariables();
            if (this.startReason == 1) {
                this.sleeper.SleepMinutes(1);
            }
            this.geoLocationCheck();
        }
        catch (MoAccessException e) {
            logger.traceError(THIS_CLASS, "Geographic Location Check failed due to a MO access violation", (Throwable)e);
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            logger.traceGeneral(THIS_CLASS, "Geographic Location Check was interrupted by another job with start reason: " + this.startReason);
        }
        catch (TransactionRolledBackException e) {
            logger.traceError(THIS_CLASS, "Geographic Location Check rolled back and could not be performed", (Throwable)e);
            e.printStackTrace();
        }
        catch (InactiveTransactionException e) {
            logger.traceError(THIS_CLASS, "Geographic Location Check could not be performed due to no association of transaction", (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.traceError(THIS_CLASS, "Geographic Location Check could not be performed due to exception", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void interruptThread() {
        if (this.geoLocCheckThread != null) {
            this.geoLocCheckThread.interrupt();
        }
    }

    public int getStartReason() {
        return this.startReason;
    }

    protected void geoLocationCheck() throws MoAccessException, InterruptedException, TransactionRolledBackException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "geoLocationCheck()");
        GpsPosition wantedPos = this.getWantedPosition();
        if (wantedPos != null) {
            GpsPosition actualPos = this.getActualPosition();
            this.getSerialNumber();
            if (actualPos == null || actualPos.allValuesZero()) {
                if (this.alarmHandler.isMismatchAlarmRaised()) {
                    this.alarmHandler.ceaseAlarmPositionMismatch();
                }
                boolean positionAvailable = false;
                while (!positionAvailable) {
                    if (!this.resultReady() && this.totalTimeElapsed >= TIMER_MAX_WAIT_GPS_TIME_SECONDS) {
                        if (!this.alarmHandler.isUnavailableAlarmRaised()) {
                            this.alarmHandler.raiseAlarmPositionUnavailable(this.getAdditionalInfo(UNAVAILABLE_ALARM, 0.0));
                        }
                        this.setGeoCheckResult(RbsConfigurationDefinitions.RBS_CL_GPS_UNAVAILABLE);
                    }
                    if (this.resultReady()) {
                        this.sleeper.SleepMinutes(TIMER_AFTER_RBS_POSITION_UNAVAILABLE_ALARM_RAISED);
                    } else {
                        this.sleeper.SleepSeconds(TIMER_BFR_RBS_POSITION_UNAVAILABLE_ALARM_RAISED);
                    }
                    actualPos = this.getActualPosition();
                    positionAvailable = actualPos != null && !actualPos.allValuesZero();
                }
                if (this.alarmHandler.isUnavailableAlarmRaised()) {
                    this.alarmHandler.ceaseAlarmPositionUnavailable();
                }
                wantedPos = this.getWantedPosition();
            }
            if (wantedPos != null && this.tolerance != null) {
                double distance = GpsPosition.distance(wantedPos, actualPos);
                logger.info(THIS_CLASS, " geoLocationCheck(): distance = " + distance + ", tolerance = " + this.tolerance);
                if (distance > this.tolerance.doubleValue()) {
                    this.alarmHandler.raiseAlarmPositionMismatch(this.getAdditionalInfo(MISMATCH_ALARM, distance));
                    this.setGeoCheckResult(RbsConfigurationDefinitions.RBS_CL_GPS_MISMATCH_ERROR);
                } else {
                    this.setGeoCheckResult(RbsConfigurationDefinitions.RBS_CL_GPS_SUCCESSFULLY_MATCHED);
                    this.ceaseAlarms();
                }
            }
        } else {
            this.setGeoCheckResult(RbsConfigurationDefinitions.RBS_CL_GPS_WANTED_POSITION_NOT_SET);
            this.ceaseAlarms();
        }
        logger.traceReturn(THIS_CLASS, "geoLocationCheck()");
    }

    protected void ceaseAlarms() {
        logger.traceEnter(THIS_CLASS, "ceaseAlarms()");
        if (this.alarmHandler.isUnavailableAlarmRaised()) {
            this.alarmHandler.ceaseAlarmPositionUnavailable();
        }
        if (this.alarmHandler.isMismatchAlarmRaised()) {
            this.alarmHandler.ceaseAlarmPositionMismatch();
        }
        logger.traceReturn(THIS_CLASS, "ceaseAlarms()");
    }

    protected GpsPosition getWantedPosition() throws MoAccessException {
        GpsPosition retVal;
        block11: {
            logger.traceEnter(THIS_CLASS, "getWantedPosition()");
            retVal = null;
            try {
                boolean altitudeEmpty;
                String altitudeString;
                String longitudeString;
                String latitudeString;
                Control control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                try {
                    Struct wantedPos = (Struct)this.rbsConfigurationMao.getAttribute("wantedPosition", coordinator);
                    latitudeString = (String)wantedPos.getValue("latitude");
                    longitudeString = (String)wantedPos.getValue("longitude");
                    altitudeString = (String)wantedPos.getValue("altitude");
                    this.tolerance = (Integer)wantedPos.getValue("tolerance");
                    this.wantedLatitudeCopy = latitudeString;
                    this.wantedLongitudeCopy = longitudeString;
                    this.wantedAltitudeCopy = altitudeString;
                }
                catch (MoAccessException mae) {
                    control.getTerminator().rollback();
                    throw mae;
                }
                control.getTerminator().commit();
                boolean latitudeEmpty = latitudeString == null || latitudeString.equals("") || latitudeString.equals("-");
                boolean longitudeEmpty = longitudeString == null || longitudeString.equals("") || longitudeString.equals("-");
                boolean bl = altitudeEmpty = altitudeString == null || altitudeString.equals("") || altitudeString.equals("-");
                if (!latitudeEmpty && !longitudeEmpty) {
                    try {
                        if (altitudeEmpty) {
                            retVal = new GpsPosition(GeoLocationCheckHandlerImpl.parseLatitude(latitudeString), GeoLocationCheckHandlerImpl.parseLongitude(longitudeString));
                            break block11;
                        }
                        retVal = new GpsPosition(GeoLocationCheckHandlerImpl.parseLatitude(latitudeString), GeoLocationCheckHandlerImpl.parseLongitude(longitudeString), Double.parseDouble(altitudeString.trim()));
                    }
                    catch (NumberFormatException e) {
                        logger.traceAbnormal(THIS_CLASS, "wantedPosition is not properly formatted. Geographic location check feature deactivated");
                    }
                    break block11;
                }
                if (!(!latitudeEmpty && !longitudeEmpty || latitudeEmpty && longitudeEmpty && altitudeEmpty)) {
                    logger.traceAbnormal(THIS_CLASS, "Some parts of wantedPosition are not set or incorrectly set. Geographic location check feature deactivated");
                }
            }
            catch (TransactionRolledBackException e) {
                logger.traceAbnormal(THIS_CLASS, "Received TransactionRolledBackException exception when setting wanted position");
                e.printStackTrace();
            }
            catch (NoSuchAttributeException e) {
                logger.traceAbnormal(THIS_CLASS, "There is no such attribute. Received NoSuchAttributeException exception when setting wanted position");
                e.printStackTrace();
            }
            catch (InactiveTransactionException e) {
                logger.traceAbnormal(THIS_CLASS, "Received InactiveTransactionException exception when setting wanted position");
                e.printStackTrace();
            }
        }
        logger.traceReturn(THIS_CLASS, "getWantedPosition()");
        return retVal;
    }

    protected GpsPosition getActualPosition() throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "getActualPosition()");
        GpsSyncRefMo gpsMo = null;
        MoIterator iter = this.rbsConfigurationMao.getRbsConfigurationContext().getMoRepositoryWrapper().lookupType("GpsSyncRef");
        if (iter != null) {
            while (iter.hasMoreElements()) {
                GpsSyncRefMo tmp = (GpsSyncRefMo)iter.nextElement();
                if (gpsMo != null) continue;
                gpsMo = tmp;
                break;
            }
        }
        GpsPosition retVal = null;
        if (gpsMo == null) {
            logger.traceAbnormal(THIS_CLASS, "getActualPosition(). The GpsSyncRef MO is not found.");
            return null;
        }
        try {
            String altitudeString;
            String latitudeString;
            String longitudeString;
            Control control = transFact.create(0);
            Coordinator coordinator = control.getCoordinator();
            try {
                longitudeString = gpsMo.getLongitude(coordinator);
                latitudeString = gpsMo.getLatitude(coordinator);
                altitudeString = gpsMo.getAltitude(coordinator);
            }
            catch (MoAccessException mae) {
                control.getTerminator().rollback();
                throw mae;
            }
            control.getTerminator().commit();
            this.actLongitudeCopy = longitudeString;
            this.actLatitudeCopy = latitudeString;
            this.actAltitudeCopy = altitudeString;
            if (!(longitudeString == null || longitudeString.equals("") || latitudeString == null || latitudeString.equals("") || altitudeString == null || altitudeString.equals(""))) {
                retVal = new GpsPosition(GeoLocationCheckHandlerImpl.parseLatitude(latitudeString), GeoLocationCheckHandlerImpl.parseLongitude(longitudeString), Double.parseDouble(altitudeString.trim()));
            }
        }
        catch (NumberFormatException e) {
            logger.traceAbnormal(THIS_CLASS, "gpsSyncRef has incorrectly formatted GPS position. Geographic location check feature deactivated");
            e.printStackTrace();
        }
        catch (TransactionRolledBackException e1) {
            logger.traceAbnormal(THIS_CLASS, "Received TransactionRolledBackException exception when fetching actual position");
            e1.printStackTrace();
        }
        catch (InactiveTransactionException e) {
            logger.traceAbnormal(THIS_CLASS, "Received InactiveTransactionException exception when fetching actual position");
            e.printStackTrace();
        }
        logger.traceReturn(THIS_CLASS, "getActualPosition()");
        return retVal;
    }

    protected static double parseLatitude(String inValue) throws NumberFormatException {
        int sign;
        if ((inValue = inValue.trim()).length() < 2) {
            throw new NumberFormatException("Empty latitude string is not allowed");
        }
        char directionChar = inValue.toUpperCase().charAt(0);
        if (directionChar == 'N') {
            sign = POSITIVE_SIGN;
        } else if (directionChar == 'S') {
            sign = NEGATIVE_SIGN;
        } else {
            throw new NumberFormatException("Bad latitude formatting: " + inValue);
        }
        return (double)sign * GeoLocationCheckHandlerImpl.parseLongitudeLatitude(inValue.substring(1).trim());
    }

    protected static double parseLongitude(String inValue) throws NumberFormatException {
        int sign;
        if ((inValue = inValue.trim()).length() < 2) {
            throw new NumberFormatException("Empty longitude string is not allowed");
        }
        char directionChar = inValue.toUpperCase().charAt(0);
        if (directionChar == 'E') {
            sign = POSITIVE_SIGN;
        } else if (directionChar == 'W') {
            sign = NEGATIVE_SIGN;
        } else {
            throw new NumberFormatException("Bad longitude formatting: " + inValue);
        }
        return (double)sign * GeoLocationCheckHandlerImpl.parseLongitudeLatitude(inValue.substring(1).trim());
    }

    private static double parseLongitudeLatitude(String inValue) throws NumberFormatException {
        int dotIndex = inValue.indexOf(46);
        if (dotIndex == -1) {
            throw new NumberFormatException("Bad formatting (the format should contains dot between degree and decimal minutes value)" + inValue);
        }
        String degreesString = inValue.substring(0, dotIndex);
        int degrees = Integer.parseInt(degreesString);
        if (degrees < 0) {
            throw new NumberFormatException("Bad formatting (negative degrees not allowed): " + inValue);
        }
        String minutesString = inValue.substring(dotIndex + 1);
        double minutes = Double.parseDouble(minutesString);
        if (minutes < 0.0 || minutes > 60.0) {
            throw new NumberFormatException("Bad formatting (minutes out of range): " + inValue);
        }
        return (double)degrees + minutes / 60.0;
    }

    public static boolean verifyWantedPositionFormatting(String latitude, String longitude, String altitude) {
        if (("".equals(latitude) || "-".equals(latitude)) && ("".equals(longitude) || "-".equals(longitude)) && ("".equals(altitude) || "-".equals(altitude))) {
            return true;
        }
        try {
            GeoLocationCheckHandlerImpl.parseLatitude(latitude);
            GeoLocationCheckHandlerImpl.parseLongitude(longitude);
            if (!"".equals(altitude) && !"-".equals(altitude)) {
                Double.parseDouble(altitude);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    protected void getSerialNumber() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getSerialNumber()");
        String serialNum = null;
        this.hwSerialNumCopy = "-";
        try {
            serialNum = this.getSerialNumberFromSlot();
            if (serialNum == null) {
                serialNum = this.getSerialNumberFromCabinet();
            }
        }
        catch (TransactionRolledBackException e) {
            logger.traceAbnormal(THIS_CLASS, "Received TransactionRolledBackException exception when fetching hardware serial number");
            e.printStackTrace();
        }
        catch (InactiveTransactionException e) {
            logger.traceAbnormal(THIS_CLASS, "Received InactiveTransactionException exception when fetching hardware serial number");
            e.printStackTrace();
        }
        if (serialNum == null) {
            logger.traceAbnormal(THIS_CLASS, "HW serial number could not be read.");
        } else {
            this.hwSerialNumCopy = serialNum;
        }
        logger.traceReturn(THIS_CLASS, "getSerialNumber()");
    }

    protected String getSerialNumberFromSlot() throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "getSerialNumberFromSlot()");
        String hwSerialNum = null;
        String hwProductName = null;
        MoIterator iter = this.rbsConfigurationMao.getRbsConfigurationContext().getMoRepositoryWrapper().lookupType("Slot");
        if (iter != null) {
            while (iter.hasMoreElements()) {
                SlotMo tmpSlotMo = (SlotMo)iter.nextElement();
                if (tmpSlotMo == null) continue;
                Struct productData = null;
                Control control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                try {
                    try {
                        productData = tmpSlotMo.getProductData(coordinator);
                    }
                    catch (NullPointerException e) {
                        productData = null;
                    }
                    if (productData != null) {
                        hwSerialNum = (String)productData.getValue("serialNumber");
                        hwProductName = (String)productData.getValue("productName");
                        if (hwSerialNum != null && hwSerialNum != "" && hwProductName != null && !hwProductName.trim().startsWith("ODS")) {
                            control.getTerminator().commit();
                            break;
                        }
                        hwSerialNum = null;
                    }
                }
                catch (MoAccessException mae) {
                    control.getTerminator().rollback();
                    throw mae;
                }
                control.getTerminator().commit();
            }
        }
        logger.traceReturn(THIS_CLASS, "getSerialNumberFromSlot()");
        return hwSerialNum;
    }

    protected String getSerialNumberFromCabinet() throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "getSerialNumberFromCabinet()");
        String hwSerialNum = null;
        MoIterator iter = this.rbsConfigurationMao.getRbsConfigurationContext().getMoRepositoryWrapper().lookupType("Cabinet");
        if (iter != null) {
            while (iter.hasMoreElements()) {
                ManagedObject tmpMo = iter.nextMo();
                if (tmpMo == null) continue;
                Struct productData = null;
                Control control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                try {
                    productData = (Struct)tmpMo.getAttribute("productData", coordinator);
                    if (productData != null && (hwSerialNum = (String)productData.getValue("serialNumber")) != null && hwSerialNum != "") {
                        control.getTerminator().commit();
                        break;
                    }
                }
                catch (MoAccessException mae) {
                    control.getTerminator().rollback();
                    throw mae;
                }
                control.getTerminator().commit();
            }
        }
        logger.traceReturn(THIS_CLASS, "getSerialNumberFromCabinet()");
        return hwSerialNum;
    }

    protected AdditionalInfo[] getAdditionalInfo(int alarmType, double distance) {
        logger.traceEnter(THIS_CLASS, "getAdditionalInfo()");
        AdditionalInfo[] additionalInfo = null;
        if (alarmType == MISMATCH_ALARM) {
            additionalInfo = new AdditionalInfo[]{new AdditionalInfo("Physical position", this.actLatitudeCopy + " " + this.actLongitudeCopy + " " + this.actAltitudeCopy), new AdditionalInfo("Configured position", this.wantedLatitudeCopy + " " + this.wantedLongitudeCopy + " " + this.wantedAltitudeCopy), new AdditionalInfo("Difference (m)", new DecimalFormat("#.##").format(distance)), new AdditionalInfo("Hardware serial number", this.hwSerialNumCopy)};
        } else if (alarmType == UNAVAILABLE_ALARM) {
            additionalInfo = new AdditionalInfo[]{new AdditionalInfo("Hardware serial number", this.hwSerialNumCopy)};
        }
        if (additionalInfo != null) {
            for (int i = 0; i < additionalInfo.length; ++i) {
                logger.traceGeneral(THIS_CLASS, additionalInfo[i].getName() + ": " + additionalInfo[i].getValue());
            }
        }
        logger.traceReturn(THIS_CLASS, "getAdditionalInfo()");
        return additionalInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGeoCheckResult(Integer result2) {
        this.geoCheckResult = result2;
        Boolean bl = this.geoCheckResultReady;
        synchronized (bl) {
            this.geoCheckResultReady = Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultReady() {
        boolean value;
        Boolean bl = this.geoCheckResultReady;
        synchronized (bl) {
            value = this.geoCheckResultReady;
        }
        return value;
    }

    public Integer geoLocationCheckResult() {
        return this.geoCheckResult;
    }

    public void setAlarmHandler(AlarmHandler inAlarmHandler) {
        this.alarmHandler = inAlarmHandler;
    }

    public void setSleeper(Sleeper inSleeper) {
        this.sleeper = inSleeper;
    }

    protected class SleeperImpl
    implements Sleeper {
        protected boolean isSleeping = false;

        protected SleeperImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void SleepMinutes(int minutes) throws InterruptedException {
            SleeperImpl sleeperImpl = this;
            synchronized (sleeperImpl) {
                this.isSleeping = true;
            }
            TimeUnit.MINUTES.sleep((long)minutes);
            GeoLocationCheckHandlerImpl.this.totalTimeElapsed += minutes * 60;
            sleeperImpl = this;
            synchronized (sleeperImpl) {
                this.isSleeping = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void SleepSeconds(int seconds) throws InterruptedException {
            SleeperImpl sleeperImpl = this;
            synchronized (sleeperImpl) {
                this.isSleeping = true;
            }
            if (GeoLocationCheckHandlerImpl.this.startReason != 2) {
                TimeUnit.SECONDS.sleep((long)seconds);
            }
            GeoLocationCheckHandlerImpl.this.totalTimeElapsed += seconds;
            sleeperImpl = this;
            synchronized (sleeperImpl) {
                this.isSleeping = false;
            }
        }
    }

    public static interface Sleeper {
        public void SleepMinutes(int var1) throws InterruptedException;

        public void SleepSeconds(int var1) throws InterruptedException;
    }
}

