/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;

public class FqdnIpAddressPair {
    public static final String FQDN_IP_ADDRESS_PAIR_DELIMITER = "-";
    private String ipAddress;
    private String fqdn;

    public FqdnIpAddressPair(String ipAddressIn, String fqdnIn) {
        this.ipAddress = ipAddressIn;
        this.fqdn = fqdnIn;
    }

    public final String getIpAddress() {
        return this.ipAddress;
    }

    public final String getFqdn() {
        return this.fqdn;
    }

    public void setIpAddress(String ipAddressIn) {
        this.ipAddress = ipAddressIn;
    }

    public void setFqdn(String fqdnIn) {
        this.fqdn = fqdnIn;
    }

    public String toString() {
        return this.ipAddress + FQDN_IP_ADDRESS_PAIR_DELIMITER + this.fqdn;
    }

    public static FqdnIpAddressPair[] split(String addresses) {
        if (addresses.indexOf(",") != -1) {
            return FqdnIpAddressPair.split(addresses, ",");
        }
        return FqdnIpAddressPair.split(addresses.trim(), " ");
    }

    public static final FqdnIpAddressPair[] split(String addresses, String delimiter) {
        String[] separatedValues = AbstractParameters.split(addresses, delimiter);
        if (separatedValues == null) {
            return new FqdnIpAddressPair[0];
        }
        FqdnIpAddressPair[] fqdnIpAddressPairs = new FqdnIpAddressPair[separatedValues.length];
        for (int i = 0; i < separatedValues.length; ++i) {
            String[] fqdnIpAddressPair = AbstractParameters.split(separatedValues[i], FQDN_IP_ADDRESS_PAIR_DELIMITER);
            if (fqdnIpAddressPair.length != 2) continue;
            fqdnIpAddressPairs[i] = new FqdnIpAddressPair(fqdnIpAddressPair[0], fqdnIpAddressPair[1]);
        }
        return fqdnIpAddressPairs;
    }
}

