/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;

public class FqdnOrIpAddress {
    public static final String FQDN_OR_IP_ADDRESS_DELIMITER = "-";
    private final int addressType;
    private final String addressValue;

    public FqdnOrIpAddress(int addressTypeIn, String addressValueIn) {
        this.addressType = addressTypeIn;
        this.addressValue = addressValueIn;
    }

    public final int getAddressType() {
        return this.addressType;
    }

    public final String getAddressValue() {
        return this.addressValue;
    }

    public String toString() {
        String addressTypeName = "ip";
        if (this.addressType == 1) {
            addressTypeName = "fqdn";
        }
        return addressTypeName + FQDN_OR_IP_ADDRESS_DELIMITER + this.addressValue;
    }

    public static FqdnOrIpAddress[] split(String addresses) {
        if (addresses.indexOf(",") != -1) {
            return FqdnOrIpAddress.split(addresses, ",");
        }
        return FqdnOrIpAddress.split(addresses.trim(), " ");
    }

    public static final FqdnOrIpAddress[] split(String addresses, String delimiter) {
        String[] separatedValues = AbstractParameters.split(addresses, delimiter);
        if (separatedValues == null) {
            return new FqdnOrIpAddress[0];
        }
        FqdnOrIpAddress[] fqdnOrIpAddresses = new FqdnOrIpAddress[separatedValues.length];
        for (int i = 0; i < separatedValues.length; ++i) {
            String[] nameValuePair = AbstractParameters.split(separatedValues[i], FQDN_OR_IP_ADDRESS_DELIMITER);
            if (nameValuePair.length != 2) continue;
            if (nameValuePair[0].equals("ip")) {
                fqdnOrIpAddresses[i] = new FqdnOrIpAddress(0, nameValuePair[1]);
                continue;
            }
            if (!nameValuePair[0].equals("fqdn")) continue;
            fqdnOrIpAddresses[i] = new FqdnOrIpAddress(1, nameValuePair[1]);
        }
        return fqdnOrIpAddresses;
    }
}

