/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.net.URL;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.JarFileHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class JarFileHelperImpl
implements JarFileHelper {
    private static final Class THIS_CLASS = JarFileHelperImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String PERCENTAGE_SIGN = "%25";
    private static final String EXCLAMATION_MARK = "!";

    public String getJarFilePathFromResource(String resourcePath) {
        int exclamationIndex;
        logger.traceEnter(THIS_CLASS, "getJarFilePathFromResource(), resourcePath = " + resourcePath);
        String jarFilePath = null;
        URL schemaUrl = ClassLoader.getSystemClassLoader().getResource(resourcePath);
        if (schemaUrl != null && (exclamationIndex = schemaUrl.getPath().indexOf(EXCLAMATION_MARK)) != -1) {
            jarFilePath = schemaUrl.getPath().substring(5, exclamationIndex);
            int percentIndex = jarFilePath.indexOf(PERCENTAGE_SIGN);
            int underscoreIndex = jarFilePath.indexOf("_");
            if (percentIndex != -1 && underscoreIndex != -1 && underscoreIndex - percentIndex > PERCENTAGE_SIGN.length()) {
                jarFilePath = jarFilePath.substring(0, percentIndex + 1) + jarFilePath.substring(percentIndex + PERCENTAGE_SIGN.length());
            }
        }
        logger.traceReturn(THIS_CLASS, "getJarFilePathFromResource(), jarFilePath = " + jarFilePath);
        return jarFilePath;
    }
}

