/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.util.ArrayList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.common.LdnHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class OptionalFeaturesHelper {
    public static final Integer[] FEATURE_AND_LICENCE_VALUES = new Integer[]{new Integer(0), new Integer(1)};
    public static final String[] LICENSE_NAMES = new String[]{"DISABLED", "ENABLED"};
    public static final String[] FEATURE_NAMES = new String[]{"DEACTIVATED", "ACTIVATED"};
    private static final String OPTIONAL_FEATURE_MO_LDN = "ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1";
    public static final LdnAndAttributeHolder[] LDN_AND_ATTRIBUTE_HOLDERS = new LdnAndAttributeHolder[]{new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,AgpsSupl=1", new String[]{"featureStateAgpsSupl", "licenseStateAgpsSupl"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,AirIfLoadGenerator=1", new String[]{"featureStateAilg", "licenseStateAilg"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,Aisgv2FwDownload=1", new String[]{"featureStateAisgv2FwDownload", "licenseStateAisgv2FwDownload"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,Anr=1", new String[]{"featureStateAnr", "licenseStateAnr"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,Cdma2000SessionContinuity=1", new String[]{"featureStateCdma2000SessionContinuity", "licenseStateCdma2000SessionContinuity"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,CsfbForLimitedDualRadioUE=1", new String[]{"featureStateCsfbForLimitedDualRadioUE", "licenseStateCsfbForLimitedDualRadioUE"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,CsfbToGsmWcdma=1", new String[]{"featureStateCsfbToGsmWcdma", "licenseStateCsfbToGsmWcdma"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,Dl64Qam=1", new String[]{"featureStateDl64Qam", "licenseStateDl64Qam"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,Drx=1", new String[]{"featureStateDrx", "licenseStateDrx"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,DualAntDlPerfPkg=1", new String[]{"featureStateDualAntDlPerfPkg", "licenseStateDualAntDlPerfPkg"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,EcsCsfb=1", new String[]{"featureStateEcsCsfb", "licenseStateEcsCsfb"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,GsmSessionContinuity=1", new String[]{"featureStateGsmSessionContinuity", "licenseStateGsmSessionContinuity"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,InterFrequencyLTEHandover=1", new String[]{"featureStateInterFrequencyLTEHandover", "licenseStateInterFrequencyLTEHandover"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,InterFrequencySessionContinuity=1", new String[]{"featureStateInterFrequencySessionContinuity", "licenseStateInterFrequencySessionContinuity"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,IntraLTEHandover=1", new String[]{"featureStateIntraLTEHandover", "licenseStateIntraLTEHandover"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,IntraLTEHODataFwd=1", new String[]{"featureStateIntraLTEHODataFwd", "licenseStateIntraLTEHODataFwd"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,Irc=1", new String[]{"featureStateIrc", "licenseStateIrc"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,MaximumCellRange=1", new String[]{"featureStateMaximumCellRange", "licenseStateMaximumCellRange"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,MixedMode=1", new String[]{"featureStateMixedMode", "licenseStateMixedMode"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,MultiErabsPerUser=1", new String[]{"featureStateMultiErabsPerUser", "licenseStateMultiErabsPerUser"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,OtdoaSupl=1", new String[]{"featureStateOtdoaSupl", "licenseStateOtdoaSupl"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,PmInitiatedUeMeasurements=1", new String[]{"featureStatePmInitiatedUeMeasurements", "licenseStatePmInitiatedUeMeasurements"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,QosAwareScheduler=1", new String[]{"featureStateQosAwareScheduler", "licenseStateQosAwareScheduler"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,RbsEventStreamer=1", new String[]{"featureStateEventStreaming", "licenseStateEventStreaming"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,RetCascading=1", new String[]{"featureStateRetCascading", "licenseStateRetCascading"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,RetConfigurationMgt=1", new String[]{"featureStateRetConfigurationMgt", "licenseStateRetConfigurationMgt"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,RetSupport=1", new String[]{"featureStateRetSupport", "licenseStateRetSupport"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,RlcUm=1", new String[]{"featureStateRlcUm", "licenseStateRlcUm"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,SharedNetworkSupport=1", new String[]{"featureStateSharedNetworkSupport", "licenseStateSharedNetworkSupport"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,TimeAndPhaseSynchWithGPS=1", new String[]{"featureStateTimeAndPhaseSynchWithGPS", "licenseStateTimeAndPhaseSynchWithGPS"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,TmaSupport=1", new String[]{"featureStateTmaSupport", "licenseStateTmaSupport"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,UePosCellId=1", new String[]{"featureStateCellId", "licenseStateCellId"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,Ul16Qam=1", new String[]{"featureStateUl16Qam", "licenseStateUl16Qam"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,VswrSupervision=1", new String[]{"featureStateVswrSupervision", "licenseStateVswrSupervision"}), new LdnAndAttributeHolder("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,WcdmaSessionContinuity=1", new String[]{"featureStateWcdmaSessionContinuity", "licenseStateWcdmaSessionContinuity"})};
    private static final Class THIS_CLASS = OptionalFeaturesHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper moRepositoryWrapper;

    public OptionalFeaturesHelper(MoRepositoryWrapper theMoRepositoryWrapper) {
        this.moRepositoryWrapper = theMoRepositoryWrapper;
    }

    public FeaturesHolder[] getActivatedFeatures(Coordinator coordinator) {
        ArrayList<FeaturesHolder> featuresList = new ArrayList<FeaturesHolder>();
        for (int i = 0; i < LDN_AND_ATTRIBUTE_HOLDERS.length; ++i) {
            String ldn = OptionalFeaturesHelper.LDN_AND_ATTRIBUTE_HOLDERS[i].ldn;
            ManagedObject managedObject = this.moRepositoryWrapper.lookup(ldn);
            if (managedObject == null) continue;
            try {
                Object[] attributeValues = managedObject.getAttributes(OptionalFeaturesHelper.LDN_AND_ATTRIBUTE_HOLDERS[i].attributeNames, coordinator);
                featuresList.add(new FeaturesHolder(LdnHelper.getLastLdnElement((String)ldn), OptionalFeaturesHelper.LDN_AND_ATTRIBUTE_HOLDERS[i].attributeNames[0], this.getFeatureValue(attributeValues[0])));
                featuresList.add(new FeaturesHolder(LdnHelper.getLastLdnElement((String)ldn), OptionalFeaturesHelper.LDN_AND_ATTRIBUTE_HOLDERS[i].attributeNames[1], this.getLicenseValue(attributeValues[1])));
                continue;
            }
            catch (MoAccessException e) {
                logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)("Failed to read optional features for MO: " + OptionalFeaturesHelper.LDN_AND_ATTRIBUTE_HOLDERS[i].ldn), (Throwable)e));
            }
        }
        FeaturesHolder[] activatedFeatures = new FeaturesHolder[featuresList.size()];
        featuresList.toArray(activatedFeatures);
        return activatedFeatures;
    }

    private String getFeatureValue(Object atttributeValue) {
        int index = -1;
        for (int i = 0; i < FEATURE_AND_LICENCE_VALUES.length; ++i) {
            if (!FEATURE_AND_LICENCE_VALUES[i].equals(atttributeValue)) continue;
            index = i;
            break;
        }
        String result2 = atttributeValue.toString();
        if (index > -1) {
            result2 = FEATURE_NAMES[index];
        }
        return result2;
    }

    private String getLicenseValue(Object object) {
        int index = -1;
        for (int i = 0; i < FEATURE_AND_LICENCE_VALUES.length; ++i) {
            if (!FEATURE_AND_LICENCE_VALUES[i].equals(object)) continue;
            index = i;
            break;
        }
        String result2 = object.toString();
        if (index > -1) {
            result2 = LICENSE_NAMES[index];
        }
        return result2;
    }

    public static class LdnAndAttributeHolder {
        public final String ldn;
        public final String[] attributeNames;

        public LdnAndAttributeHolder(String theLdn, String[] theAttributeNames) {
            this.ldn = theLdn;
            this.attributeNames = theAttributeNames;
        }
    }

    public static class FeaturesHolder {
        public final String moType;
        public final String attributeName;
        public final String attributeValue;

        public FeaturesHolder(String theMoType, String theAttributeName, String theAttributeValue) {
            this.moType = theMoType;
            this.attributeName = theAttributeName;
            this.attributeValue = theAttributeValue;
        }
    }
}

