/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import se.ericsson.cello.equipment.ProgramMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.productinventory.ProductData;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.AbstractRbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class RbsConfigurationConfigHelper
extends AbstractRbsConfigurationHelper {
    private static final Class THIS_CLASS = RbsConfigurationConfigHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)RbsConfigurationConfigHelper.class.getName());

    private boolean isIncludedInLteLoadmoduleList(String productNumber) {
        boolean result2 = false;
        for (int i = 0; i < RbsConfigurationDefinitions.LTE_MP_LOADMODULE_PRODUCT_NUMBERS.length; ++i) {
            if (productNumber.indexOf(RbsConfigurationDefinitions.LTE_MP_LOADMODULE_PRODUCT_NUMBERS[i]) == -1) continue;
            result2 = true;
            break;
        }
        return result2;
    }

    public void setLteMpProgramsRestartCounterLimit(int restartCounterLimit, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "setLteMpProgramsRestartCounterLimit()");
        int resettedAttributes = 0;
        MoIterator moIter = this.genericMaoContext.getMoRepositoryWrapper().lookupType("Program");
        String productNumber = null;
        if (moIter != null) {
            while (moIter.hasMoreElements()) {
                ProgramMo program = (ProgramMo)moIter.nextElement();
                try {
                    ProductData loadModule = (ProductData)program.getLoadModule(coordinator);
                    productNumber = loadModule.getProductNumber(coordinator);
                    if (!this.isIncludedInLteLoadmoduleList(productNumber)) continue;
                    try {
                        program.setRestartCounterLimit(restartCounterLimit, coordinator);
                        ++resettedAttributes;
                    }
                    catch (MoAccessException mae) {
                        String msg = "Could not set restartCounterLimit to " + restartCounterLimit + " for LTE Program MO connected to LoadModule " + productNumber + ": " + mae.getVariablesAsString();
                        logger.traceAbnormal(THIS_CLASS, msg);
                    }
                }
                catch (MoAccessException mae) {
                    String msg = "Could not retrieve necessary information from Program MO  " + program.getLocalDistinguishedName() + ". Original exception: " + mae.getVariablesAsString();
                    logger.traceAbnormal(THIS_CLASS, msg);
                }
            }
            if (resettedAttributes != RbsConfigurationDefinitions.LTE_MP_LOADMODULE_PRODUCT_NUMBERS.length) {
                String msg = "Attribute restartCounterLimit could not be reset for all LTE programs on the MP";
                logger.traceAbnormal(THIS_CLASS, "Attribute restartCounterLimit could not be reset for all LTE programs on the MP");
            }
        }
        logger.traceReturn(THIS_CLASS, "setLteMpProgramsRestartCounterLimit()");
    }

    public String getHelperName() {
        return this.getClass().getName();
    }
}

