/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class RbsConfigurationDhcpHelper {
    private static final Class THIS_CLASS = RbsConfigurationDhcpHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int DHCP_OPTIONS_CODE_SUBNETMASK = 1;
    private static final int DHCP_OPTIONS_CODE_SERVERIDENTIFIER = 54;
    private static final int DHCP_OPTIONS_CODE_DOMAINNAMESERVER = 6;
    private static final int DHCP_OPTIONS_CODE_DEFAULTDOMAINNAME = 62;
    private static final int DHCP_OPTIONS_CODE_DOMAINNAME = 15;
    private static final int DHCP_OPTIONS_CODE_NTP_SERVER = 42;
    private static final int DHCP_OPTIONS_CODE_CLASSLESSROUTEFORMAT = 3;
    private static final int DHCP_OPTIONS_CODE_TFTPSERVER = 66;
    private static final int DHCP_OPTIONS_CODE_BOOTFILE = 67;
    private static final int DHCP_OPTIONS_CODE_WEBSERVER = 72;
    private static final int DHCP_OPTIONS_CODE_SECGW = 241;
    private static final String PROTOCOL_SEPARATOR_SYMBOL = ".";
    private static final String DHCP_OPTION_NO_SEPARATOR = "";
    private final Struct dhcpResult;
    private final Map dhcpOptions = new HashMap();

    public RbsConfigurationDhcpHelper(Struct inputDhcpResult) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "RbsConfigurationDhcpHelper()");
        this.dhcpResult = inputDhcpResult;
        int[] options = null;
        if (this.dhcpResult != null) {
            try {
                options = (int[])this.dhcpResult.getValue("dhcpOptions");
            }
            catch (MoAccessException mae) {
                String slogan = "DHCP failure";
                String faultMsg = "Failed to parse additional options from the DHCP response.";
                throw new RbsConfigurationFailedException("DHCP failure", "Failed to parse additional options from the DHCP response.", (Exception)((Object)mae));
            }
        } else {
            logger.traceDebug(THIS_CLASS, "DHCP options NOT received!");
            String slogan = "DHCP failure";
            String faultMsg = "Failed to parse additional options from the DHCP response.";
            throw new RbsConfigurationFailedException("DHCP failure", "Failed to parse additional options from the DHCP response.");
        }
        logger.traceDebug(THIS_CLASS, "DHCP options received: " + this.dhcpOptionsArrayLog(options));
        this.dhcpOptionsArrayToHashtable(options, 0);
        logger.traceReturn(THIS_CLASS, "RbsConfigurationDhcpHelper()");
    }

    public int[] getNtpIpAddress() {
        int[] a = this.getOptionValue(42);
        if (a == null) {
            a = new int[]{};
        }
        return a;
    }

    public String getIpAddress() throws MoAccessException {
        return (String)this.dhcpResult.getValue("yourIpAddress");
    }

    public String getSubnetMask() {
        String value;
        String result2 = value = this.getValue(1, PROTOCOL_SEPARATOR_SYMBOL);
        if (!value.equalsIgnoreCase(DHCP_OPTION_NO_SEPARATOR)) {
            result2 = value.substring(0, value.length() - 1);
        }
        return result2;
    }

    public String getDhcpIpAddress() {
        String value;
        String result2 = value = this.getValue(54, PROTOCOL_SEPARATOR_SYMBOL);
        if (!value.equalsIgnoreCase(DHCP_OPTION_NO_SEPARATOR)) {
            result2 = value.substring(0, value.length() - 1);
        }
        return result2;
    }

    public String getDnsIpAddress() {
        String value = this.getValue(6, PROTOCOL_SEPARATOR_SYMBOL);
        logger.traceDebug(THIS_CLASS, "getDnsIpAddress() DnsIpAddresses: " + value);
        String result2 = value;
        if (!value.equalsIgnoreCase(DHCP_OPTION_NO_SEPARATOR)) {
            result2 = value.substring(0, value.length() - 1);
        }
        return result2;
    }

    public String getDefaultDomainName() {
        String value = this.getValue(62, DHCP_OPTION_NO_SEPARATOR);
        return value;
    }

    public String getDomainName() {
        String value = this.getValue(15, DHCP_OPTION_NO_SEPARATOR);
        return value;
    }

    public String getDefaultGateway() {
        String value = this.getValue(3, PROTOCOL_SEPARATOR_SYMBOL);
        if (value.indexOf(",") > -1) {
            return value.substring(0, value.indexOf(","));
        }
        return value;
    }

    public String getSmrsIpAddress() {
        String value = this.getValue(66, DHCP_OPTION_NO_SEPARATOR);
        return value;
    }

    public String getSummaryAbsolutePathname() {
        return this.getValue(67, DHCP_OPTION_NO_SEPARATOR);
    }

    public int[] getWebServerAddress() {
        int[] a = this.getOptionValue(72);
        if (a == null) {
            a = new int[]{};
        }
        return a;
    }

    public int[] getSecGwAddress() {
        int[] a = this.getOptionValue(241);
        if (a == null) {
            a = new int[]{};
        }
        return a;
    }

    private String getValue(int dhcpCode, String valueSeparator) {
        String result2 = DHCP_OPTION_NO_SEPARATOR;
        int[] values = this.getOptionValue(dhcpCode);
        StringBuffer val = new StringBuffer();
        if (values != null && values.length != 0) {
            for (int i = 0; i < values.length; ++i) {
                if (valueSeparator.equalsIgnoreCase(DHCP_OPTION_NO_SEPARATOR)) {
                    val.append((char)values[i]);
                    continue;
                }
                if ((i + 1) % 4 != 0) {
                    val.append(values[i] + PROTOCOL_SEPARATOR_SYMBOL);
                    continue;
                }
                val.append(values[i] + ",");
            }
            result2 = val.toString();
        }
        return result2;
    }

    private void dhcpOptionsArrayToHashtable(int[] options, int codeIndex) {
        int optionLength = 0;
        int optionValueStartIndex = codeIndex + 2;
        int optionValueEndIndex = 0;
        try {
            optionLength = options[codeIndex + 1];
        }
        catch (Exception e) {
            return;
        }
        optionValueEndIndex = optionValueStartIndex + optionLength;
        if (optionValueEndIndex >= options.length) {
            logger.traceError(this.getClass(), "dhcpOptionsArrayToHashtable(): Definition of Dhcp Option #" + options[codeIndex] + " is incorrect! optionValueStartIndex = " + optionValueStartIndex + " optionLength = " + optionLength + " options.length = " + options.length);
            return;
        }
        if (codeIndex < options.length) {
            this.dhcpOptions.put(new Integer(options[codeIndex]), this.arrayCopy(options, optionValueStartIndex, optionValueEndIndex));
            this.dhcpOptionsArrayToHashtable(options, optionValueEndIndex);
        }
    }

    private int[] arrayCopy(int[] srcArray, int start, int end) {
        int[] arr = new int[end - start];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = srcArray[i + start];
        }
        return arr;
    }

    private int[] getOptionValue(int dhcpCode) {
        return (int[])this.dhcpOptions.get(new Integer(dhcpCode));
    }

    private String dhcpOptionsArrayLog(int[] inDhcpOptions) {
        String returnVal = DHCP_OPTION_NO_SEPARATOR;
        if (this.dhcpOptions != null && inDhcpOptions.length != 0) {
            StringBuffer log = new StringBuffer();
            for (int index = 0; index < inDhcpOptions.length; ++index) {
                log.append(inDhcpOptions[index]);
                log.append(' ');
            }
            returnVal = log.toString();
        }
        return returnVal;
    }
}

