/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.FileHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.AbstractRbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class RbsConfigurationHelper
extends AbstractRbsConfigurationHelper {
    public static final Object WAITING_MUTEX = new Object();
    private static final Class THIS_CLASS = RbsConfigurationHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private transient String currentAction = "";
    private transient int noOfRetries = 0;
    private Boolean integrationCompletePostSetExecuted = Boolean.FALSE;

    public void createLocalPaths() {
        logger.traceEnter(THIS_CLASS, "createLocalPaths()");
        File localPath = new File(this.getLocalPath());
        if (localPath.exists()) {
            logger.traceDebug(THIS_CLASS, "Verified that the local path " + this.getLocalPath() + " exists.");
        } else if (localPath.mkdirs()) {
            logger.traceDebug(THIS_CLASS, "Created the local path " + this.getLocalPath() + " needed for upgrade.");
        } else {
            logger.traceAbnormal(THIS_CLASS, "Failed to create the local path " + this.getLocalPath() + " needed for upgrade!");
        }
        File logDirPath = new File(this.getLogDirPath());
        if (logDirPath.exists()) {
            logger.traceDebug(THIS_CLASS, "Verified that the log directory " + this.getLogDirPath() + " exists.");
        } else if (logDirPath.mkdirs()) {
            logger.traceDebug(THIS_CLASS, "Created the log directory " + this.getLogDirPath() + " needed for log files.");
        } else {
            logger.traceAbnormal(THIS_CLASS, "Failed to create the log directory " + this.getLogDirPath() + " needed for log files!");
        }
        logger.traceReturn(THIS_CLASS, "createLocalPaths()");
    }

    public static boolean existsAndNotEmpty(String string) {
        return string != null && !"".equals(string) && !"-".equals(string);
    }

    public String getLocalPath() {
        logger.traceEnter(THIS_CLASS, "getLocalPath()");
        String localPath = "/c/systemfiles/lte/autointegration/";
        if (!"true".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            try {
                FileHelper.createDirectoryTree((String)localPath);
            }
            catch (FileHelper.FileException e) {
                logger.traceError(THIS_CLASS, "Fail to create directory tree: " + localPath);
            }
        }
        if ("true".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            localPath = System.getProperty("user.home");
        }
        if (!localPath.endsWith(File.separator)) {
            localPath = localPath + File.separator;
        }
        logger.traceReturn(THIS_CLASS, "getLocalPath() = '" + localPath + "'");
        return localPath;
    }

    public String getLogDirPath() {
        logger.traceEnter(THIS_CLASS, "getLogDirPath()");
        String logDirPath = "/c/logfiles/autointegration";
        if ("true".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            logDirPath = System.getProperty("user.home");
        }
        if (!logDirPath.endsWith(File.separator)) {
            logDirPath = logDirPath + File.separator;
        }
        logger.traceReturn(THIS_CLASS, "getLogDirPath() = '" + logDirPath + "'");
        return logDirPath;
    }

    public Integer getRbsConfigLevel() {
        logger.traceEnter(THIS_CLASS, "getRbsConfigLevel()");
        Integer currentConfigurationLevel = null;
        try {
            currentConfigurationLevel = (Integer)this.rbsConfiguration.getAttribute("rbsConfigLevel");
        }
        catch (MoAccessException e) {
            logger.traceError(THIS_CLASS, "getRbsConfigLevel(): Could not get the rbsConfigLevel attribute in the RbsConfiguration MO");
        }
        logger.traceReturn(THIS_CLASS, "getRbsConfigLevel() = " + currentConfigurationLevel);
        return currentConfigurationLevel;
    }

    public void removeFile(String filePath) {
        File file;
        logger.traceEnter(THIS_CLASS, "removeFile() - " + filePath);
        if (filePath != null && (file = new File(filePath)).exists()) {
            file.delete();
        }
        logger.traceReturn(THIS_CLASS, "removeFile() - " + filePath);
    }

    public void copyFile(String sourceFilePath, String destinationFilePath) {
        logger.traceEnter(THIS_CLASS, "copyFile() - " + sourceFilePath + " " + destinationFilePath);
        if (sourceFilePath != null && destinationFilePath != null) {
            File sourceFile = new File(sourceFilePath);
            if (sourceFile.exists()) {
                File destinationFile = new File(destinationFilePath);
                if (destinationFile.exists()) {
                    logger.traceDebug(THIS_CLASS, "destinationFile already exist will be deleted");
                    destinationFile.delete();
                }
                try {
                    FileHelper.copyFile((File)sourceFile, (File)destinationFile);
                }
                catch (IOException e) {
                    logger.traceDebug(THIS_CLASS, "Failed to move file " + sourceFilePath + " to " + destinationFilePath);
                }
            } else {
                logger.traceDebug(THIS_CLASS, "sourceFile don't exist moveFile can't be performed");
            }
        }
        logger.traceReturn(THIS_CLASS, "copyFile()");
    }

    public void saveTextFile(String contents, String filepath) throws IOException {
        logger.traceEnter(THIS_CLASS, "saveTextFile() - " + filepath);
        File file = new File(filepath);
        PrintWriter out = new PrintWriter(new FileWriter(file));
        out.print(contents);
        out.close();
        logger.traceReturn(THIS_CLASS, "saveTextFile() - " + filepath);
    }

    public void setConfigurationStateAndProgressLevel(int newCurrentState) {
        logger.traceEnter(THIS_CLASS, "setConfigurationState(newCurrentState) - " + newCurrentState);
        try {
            int maybeNewPl = RbsConfigurationHelper.toValidProgressLevel(newCurrentState);
            Integer currentPl = (Integer)this.rbsConfiguration.getAttribute("progressLevel");
            if (maybeNewPl > currentPl && maybeNewPl <= 100) {
                this.rbsConfiguration.setReadOnlyAttribute("progressLevel", new Integer(maybeNewPl));
            }
            this.rbsConfiguration.storePersistently("configurationState", new Integer(newCurrentState));
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "setConfigurationState(newCurrentState- " + newCurrentState + "): " + "Could not set/get attributes! Original exception: " + mae.getVariablesAsString());
        }
        logger.traceReturn(THIS_CLASS, "setConfigurationState(newCurrentState) - " + newCurrentState);
    }

    public void setConfigurationStateAndProgressLevel(int newCurrentState, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "setConfigurationState(newCurrentState) - " + newCurrentState);
        try {
            int maybeNewPl = RbsConfigurationHelper.toValidProgressLevel(newCurrentState);
            Integer currentPl = (Integer)this.rbsConfiguration.getAttribute("progressLevel", coordinator);
            if (maybeNewPl > currentPl && maybeNewPl <= 100) {
                this.rbsConfiguration.setReadOnlyAttribute("progressLevel", new Integer(maybeNewPl), coordinator);
            }
            if (coordinator == null) {
                this.rbsConfiguration.storePersistently("configurationState", new Integer(newCurrentState));
            } else {
                this.rbsConfiguration.storePersistently("configurationState", new Integer(newCurrentState), coordinator);
            }
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "setConfigurationState(newCurrentState - " + newCurrentState + ",coordinator): " + "Could not set/get attributes! Original exception: " + mae.getVariablesAsString());
        }
        logger.traceReturn(THIS_CLASS, "setConfigurationState(newCurrentState) - " + newCurrentState);
    }

    private static int toValidProgressLevel(int level) {
        return level - level % 10;
    }

    public void setFaultReason(Integer faultReason, String faultSlogan, String faultInformation) {
        logger.traceEnter(THIS_CLASS, "setFaultReason() - reason = " + faultReason + ", slogan = " + faultSlogan);
        this.setFaultReason(faultReason, faultSlogan, faultInformation, null);
        logger.traceReturn(THIS_CLASS, "setFaultReason()");
    }

    public void setFaultReason(Integer faultReason, String faultSlogan, String faultInformation, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "setFaultReason() - reason = " + faultReason + ", slogan = " + faultSlogan);
        this.rbsConfiguration.setFaultReason(faultReason, faultSlogan, faultInformation, coordinator);
        logger.traceReturn(THIS_CLASS, "setFaultReason()");
    }

    public void clearConfigFaultReason() throws RbsConfigurationFailedException {
        this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "", "", null);
    }

    public void setRbsConfigLevel(Integer rbsConfigLevel, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "setRbsConfigLevel() - " + rbsConfigLevel);
        try {
            this.rbsConfiguration.setAttribute("rbsConfigLevel", rbsConfigLevel, coordinator);
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "setRbsConfigLevel(rbsConfigLevel - " + rbsConfigLevel + ",coordinator): " + "Could not set the " + "rbsConfigLevel" + " attribute in the RbsConfiguration MO: " + mae.getVariablesAsString());
        }
        catch (Exception exc) {
            logger.traceError(THIS_CLASS, "setRbsConfigLevel(rbsConfigLevel - " + rbsConfigLevel + ",coordinator): " + "Could not set the " + "rbsConfigLevel" + " attribute in the RbsConfiguration MO: " + exc.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "setRbsConfigLevel()");
    }

    public void setRbsConfigLevel(Integer rbsConfigLevel) {
        logger.traceEnter(THIS_CLASS, "setRbsConfigLevel() - " + rbsConfigLevel);
        try {
            this.rbsConfiguration.setAttribute("rbsConfigLevel", rbsConfigLevel);
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "setRbsConfigLevel(rbsConfigLevel - " + rbsConfigLevel + "): " + "Could not set the " + "rbsConfigLevel" + " attribute in the RbsConfiguration MO: " + mae.getVariablesAsString());
        }
        catch (Exception exc) {
            logger.traceError(THIS_CLASS, "setRbsConfigLevel(rbsConfigLevel - " + rbsConfigLevel + "): " + "Could not set the " + "rbsConfigLevel" + " attribute in the RbsConfiguration MO: " + exc.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "setRbsConfigLevel()");
    }

    public void setRbsProgressInformation(Integer rbsPi) {
        logger.traceEnter(THIS_CLASS, "setRbsProgressInformation() - " + rbsPi);
        try {
            this.rbsConfiguration.setReadOnlyAttribute("progressInformation", rbsPi);
            RbsConfigurationReportLoggerFactory.getLogger().logAttribute(this.rbsConfiguration.getType(), "progressInformation", RbsConfigurationDefinitions.RBS_PI[rbsPi]);
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "setRbsProgressInformation(rbsPi - " + rbsPi + "): " + "Could not set the " + "progressInformation" + " attribute in the RbsConfiguration MO." + mae.getVariablesAsString());
        }
        logger.traceReturn(THIS_CLASS, "setRbsProgressInformation()");
    }

    public void setRbsProgressInformation(Integer rbsPi, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "setRbsProgressInformation() - " + rbsPi);
        try {
            this.rbsConfiguration.setReadOnlyAttribute("progressInformation", rbsPi, coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAttribute(this.rbsConfiguration.getType(), "progressInformation", RbsConfigurationDefinitions.RBS_PI[rbsPi], coordinator);
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "setRbsProgressInformation(rbsPi - " + rbsPi + ", coordinator): " + "Could not set the " + "progressInformation" + " attribute in the RbsConfiguration MO." + mae.getVariablesAsString());
        }
        logger.traceReturn(THIS_CLASS, "setRbsProgressInformation()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRetry(String action) {
        logger.traceEnter(THIS_CLASS, "waitForRetry(action) - " + action);
        if (!this.currentAction.equals(action)) {
            this.currentAction = action;
            this.noOfRetries = 1;
        }
        long time = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST")) ? 10L : (this.noOfRetries <= 3 ? 5000L : 100000L);
        try {
            logger.traceDebug(THIS_CLASS, "Sleeping for " + (double)time / 1000.0 + " seconds before new retry. This is the retry number " + this.noOfRetries + ".");
            Object object = WAITING_MUTEX;
            synchronized (object) {
                WAITING_MUTEX.wait(time);
            }
        }
        catch (InterruptedException ie) {
            logger.traceError(THIS_CLASS, "waitForRetry(action - " + action + "):" + "Interrupted while waiting to retry action " + action, (Throwable)ie);
        }
        ++this.noOfRetries;
        logger.traceReturn(THIS_CLASS, "waitForRetry(action) - " + action);
    }

    public void verifyConfigLevel(Integer correctConfigurationLevel) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "verifyConfigLevel() - expected ConfigurationLevel = " + correctConfigurationLevel);
        Integer currentConfigurationLevel = null;
        try {
            currentConfigurationLevel = (Integer)this.rbsConfiguration.getAttribute("rbsConfigLevel");
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException("Could not verify correct config level of the RBS.");
        }
        if (!correctConfigurationLevel.equals(currentConfigurationLevel)) {
            String faultMsg = "Configuration level is " + currentConfigurationLevel + ", should be " + correctConfigurationLevel;
            this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_WRONG_INITIAL_CONFIG_LEVEL, "Validation of rbsConfigLevel", faultMsg);
            throw new RbsConfigurationFailedException("Incorret configuration level. " + faultMsg);
        }
        logger.traceReturn(THIS_CLASS, "verifyConfigLevel() - correct ConfigurationLevel!");
    }

    public String getHelperName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrationCompletePostSetHasBeenExecuted() {
        logger.traceEnter(THIS_CLASS, "integrationCompletePostSetHasBeenExecuted()");
        Boolean bl = this.integrationCompletePostSetExecuted;
        synchronized (bl) {
            this.integrationCompletePostSetExecuted = Boolean.TRUE;
        }
        logger.traceReturn(THIS_CLASS, "integrationCompletePostSetHasBeenExecuted()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIntegrationCompletePostSetBeenExecuted() {
        logger.traceEnter(THIS_CLASS, "hasIntegrationCompletePostSetBeenExecuted()");
        boolean result2 = false;
        Boolean bl = this.integrationCompletePostSetExecuted;
        synchronized (bl) {
            result2 = this.integrationCompletePostSetExecuted;
        }
        logger.traceReturn(THIS_CLASS, "hasIntegrationCompletePostSetBeenExecuted()");
        return result2;
    }
}

