/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.io.IOException;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.AbstractRbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.IpV4AddressHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationIpHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RbsConfigurationIpHelperImpl
extends AbstractRbsConfigurationHelper
implements RbsConfigurationIpHelper {
    private MoRepositoryWrapper aMoRepository;
    private static final Class THIS_CLASS = RbsConfigurationIpHelperImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    protected void init(GenericMaoContext aGenericMaoContext, RbsConfigurationMao aRbsConfiguration, RbsConfigurationContext aRbsConfigurationContext) {
        super.init(aGenericMaoContext, aRbsConfiguration, aRbsConfigurationContext);
        this.aMoRepository = this.genericMaoContext.getMoRepositoryWrapper();
    }

    public static String calculateSubnetString(String inIpAddress, String inSubnetMask) {
        logger.traceEnter(THIS_CLASS, "calculateSubnetString() " + inIpAddress + " " + inSubnetMask);
        IpV4AddressHolder subnet = RbsConfigurationIpHelperImpl.calculateSubnet(inIpAddress, inSubnetMask);
        logger.traceReturn(THIS_CLASS, "calculateSubnetString() subnet:" + subnet.toString());
        return subnet.toString();
    }

    public static IpV4AddressHolder calculateSubnet(String inIpAddress, String inSubnetMask) {
        logger.traceEnter(THIS_CLASS, "calculateSubnet() " + inIpAddress + " " + inSubnetMask);
        IpV4AddressHolder ipAddr = new IpV4AddressHolder(inIpAddress);
        IpV4AddressHolder mask = new IpV4AddressHolder(inSubnetMask);
        IpV4AddressHolder subnet = IpV4AddressHolder.bitwiseAnd(ipAddr, mask);
        logger.traceReturn(THIS_CLASS, "calculateSubnet() subnet:" + subnet.toString());
        return subnet;
    }

    public static Integer calculateNetworkPrefixLength(String subnetworkMask) throws IOException {
        Integer networkPrefixLength;
        try {
            String networkPrefixBinary = "";
            int firstPeriod = subnetworkMask.indexOf(46);
            int secondPeriod = subnetworkMask.indexOf(46, firstPeriod + 1);
            int thirdPeriod = subnetworkMask.indexOf(46, secondPeriod + 1);
            int snFieldA = Integer.parseInt(subnetworkMask.substring(0, firstPeriod));
            int snFieldB = Integer.parseInt(subnetworkMask.substring(firstPeriod + 1, secondPeriod));
            int snFieldC = Integer.parseInt(subnetworkMask.substring(secondPeriod + 1, thirdPeriod));
            int snFieldD = Integer.parseInt(subnetworkMask.substring(thirdPeriod + 1));
            networkPrefixBinary = Integer.toBinaryString(snFieldA) + Integer.toBinaryString(snFieldB) + Integer.toBinaryString(snFieldC) + Integer.toBinaryString(snFieldD);
            int lastOne = networkPrefixBinary.lastIndexOf(49);
            int firstZero = networkPrefixBinary.indexOf(48);
            if (firstZero < lastOne) {
                String msg = "SubnetworkMask " + subnetworkMask + " is not a valid mask";
                throw new IOException(msg);
            }
            networkPrefixLength = new Integer(networkPrefixBinary.lastIndexOf(49) + 1);
            logger.traceReturn(THIS_CLASS, "calculateNetworkPrefixLength() result: " + networkPrefixLength);
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            throw new IOException("Provided SubnetMask is not of correct type");
        }
        return networkPrefixLength;
    }

    public String getOamIpAddress(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getOamIpAddress()");
        String exceptionInfo = "";
        String result2 = "";
        IpMo ipMo = (IpMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
        String ipv6NodeIpAddress = ipMo.getNodeIpv6Address(coordinator);
        if (RbsConfigurationHelper.existsAndNotEmpty(ipv6NodeIpAddress)) {
            exceptionInfo = exceptionInfo + "nodeInterfaceName: " + ipMo + "with" + ipv6NodeIpAddress;
            result2 = ipv6NodeIpAddress;
        } else {
            String ipv4NodeIpAddress = ipMo.getNodeIpAddress(coordinator);
            if (RbsConfigurationHelper.existsAndNotEmpty(ipv4NodeIpAddress)) {
                exceptionInfo = exceptionInfo + "nodeInterfaceName: " + ipMo + "with" + ipv4NodeIpAddress;
                result2 = ipv4NodeIpAddress;
            }
        }
        if (result2 == null || "".equals(result2)) {
            throw new RbsConfigurationFailedException("Unable to find O&M Ip Address! " + exceptionInfo);
        }
        return result2;
    }

    public String getHelperName() {
        return this.getClass().getName();
    }

    public static String calculateSubnetMaskFromNetworkPrefix(int networkPrefix) {
        int shiftby = Integer.MIN_VALUE;
        for (int i = networkPrefix - 1; i > 0; --i) {
            shiftby >>= 1;
        }
        String mask = Integer.toString(shiftby >> 24 & 0xFF) + "." + Integer.toString(shiftby >> 16 & 0xFF) + "." + Integer.toString(shiftby >> 8 & 0xFF) + "." + Integer.toString(shiftby & 0xFF);
        return mask;
    }

    public static boolean isIpv4Address(String address) {
        int dotIndex = -1;
        int colonIndex = -1;
        if (address != null) {
            dotIndex = address.indexOf(".");
            colonIndex = address.indexOf(":");
        }
        return dotIndex > -1 && colonIndex == -1;
    }
}

