/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RbsConfigurationMoFinder {
    private static final Class THIS_CLASS = RbsConfigurationMoFinder.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient MoRepositoryWrapper aMoRepository;

    public RbsConfigurationMoFinder(GenericMaoContext aGenericMaoContext) {
        logger.traceEnter(THIS_CLASS, "RbsConfigurationMoFinder()");
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        logger.traceReturn(THIS_CLASS, "RbsConfigurationMoFinder()");
    }

    public ManagedObject lookup(String moName, String refLdn, String failureSlogan) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "lookup() " + moName);
        ManagedObject refMo = this.aMoRepository.lookup(refLdn);
        if (refMo == null) {
            String msg = "The MO " + moName + " has a referenced MO that can not be found, LDN: " + refLdn + ".";
            throw new RbsConfigurationFailedException(failureSlogan, msg);
        }
        logger.traceReturn(THIS_CLASS, "lookup() " + refMo.getLocalDistinguishedName());
        return refMo;
    }

    public ManagedObject lookupChild(ManagedObject parent, String moType) {
        logger.traceEnter(THIS_CLASS, "lookupChild() MO type: " + moType + " parent: " + parent.getLocalDistinguishedName());
        ManagedObject theMo = null;
        MoIterator moIter = parent.getChildren();
        while (moIter.hasMoreElements()) {
            ManagedObject currentMo = moIter.nextMo();
            if (!moType.equalsIgnoreCase(currentMo.getType())) continue;
            theMo = currentMo;
            break;
        }
        logger.traceReturn(THIS_CLASS, "lookupChild() MO: " + (theMo == null ? "Not found" : theMo.getLocalDistinguishedName()) + ".");
        return theMo;
    }
}

