/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.net.FTPException;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.common.ftp.FtpFaultNumberTranslationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.AbstractRbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationReportHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.smrs.SftpDataHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.smrs.SmrsDataHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.UpgradeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.smrs.FtpInfo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.smrs.SmrsInfo;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.FTPClientWrapperFactory;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class RbsConfigurationSmrsHelper
extends AbstractRbsConfigurationHelper {
    private static final Class THIS_CLASS = RbsConfigurationSmrsHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private RbsConfigurationHelper helper;
    private final FtpFaultNumberTranslationHelper ftpFaultNumberTranslater = new FtpFaultNumberTranslationHelper();
    private transient FTPClientWrapperFactory ftpFactory;
    private SmrsDataHandler smrsDataHandler = null;
    private SftpDataHandler sftpDataHandler = null;
    private int counter = 0;
    private static final int LTE = 1;
    private static final int WCDMA = 2;
    private int ran = 0;

    protected void init(GenericMaoContext aGenericMaoContext, RbsConfigurationMao rbsConfigurationMao, RbsConfigurationContext aRbsConfigurationContext) {
        super.init(aGenericMaoContext, rbsConfigurationMao, aRbsConfigurationContext);
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        this.ftpFactory = aGenericMaoContext.getFTPClientWrapperFactory();
        this.smrsDataHandler = new SmrsDataHandler(rbsConfigurationMao);
        this.sftpDataHandler = new SftpDataHandler(rbsConfigurationMao);
    }

    public SmrsInfo getSmrsInfo() {
        return this.smrsDataHandler.getSmrsInfo();
    }

    public void readSmrsInfo() {
        this.smrsDataHandler.readSmrsInfo();
    }

    public void storeSmrsServerAddressIfEmpty(String smrsServer) throws MoAccessException {
        this.smrsDataHandler.storeSmrsServerAddressIfEmpty(smrsServer);
    }

    public void storeSummaryFilePathIfEmpty(String smrsSummaryFilePath) throws MoAccessException {
        this.smrsDataHandler.storeSummaryFilePathIfEmpty(smrsSummaryFilePath);
    }

    public void storeSmrsDataPersistently(String smrsUserName, String smrsPassword, String smrsServer, String summaryFilePath) throws MoAccessException {
        this.smrsDataHandler.storeSmrsDataPersistently(smrsUserName, smrsPassword, smrsServer, summaryFilePath);
    }

    protected Map getAndParseSummaryFile(String summaryFilePathOnNode, String failureSlogan) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getAndParseSummaryFile()");
        HashMap configFiles = new HashMap();
        while (true) {
            this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_FETCHING_SUMMARY_FILE);
            boolean success = this.isNodeSelfConfiguration();
            FtpInfo localFtpInfo = this.getFtpInfo();
            while (!success) {
                success = this.getFileFromFtp(true, 300, localFtpInfo.getSummaryFilePath(), summaryFilePathOnNode);
                if (success) continue;
                this.helper.waitForRetry("Fetching Summary file: " + localFtpInfo.getSummaryFilePath() + ".");
                localFtpInfo = this.getFtpInfo();
            }
            try {
                this.updateProgressReportInformation(400, 3, "Reading Summary file retrieved from FTP server", true);
                configFiles.putAll(this.parseSummaryFile(summaryFilePathOnNode));
                this.updateProgressReportInformation(400, 5, "Successfully read Summary file retrieved from FTP server", true);
                ProgressReportHandler.getInstance().removeErroneousSmrsInfo();
            }
            catch (IOException ioe) {
                String errorMsg = "Failed to process the given summary file, \"" + summaryFilePathOnNode + "\". Message: " + ioe.getMessage() + ". Retrying with new file.";
                this.updateProgressReportInformation(300, 4, errorMsg, false);
                this.updateProgressReportInformation(400, 4, errorMsg, true);
                if (localFtpInfo instanceof SmrsInfo) {
                    ProgressReportHandler.getInstance().addWrongUserAndOrPassword(errorMsg, (SmrsInfo)localFtpInfo);
                }
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SUMMARY_FILE_FAULT, failureSlogan, errorMsg);
                this.helper.waitForRetry("ParseSummaryFile");
                continue;
            }
            break;
        }
        logger.traceReturn(THIS_CLASS, "getAndParseSummaryFile()");
        return configFiles;
    }

    public Map parseSummaryFile(String summaryFilePath) throws IOException {
        return this.parseSummaryFile(summaryFilePath, false, null);
    }

    protected Map parseSummaryFile(String summaryFilePath, boolean validateXml, String schemaPath) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseSummaryFile() - summaryFilePath = " + summaryFilePath);
        HashMap configFiles = new HashMap();
        Parser parser = ParserHelper.createParser(summaryFilePath, validateXml, schemaPath);
        List xmlList = parser.getXMLelements();
        String revision = "";
        if (xmlList == null) {
            throw new IOException("Could not parse SummaryFile, invalid XML.");
        }
        Iterator xmlIter = xmlList.iterator();
        int ranCounter = 0;
        while (xmlIter.hasNext()) {
            XMLElement xmlElement = (XMLElement)xmlIter.next();
            String xmlChildType = xmlElement.getType();
            if ("Format".equals(xmlChildType)) {
                revision = xmlElement.getAttributes().getValue("revision");
                logger.traceDebug(THIS_CLASS, "parseSummaryFile() revision=" + revision);
            }
            if ("WcdmaConfigurationFiles".equals(xmlChildType)) {
                ++ranCounter;
                this.ran = 2;
                String oamAccessFilePath = this.putSmrsFile("oamAccessFilePath", xmlElement, configFiles);
                String siteEquipFilePathWcdma = this.putSmrsFile("siteEquipmentFilePath", xmlElement, configFiles);
                logger.traceDebug(THIS_CLASS, "parseSummaryFile() oamAccessFilePath=" + oamAccessFilePath + " siteEquipFilePathWcdma=" + siteEquipFilePathWcdma);
                if (oamAccessFilePath == null || siteEquipFilePathWcdma == null) {
                    throw new IOException("Invalid summaryfile: WCDMA required file(s) (OAM Access or Site Equipment) are  missing.");
                }
                this.putSmrsFile("cabinetEquipmentFilePath", xmlElement, configFiles);
                this.putSmrsFile("antennaSystemFilePath", xmlElement, configFiles);
                this.putSmrsFile("upgradePackageFilePath", xmlElement, configFiles);
                this.putSmrsFile("integrationBasicPackageFilePath", xmlElement, configFiles);
            }
            if (!"ConfigurationFiles".equals(xmlChildType)) continue;
            ++ranCounter;
            this.ran = 1;
            String siteBasicFilePath = this.putSmrsFile("siteBasicFilePath", xmlElement, configFiles);
            String ipForOamSettingFilePath = this.putSmrsFile("ipForOamSettingFilePath", xmlElement, configFiles);
            String siteEquipFilePathLte = this.putSmrsFile("siteEquipmentFilePath", xmlElement, configFiles);
            logger.traceDebug(THIS_CLASS, "parseSummaryFile() siteBasicFilePath=" + siteBasicFilePath + " ipForOamSettingFilePath=" + ipForOamSettingFilePath + " siteEquipFilePathLte=" + siteEquipFilePathLte);
            if (ipForOamSettingFilePath == null && siteBasicFilePath == null && siteEquipFilePathLte == null) {
                throw new IOException("Invalid summaryfile: LTE required file(s) are  missing.");
            }
            if (ipForOamSettingFilePath == null && (siteBasicFilePath == null || siteEquipFilePathLte == null)) {
                throw new IOException("Invalid summaryfile: Site Basic or Site Equipment is missing.");
            }
            if (ipForOamSettingFilePath != null && (siteBasicFilePath != null || siteEquipFilePathLte != null)) {
                throw new IOException("Invalid summaryfile: To many configuration files.");
            }
            this.putSmrsFile("integrationBasicPackageFilePath", xmlElement, configFiles);
            this.putSmrsFile("licensingKeyFilePath", xmlElement, configFiles);
            this.putSmrsFile("upgradePackageFilePath", xmlElement, configFiles);
            this.putSmrsFile("initialSecurityConfigurationFilePath", xmlElement, configFiles);
            this.putSmrsFile("initialSecurityConfigurationFileHash", xmlElement, configFiles);
            this.putSmrsFile("siteBasicFileHash", xmlElement, configFiles);
            this.putSmrsFile("ipForOamSettingFileHash", xmlElement, configFiles);
        }
        if (ranCounter != 1) {
            throw new IOException("Invalid summaryfile: None or more than one RAN detected.");
        }
        logger.traceReturn(THIS_CLASS, "parseSummaryFile()");
        return configFiles;
    }

    private String putSmrsFile(String inputPath, XMLElement xmlElement, Map smrsFiles) {
        String outPath = xmlElement.getAttributes().getValue(inputPath);
        if (outPath != null) {
            smrsFiles.put(inputPath, outPath);
        }
        return outPath;
    }

    public void getAndProcessSummaryFile() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getAndProcessSummaryFile()");
        if (this.checkLocalFilePaths()) {
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("Configuration files", "All configuration files available locally, will not contact the SMRS.");
        } else {
            try {
                this.fetchFiles();
            }
            catch (MoAccessException mae) {
                String errorMsg = "Generic fault when storing attributes persistently.";
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Generic fault", "Generic fault when storing attributes persistently.");
                logger.traceDebug(THIS_CLASS, "getAndProcessSummaryFile(): Generic fault when storing attributes persistently. " + (Object)((Object)mae));
                ProgressReportHandler.getInstance().addWrongUserAndOrPassword("Generic fault when storing attributes persistently.", this.getSmrsInfo());
                throw new RbsConfigurationFailedException("Generic fault when storing attributes persistently.");
            }
        }
        logger.traceReturn(THIS_CLASS, "getAndProcessSummaryFile()");
    }

    private FtpInfo getFtpInfo() {
        FtpInfo localFtpInfo = null;
        localFtpInfo = this.sftpDataHandler.isSftpInfoSet() ? this.sftpDataHandler.getRefreshedSftpInfo() : this.smrsDataHandler.getSmrsInfo();
        return localFtpInfo;
    }

    protected void fetchFiles() throws RbsConfigurationFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "fetchFiles()");
        String failureSlogan = "File failure";
        FtpInfo localFtpInfo = this.getFtpInfo();
        if (RbsConfigurationHelper.existsAndNotEmpty(localFtpInfo.getSummaryFilePath())) {
            this.checkFtpAttributes(localFtpInfo);
            Map configFiles = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? this.getAndParseSummaryFile(RbsConfigurationReportHelper.dirName + "SummaryFile.xml", "File failure") : this.getAndParseSummaryFile(this.helper.getLocalPath() + "SummaryFile.xml", "File failure");
            ProgressReportHandler.getInstance().removeErroneousSmrsInfo();
            if (this.ran == 1) {
                this.fetchSiteBasicFile(configFiles);
                this.fetchSiteEquipmentFile(configFiles);
                ProgressReportHandler.getInstance().removeErroneousSmrsInfo();
                this.storeInitialSecurityConfigurationFile(configFiles);
                this.storeLicenseKeyFilePath(configFiles);
                this.storeUpgradeFilePath(configFiles);
                this.fetchIntegrationBp(configFiles);
            } else if (this.ran == 2) {
                this.fetchOamAccessFile(configFiles);
                this.fetchSiteEquipmentFile(configFiles);
                this.fetchAntennaSystemFile(configFiles);
                this.fetchCabinetEquipmentFile(configFiles);
                this.fetchIntegrationBp(configFiles);
                this.storeUpgradeFilePath(configFiles);
            }
        } else {
            this.updateProgressReportInformation(1500, 2, "Site Basic file local - will not contact SMRS server", false);
            this.updateProgressReportInformation(900, 2, "Site Equipment file local - will not contact SMRS server", false);
            this.updateProgressReportInformation(500, 2, "Upgrade Package local - will not contact SMRS server", false);
            this.updateProgressReportInformation(300, 2, "All configuration files are local - no need to fetch Summary file from SMRS server", false);
            this.updateProgressReportInformation(400, 2, "All configuration files are local - no need to read Summary file", true);
        }
        logger.traceReturn(THIS_CLASS, "fetchFiles()");
    }

    private void fetchAntennaSystemFile(Map configFiles) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "fetchAntennaSystemFile()");
        String antennaSystemtFilePath = FileParameters.instance().getAntennaSystemFilePath();
        ProgressReportHandler.getInstance().removeErroneousSmrsInfo();
        if (RbsConfigurationHelper.existsAndNotEmpty(antennaSystemtFilePath)) {
            this.updateProgressReportInformation(0, 2, "Antenna System file local - will not contact FTP server", true);
        } else {
            String remoteAntennaSystemFilePath = (String)configFiles.get("antennaSystemFilePath");
            if (RbsConfigurationHelper.existsAndNotEmpty(remoteAntennaSystemFilePath)) {
                RbsConfigurationReportLoggerFactory.getLogger().logInformation("Configuration files", "Fetching WCDMA AntennaSystem file from FTP.");
                String localAntennaSystemFilePath = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? RbsConfigurationReportHelper.dirName + "AntennaSystem.xml" : this.helper.getLocalPath() + "AntennaSystem.xml";
                FileParameters.instance(this.rbsConfiguration).setAntennaSystemFilePath(localAntennaSystemFilePath);
                this.getFileFromFtp(0, remoteAntennaSystemFilePath, localAntennaSystemFilePath);
            } else {
                this.updateProgressReportInformation(0, 2, "No Antenna System file specified. ", true);
            }
            FileParameters.instance().setAntennaSystemRemotePath(remoteAntennaSystemFilePath);
        }
        logger.traceReturn(THIS_CLASS, "fetchAntennaSystemFile()");
    }

    private void fetchCabinetEquipmentFile(Map configFiles) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "fetchCabinetEquipmentFile()");
        String cabinetEquipmentFilePath = FileParameters.instance().getCabinetEquipmentFilePath();
        ProgressReportHandler.getInstance().removeErroneousSmrsInfo();
        if (RbsConfigurationHelper.existsAndNotEmpty(cabinetEquipmentFilePath)) {
            this.updateProgressReportInformation(0, 2, "Cabinet Equipment file local - will not contact FTP server", true);
        } else {
            String remoteCabinetEquipFilePath = (String)configFiles.get("cabinetEquipmentFilePath");
            if (RbsConfigurationHelper.existsAndNotEmpty(remoteCabinetEquipFilePath)) {
                RbsConfigurationReportLoggerFactory.getLogger().logInformation("Configuration files", "Fetching WCDMA CabinetEquipment file from FTP.");
                String localCabinetEquipFilePath = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? RbsConfigurationReportHelper.dirName + "CabinetEquipment.xml" : this.helper.getLocalPath() + "CabinetEquipment.xml";
                FileParameters.instance(this.rbsConfiguration).setCabinetEquipmentFilePath(localCabinetEquipFilePath);
                this.getFileFromFtp(0, remoteCabinetEquipFilePath, localCabinetEquipFilePath);
            } else {
                this.updateProgressReportInformation(0, 2, "No Cabinet Equipment file specified. ", true);
            }
            FileParameters.instance().setCabinetEquipmentRemotePath(remoteCabinetEquipFilePath);
        }
        logger.traceReturn(THIS_CLASS, "fetchCabinetEquipmentFile()");
    }

    private void fetchOamAccessFile(Map configFiles) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "fetchOamAccessFile()");
        ProgressReportHandler.getInstance().removeErroneousSmrsInfo();
        String oamAccessFilePath = FileParameters.instance().getOamAccessFilePath();
        if (RbsConfigurationHelper.existsAndNotEmpty(oamAccessFilePath)) {
            this.updateProgressReportInformation(0, 2, "OAM Access file local - will not contact FTP server", true);
        } else {
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("Configuration files", "Fetching WCDMA OAM Access file from FTP-server.");
            String localOamAccessFilePath = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? RbsConfigurationReportHelper.dirName + "OamAccess.xml" : this.helper.getLocalPath() + "OamAccess.xml";
            FileParameters.instance(this.rbsConfiguration).setOamAccessFilePath(localOamAccessFilePath);
            String remoteOamAccessPath = (String)configFiles.get("oamAccessFilePath");
            this.getFileFromFtp(0, remoteOamAccessPath, localOamAccessFilePath);
            FileParameters.instance().setOamAccessRemotePath(remoteOamAccessPath);
        }
        logger.traceReturn(THIS_CLASS, "fetchOamAccessFile()");
    }

    private void fetchIntegrationBp(Map configFiles) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "fetchIntegrationBp()");
        String integrationBpFilePath = FileParameters.instance().getIntegrationBasicPackageFilePath();
        if (RbsConfigurationHelper.existsAndNotEmpty(integrationBpFilePath)) {
            this.updateProgressReportInformation(0, 2, "Integration Basic Pakage zip file local - will not contact FTP server", true);
        } else {
            String remoteIbpPath = (String)configFiles.get("integrationBasicPackageFilePath");
            if (RbsConfigurationHelper.existsAndNotEmpty(remoteIbpPath)) {
                RbsConfigurationReportLoggerFactory.getLogger().logInformation("Configuration files", "Fetching IBP.zip file from FTP.");
                String localIbpFilePath = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? RbsConfigurationReportHelper.dirName + "IntegrationBp.zip" : this.helper.getLocalPath() + "IntegrationBp.zip";
                FileParameters.instance(this.rbsConfiguration).setIntegrationBasicPackageFilePath(localIbpFilePath);
                this.getFileFromFtp(0, remoteIbpPath, localIbpFilePath);
            } else {
                this.updateProgressReportInformation(0, 2, "No Integration Basic Package specified. ", true);
            }
            FileParameters.instance().setIntegrationBasicPackageRemotePath(remoteIbpPath);
        }
        logger.traceReturn(THIS_CLASS, "fetchIntegrationBp()");
    }

    private void fetchSiteBasicFile(Map configFiles) throws MoAccessException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "fetchSiteBasicFile()");
        String siteBasicFilePath = FileParameters.instance().getSiteBasicFilePath();
        if (RbsConfigurationHelper.existsAndNotEmpty(siteBasicFilePath)) {
            this.updateProgressReportInformation(1500, 2, "Site Basic file local - will not contact FTP server", true);
        } else {
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("Configuration files", "Fetching site basic file from FTP.");
            this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_FETCHING_SITE_BASIC_FILE);
            siteBasicFilePath = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? RbsConfigurationReportHelper.dirName + "SiteBasic.xml" : this.helper.getLocalPath() + "SiteBasic.xml";
            FileParameters.instance(this.rbsConfiguration).setSiteBasicFilePath(siteBasicFilePath);
            String remoteSiteBasicPath = (String)configFiles.get("siteBasicFilePath");
            this.getFileFromFtp(1500, remoteSiteBasicPath, siteBasicFilePath);
            FileParameters.instance().setSiteBasicRemotePath(remoteSiteBasicPath);
        }
        logger.traceReturn(THIS_CLASS, "fetchSiteBasicFile()");
    }

    private void fetchSiteEquipmentFile(Map configFiles) throws MoAccessException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "fetchSiteEquipmentFile()");
        String siteEquipFilePath = FileParameters.instance().getSiteEquipmentFilePath();
        if (RbsConfigurationHelper.existsAndNotEmpty(siteEquipFilePath)) {
            this.updateProgressReportInformation(900, 2, "Site Equipment file local - will not contact FTP server", true);
        } else {
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("Configuration files", "Fetching site equipment file from FTP.");
            this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_FETCHING_SITE_EQUIPMENT_FILE);
            siteEquipFilePath = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? RbsConfigurationReportHelper.dirName + "SiteEquipment.xml" : this.helper.getLocalPath() + "SiteEquipment.xml";
            FileParameters.instance(this.rbsConfiguration).setSiteEquipmentFilePath(siteEquipFilePath);
            String remoteSiteEquipPath = (String)configFiles.get("siteEquipmentFilePath");
            this.getFileFromFtp(900, remoteSiteEquipPath, siteEquipFilePath);
            FileParameters.instance(this.rbsConfiguration).setSiteEquipmentRemotePath(remoteSiteEquipPath);
        }
        logger.traceReturn(THIS_CLASS, "fetchSiteEquipmentFile()");
    }

    private void storeInitialSecurityConfigurationFile(Map configFiles) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storeInitialSecurityConfigurationFile()");
        if (Boolean.valueOf(SecurityParameters.instance(this.rbsConfiguration).getActivateSecurity().toString()).booleanValue() || Boolean.valueOf(SecurityParameters.instance(this.rbsConfiguration).getActivateIpSecurity().toString()).booleanValue()) {
            this.updateProgressReportInformation(1900, 3, "Fetching ISCF", true);
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("Configuration files", "Fetching initial security configuration file from FTP.");
            this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_INITIATING_SECURITY_CONFIGURATION);
            String remoteIscfPath = "";
            if (configFiles.containsKey("initialSecurityConfigurationFilePath")) {
                remoteIscfPath = (String)configFiles.get("initialSecurityConfigurationFilePath");
            }
            SecurityParameters.instance().setLocalInitialSecurityConfigurationFile(remoteIscfPath);
            logger.traceDebug(THIS_CLASS, "remoteIscfPath= " + remoteIscfPath);
            this.fetchInitialSecurityConfigurationFile(remoteIscfPath);
        }
        logger.traceReturn(THIS_CLASS, "storeInitialSecurityConfigurationFile()");
    }

    private void fetchInitialSecurityConfigurationFile(String remoteIscfPath) throws RbsConfigurationFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "fetchInitialSecurityConfigurationFile()");
        String localIscfPath = "";
        if (RbsConfigurationHelper.existsAndNotEmpty(remoteIscfPath)) {
            localIscfPath = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? RbsConfigurationReportHelper.dirName + "ISCF.xml" : this.helper.getLocalPath() + "ISCF.xml";
            this.getFileFromFtp(1900, remoteIscfPath, localIscfPath);
            this.updateProgressReportInformation(1900, 5, "Sucessfully fetched ISCF", true);
        } else {
            SecurityParameters.instance(this.rbsConfiguration).setActivateSecurity("false");
            SecurityParameters.instance().setActivateIpSecurity("false");
            this.updateProgressReportInformation(1900, 2, "Not fetching ISCF because of null remote path...", false);
            this.updateProgressReportInformation(2000, 2, "No ISCF - will not install node security", false);
            this.updateProgressReportInformation(2100, 2, "No ISCF - will not install IP security", false);
            this.updateProgressReportInformation(1450, 2, "No ISCF - will not activate IP security", false);
            this.updateProgressReportInformation(1800, 2, "No ISCF - will not configure IP security for O&M", false);
            this.updateProgressReportInformation(2200, 2, "No ISCF - will not activate node security", true);
        }
        SecurityParameters.instance().setLocalInitialSecurityConfigurationFile(localIscfPath);
        logger.traceDebug(THIS_CLASS, "localIscfPath= " + localIscfPath);
        logger.traceReturn(THIS_CLASS, "fetchInitialSecurityConfigurationFile()");
    }

    public void reFetchInitialSecurityContainerFile(int attempt) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "reFetchInitialSecurityContainerFile()");
        this.helper.waitForRetry("Waiting to re-fetch ISCF file...");
        this.updateProgressReportInformation(1900, 3, "Re-fetching Initial Security Configuration File, attempt #" + attempt, true);
        try {
            Map configFiles = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? this.getAndParseSummaryFile(RbsConfigurationReportHelper.dirName + "SummaryFile.xml", "reFetchInitialSecurityContainerFile") : this.getAndParseSummaryFile(this.helper.getLocalPath() + "SummaryFile.xml", "reFetchInitialSecurityContainerFile");
            String remoteIscfPath = (String)configFiles.get("initialSecurityConfigurationFilePath");
            this.fetchInitialSecurityConfigurationFile(remoteIscfPath);
        }
        catch (MoAccessException e) {
            String errorMsg = "Generic fault when storing attributes persitently.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Generic fault", "Generic fault when storing attributes persitently.");
            throw new RbsConfigurationFailedException("Generic fault when storing attributes persitently.");
        }
        logger.traceReturn(THIS_CLASS, "reFetchInitialSecurityContainerFile()");
    }

    private void storeLicenseKeyFilePath(Map configFiles) throws MoAccessException {
        FileParameters fp = FileParameters.instance(this.rbsConfiguration);
        String lkfPath = fp.getLicenseKeyFilePath();
        if (RbsConfigurationHelper.existsAndNotEmpty(lkfPath)) {
            if ("DoNoTuSeVaLuEfRoMsUmMaRy".equals(lkfPath)) {
                fp.setLicenseKeyFilePath("");
                String infoMsg = "No License Key File specified.";
                ProgressReportHandler.getInstance().updateProgressReportInformation(800, 2, "No License Key File specified.", true);
                logger.traceGeneral(THIS_CLASS, "No License Key File specified.");
            } else {
                logger.traceGeneral(THIS_CLASS, "Using local LKF: " + lkfPath);
            }
        } else {
            String remoteLkfPath = (String)configFiles.get("licensingKeyFilePath");
            if (RbsConfigurationHelper.existsAndNotEmpty(remoteLkfPath)) {
                fp.setLicenseKeyRemotePath(remoteLkfPath);
                logger.traceGeneral(THIS_CLASS, "Using remote LKF: " + remoteLkfPath);
            } else {
                String infoMsg = "No License Key File specified.";
                fp.setLicenseKeyRemotePath("");
                ProgressReportHandler.getInstance().updateProgressReportInformation(800, 2, "No License Key File specified.", true);
                logger.traceGeneral(THIS_CLASS, "No License Key File specified.");
            }
        }
    }

    private void storeUpgradeFilePath(Map configFiles) throws MoAccessException {
        UpgradeParameters upParam = UpgradeParameters.instance(this.rbsConfiguration);
        String upPath = upParam.getUpgradePackageFilePath();
        if (RbsConfigurationHelper.existsAndNotEmpty(upPath)) {
            if ("DoNoTuSeVaLuEfRoMsUmMaRy".equals(upPath)) {
                upParam.setUpgradePackageFilePath("");
                String infoMsg = "No upgrade package specified.";
                ProgressReportHandler.getInstance().updateProgressReportInformation(600, 2, "No upgrade package specified.", true);
                logger.traceGeneral(THIS_CLASS, "No upgrade package specified.");
            } else {
                logger.traceGeneral(THIS_CLASS, "Using local upgrade package: " + upPath);
            }
        } else {
            String remoteUpPath = (String)configFiles.get("upgradePackageFilePath");
            if (RbsConfigurationHelper.existsAndNotEmpty(remoteUpPath)) {
                upParam.setUpgradePackageRemotePath(remoteUpPath);
                logger.traceGeneral(THIS_CLASS, "Using remote UP: " + remoteUpPath);
            } else {
                upParam.setUpgradePackageRemotePath("");
                String infoMsg = "No upgrade package specified.";
                ProgressReportHandler.getInstance().updateProgressReportInformation(600, 2, "No upgrade package specified.", true);
                logger.traceGeneral(THIS_CLASS, "No upgrade package specified.");
            }
        }
    }

    private boolean checkLocalFilePaths() {
        logger.traceEnter(THIS_CLASS, "checkLocalFilePaths()");
        boolean allLocalFilesExist = this.shouldFilesBeFetchedFromSmrs();
        if (allLocalFilesExist) {
            this.updateProgressReportInformation(1500, 2, "Site Basic file local - will not contact SMRS server", false);
            this.updateProgressReportInformation(900, 2, "Site Equipment file local - will not contact SMRS server", false);
            this.updateProgressReportInformation(500, 2, "Upgrade Package local - will not contact SMRS server", false);
            this.updateProgressReportInformation(300, 2, "All configuration files are local - no need to fetch Summary file from SMRS server", false);
            this.updateProgressReportInformation(1900, 2, "All configuration files are local - no need to fetch ISCF file from SMRS server", false);
            this.updateProgressReportInformation(2000, 2, "All configuration files are local - no security will be installed", false);
            this.updateProgressReportInformation(2200, 2, "All configuration files are local - security will not be activated", false);
            this.updateProgressReportInformation(1450, 2, "All configuration files are local - IPsec will not be activated.", true);
            this.updateProgressReportInformation(1850, 2, "All configuration files are local - IPsec for O&M will not be configured.", true);
            this.updateProgressReportInformation(400, 2, "All configuration files are local - no need to read Summary file", true);
        }
        logger.traceReturn(THIS_CLASS, "checkLocalFilePaths()");
        return allLocalFilesExist;
    }

    private boolean shouldFilesBeFetchedFromSmrs() {
        String lkfPath = FileParameters.instance(this.rbsConfiguration).getLicenseKeyFilePath();
        String upPath = UpgradeParameters.instance(this.rbsConfiguration).getUpgradePackageFilePath();
        boolean localSiteBasic = RbsConfigurationHelper.existsAndNotEmpty(FileParameters.instance(this.rbsConfiguration).getSiteBasicFilePath());
        boolean localSiteEquipment = RbsConfigurationHelper.existsAndNotEmpty(FileParameters.instance(this.rbsConfiguration).getSiteEquipmentFilePath());
        boolean localLicenseKeyFile = RbsConfigurationHelper.existsAndNotEmpty(lkfPath) || "DoNoTuSeVaLuEfRoMsUmMaRy".equals(lkfPath);
        boolean localUpgradePackage = RbsConfigurationHelper.existsAndNotEmpty(upPath) || "DoNoTuSeVaLuEfRoMsUmMaRy".equals(upPath);
        boolean doNotUseSecurity = Boolean.valueOf(SecurityParameters.instance().getActivateSecurity().toString()) == false;
        boolean doNotUseIpSecurity = Boolean.valueOf(SecurityParameters.instance().getActivateIpSecurity().toString()) == false;
        return localSiteBasic && localSiteEquipment && localLicenseKeyFile && localUpgradePackage && doNotUseSecurity && doNotUseIpSecurity;
    }

    private boolean isNodeSelfConfiguration() {
        boolean result2 = false;
        String nodeSelfConfiguration = FileParameters.instance().getNodeSelfConfigurationMode();
        if (nodeSelfConfiguration != null) {
            result2 = nodeSelfConfiguration.equalsIgnoreCase("InitialSoftwareInstallationPerformed");
        }
        return result2;
    }

    public boolean getFileFromFtp(int integrationStep, String remoteFilePath, String localFilePath) throws RbsConfigurationFailedException {
        return this.getFileFromFtp(false, integrationStep, remoteFilePath, localFilePath);
    }

    public boolean getFileFromFtp(boolean loopOnce, int integrationStep, String remoteFilePath, String localFilePath) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getFileFromFtp()");
        boolean success = false;
        String localRemoteFilePath = remoteFilePath;
        FtpInfo localFtpInfo = this.getFtpInfo();
        logger.traceDebug(THIS_CLASS, "getFileFromFtp() address = " + localFtpInfo.getServerAddress() + ", remoteFilePath = " + localRemoteFilePath + ", localFilePath = " + localFilePath);
        this.updateProgressReportInformation(integrationStep, 3, "Fetching file, \"" + localRemoteFilePath + "\", from FTP server: " + localFtpInfo.getServerAddress(), true);
        while (true) {
            String errorMsg;
            localFtpInfo = this.getFtpInfo();
            this.checkFtpAttributes(localFtpInfo);
            try {
                RbsConfigurationReportLoggerFactory.getLogger().logAttributes("Downloading File", new String[]{"Local path", "Remote path", "Host"}, new Object[]{localFilePath, localRemoteFilePath, localFtpInfo.getServerAddress()});
                ++this.counter;
                this.ftpFactory.getFTPClientWrapper().get(localFtpInfo.getServerAddress(), localFtpInfo.getUsername(), localFtpInfo.getPassword(), localFilePath, localRemoteFilePath);
                this.updateProgressReportInformation(integrationStep, 5, "Finished fetching file, \"" + localRemoteFilePath + "\", from FTP server: " + localFtpInfo.getServerAddress(), true);
                RbsConfigurationReportLoggerFactory.getLogger().logInformation("Configuration files", "Finished fetching file from FTP server");
                success = true;
                break;
            }
            catch (FTPException ftpe) {
                if (this.counter >= 3) {
                    errorMsg = "FTP error - failed to retrieve \"" + localRemoteFilePath + "\" due to error: " + this.ftpFaultNumberTranslater.translateFtpFaultNumber(ftpe);
                    this.updateProgressReportInformation(integrationStep, 4, errorMsg, true);
                    if (localFtpInfo instanceof SmrsInfo) {
                        ProgressReportHandler.getInstance().addWrongUserAndOrPassword(errorMsg, (SmrsInfo)localFtpInfo);
                    }
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SMRS_CONNECTION_FAULT, "FTP-error", errorMsg);
                    logger.traceDebug(THIS_CLASS, errorMsg);
                }
            }
            catch (Exception e) {
                errorMsg = ExceptionHelper.appendReason((String)("FTP error - failed to retrieve " + StringHelper.doubleQuote((String)localRemoteFilePath)), (Throwable)e);
                this.updateProgressReportInformation(integrationStep, 4, errorMsg, true);
                if (localFtpInfo instanceof SmrsInfo) {
                    ProgressReportHandler.getInstance().addWrongUserAndOrPassword(errorMsg, (SmrsInfo)localFtpInfo);
                }
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SMRS_CONNECTION_FAULT, "FTP-error", errorMsg);
                logger.traceDebug(THIS_CLASS, errorMsg);
            }
            if (loopOnce) break;
            this.helper.waitForRetry("Remote: " + localRemoteFilePath + ", Local: " + localFilePath + ".");
        }
        logger.traceReturn(THIS_CLASS, "getFileFromFtp()");
        return success;
    }

    private void checkFtpAttributes(FtpInfo ftpInfo) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "readPersistentFtpAttributes()");
        logger.traceDebug(THIS_CLASS, "FtpAddress: " + ftpInfo.getServerAddress() + "FTPSummaryFilePath: " + ftpInfo.getSummaryFilePath());
        if (!RbsConfigurationHelper.existsAndNotEmpty(ftpInfo.getServerAddress()) || !RbsConfigurationHelper.existsAndNotEmpty(ftpInfo.getSummaryFilePath())) {
            String errorMsg = "Persistantly stored attributes needed to contact the FTP server could not be retrieved.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "RbsConfiguration failure", "Persistantly stored attributes needed to contact the FTP server could not be retrieved.");
            throw new RbsConfigurationFailedException("Persistantly stored attributes needed to contact the FTP server could not be retrieved.");
        }
        logger.traceReturn(THIS_CLASS, "readPersistentFtpAttributes()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeConfigurationReport(String userId, String userPassword, String smrsAddress, String reportFilePath) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "storeConfigurationReport()");
        String filepath = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? RbsConfigurationReportHelper.dirName + "tempConfReport.log" : this.helper.getLogDirPath() + "tempConfReport.log";
        try {
            String failureSlogan = "Store configuration report failure";
            String configReport = "";
            try {
                configReport = (String)this.rbsConfiguration.getAttribute("configurationReport");
            }
            catch (MoAccessException mae) {
                String msg = "Could not read the attribute configurationReport";
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Store configuration report failure", "Could not read the attribute configurationReport");
                logger.traceError(THIS_CLASS, "Could not read the attribute configurationReport", (Throwable)mae);
                throw new RbsConfigurationFailedException("Could not read the attribute configurationReport");
            }
            String username = userId;
            String password = userPassword;
            String ipAddress = smrsAddress;
            ipAddress = this.checkAndGetIpAddress(reportFilePath, "Store configuration report failure", username, password, ipAddress);
            this.saveConfigurationReport(filepath, "Store configuration report failure", configReport);
            this.uploadConfigurationReportFile(reportFilePath, filepath, "Store configuration report failure", username, password, ipAddress);
        }
        finally {
            this.helper.removeFile(filepath);
        }
        logger.traceReturn(THIS_CLASS, "storeConfigurationReport()");
    }

    private void uploadConfigurationReportFile(String reportFilePath, String filepath, String failureSlogan, String username, String password, String ipAddress) throws RbsConfigurationFailedException {
        try {
            this.genericMaoContext.getFTPClientWrapperFactory().getFTPClientWrapper().put(ipAddress, username, password, filepath, reportFilePath);
        }
        catch (FTPException ftpe) {
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OSS_CONNECTION_FAULT, failureSlogan, "FTP-Error when sending configuration report: " + this.ftpFaultNumberTranslater.translateFtpFaultNumber(ftpe) + " Aborting.");
            throw new RbsConfigurationFailedException("action StoreConfigurationReport failed due to FTP exception!");
        }
        catch (Exception exc) {
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OSS_CONNECTION_FAULT, failureSlogan, "FTP error when sending the configuration report. Aborting.");
            String errorMsg = "action StoreConfigurationReport failed due to FTP exception!";
            throw new RbsConfigurationFailedException("action StoreConfigurationReport failed due to FTP exception!");
        }
    }

    private void saveConfigurationReport(String filepath, String failureSlogan, String configReport) throws RbsConfigurationFailedException {
        try {
            this.helper.saveTextFile(configReport, filepath);
        }
        catch (IOException ioe) {
            String msg = "Could not save configuration file to disk, aborting.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, failureSlogan, "Could not save configuration file to disk, aborting.");
            logger.traceError(THIS_CLASS, "Could not store configReport to file: " + filepath, (Throwable)ioe);
            throw new RbsConfigurationFailedException("Could not save configuration file to disk, aborting.");
        }
    }

    private String checkAndGetIpAddress(String reportFilePath, String failureSlogan, String username, String password, String inputIpAddress) throws RbsConfigurationFailedException {
        SmrsInfo smrsInfo;
        String ipAddress = inputIpAddress;
        if (!(RbsConfigurationHelper.existsAndNotEmpty(ipAddress) || RbsConfigurationHelper.existsAndNotEmpty(ipAddress = (smrsInfo = this.getSmrsInfo()).getSmrsServer()) && username != null && password != null && RbsConfigurationHelper.existsAndNotEmpty(reportFilePath))) {
            String msg = "Could not store the Configuration Report due to invalid FTP-parameters.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OSS_CONNECTION_FAULT, failureSlogan, "Could not store the Configuration Report due to invalid FTP-parameters.");
            throw new RbsConfigurationFailedException("Could not store the Configuration Report due to invalid FTP-parameters.");
        }
        return ipAddress;
    }

    public String getHelperName() {
        return this.getClass().getName();
    }

    private void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        if (integrationStepNumber >= 0) {
            ProgressReportHandler.getInstance().updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport);
        }
    }
}

