/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ResourceForUnlockHelperMoCleanUp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;

public final class RbsConfigurationUnlockHelper {
    private static final Class THIS_CLASS = RbsConfigurationUnlockHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static RbsConfigurationUnlockHelper instance;
    private final List createdMos = new LinkedList();
    private final List createdCells = new LinkedList();
    private final List createdMmes = new LinkedList();

    private RbsConfigurationUnlockHelper() {
        logger.traceEnter(THIS_CLASS, "UnlockHelper()");
        logger.traceReturn(THIS_CLASS, "UnlockHelper()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCreatedMos() {
        logger.traceEnter(THIS_CLASS, "clearAllCreatedMos()");
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            this.createdMos.clear();
        }
        logger.traceReturn(THIS_CLASS, "clearAllCreatedMos()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCreatedCells() {
        logger.traceEnter(THIS_CLASS, "clearAllCreatedCells()");
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            this.createdCells.clear();
        }
        logger.traceReturn(THIS_CLASS, "clearAllCreatedCells()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCreatedMmes() {
        logger.traceEnter(THIS_CLASS, "clearAllCreatedMmes()");
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            this.createdMmes.clear();
        }
        logger.traceReturn(THIS_CLASS, "clearAllCreatedMmes()");
    }

    public List getCreatedMos() {
        return this.createdMos;
    }

    public List getCreatedCells() {
        return this.createdCells;
    }

    public List getCreatedMmes() {
        return this.createdMmes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RbsConfigurationUnlockHelper getInstance() {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            if (instance == null) {
                instance = new RbsConfigurationUnlockHelper();
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCreatedMo(ManagedObject managedObject, Coordinator coordinator) throws InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "registerCreatedMo(mo, coordinator) " + managedObject.getLocalDistinguishedName());
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            this.createdMos.add(managedObject);
        }
        if (coordinator != null) {
            coordinator.registerResource((Resource)new ResourceForUnlockHelperMoCleanUp(managedObject));
        }
        logger.traceReturn(THIS_CLASS, "registerCreatedMo(mo, coordinator)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deRegisterCreatedMo(ManagedObject managedObject) {
        logger.traceEnter(THIS_CLASS, "deRegisterCreatedMo() ");
        if (managedObject != null) {
            logger.traceDebug(THIS_CLASS, "deRegisterCreatedMo() " + managedObject.getLocalDistinguishedName());
            Class clazz = THIS_CLASS;
            synchronized (clazz) {
                boolean removeResult = this.createdMos.remove(managedObject);
                logger.traceDebug(THIS_CLASS, "Removal of MO result:" + removeResult);
            }
        }
        logger.traceReturn(THIS_CLASS, "deRegisterCreatedMo()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCreatedCell(ManagedObject managedObject) {
        logger.traceEnter(THIS_CLASS, "registerCreatedCell() " + managedObject.getLocalDistinguishedName());
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            this.createdCells.add(managedObject);
        }
        logger.traceReturn(THIS_CLASS, "registerCreatedCell()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCreatedMme(ManagedObject managedObject) {
        logger.traceEnter(THIS_CLASS, "registerCreatedMme() " + managedObject.getLocalDistinguishedName());
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            this.createdMmes.add(managedObject);
        }
        logger.traceReturn(THIS_CLASS, "registerCreatedMme()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAllCreatedMos(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "unlockAllCreatedMos()");
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            Iterator moIterator = this.createdMos.iterator();
            while (moIterator.hasNext()) {
                ManagedObject managedObject = (ManagedObject)moIterator.next();
                try {
                    managedObject.setAttribute("administrativeState", (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
                    RbsConfigurationReportLoggerFactory.getLogger().logAttribute(managedObject.getRelativeDistinguishedName(), "administrativeState", "UNLOCKED");
                }
                catch (NoSuchAttributeException nsae) {
                }
                catch (MoAccessException mae) {
                    RbsConfigurationReportLoggerFactory.getLogger().logFailure("Failed to unlock", "Could not unlock the MO : " + managedObject.getLocalDistinguishedName() + " Please unlock this manually later! Reason: " + (Object)((Object)mae) + " " + RbsConfigurationFailedException.convertVariablesMessage(mae.getVariablesAsString()));
                }
            }
            this.clearAllCreatedMos();
        }
        logger.traceReturn(THIS_CLASS, "unlockAllCreatedMos()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAllCreatedCells() {
        logger.traceEnter(THIS_CLASS, "unlockAllCreatedCells()");
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            Iterator moIterator = this.createdCells.iterator();
            while (moIterator.hasNext()) {
                ManagedObject managedObject = (ManagedObject)moIterator.next();
                try {
                    TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
                    Control control = null;
                    control = transFact.create(0);
                    Coordinator coordinator = control.getCoordinator();
                    try {
                        managedObject.setAttribute("administrativeState", (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
                    }
                    catch (MoAccessException mae) {
                        RbsConfigurationReportLoggerFactory.getLogger().logFailure("Failed to unlock", "Could not unlock the cell : " + managedObject.getLocalDistinguishedName() + " Please unlock this manually later!");
                        control.getTerminator().rollback();
                        continue;
                    }
                    control.getTerminator().commit();
                }
                catch (TransactionRolledBackException e) {
                    logger.traceDebugStackTrace(THIS_CLASS, (Throwable)e);
                    continue;
                }
                catch (InactiveTransactionException e) {
                    logger.traceDebugStackTrace(THIS_CLASS, (Throwable)e);
                    continue;
                }
                RbsConfigurationReportLoggerFactory.getLogger().logAttribute(managedObject.getRelativeDistinguishedName(), "administrativeState", "UNLOCKED");
            }
            this.clearAllCreatedCells();
        }
        logger.traceReturn(THIS_CLASS, "unlockAllCreatedCells()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAllCreatedMmes() {
        logger.traceEnter(THIS_CLASS, "unlockAllCreatedMmes()");
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            Iterator moIterator = this.createdMmes.iterator();
            while (moIterator.hasNext()) {
                ManagedObject managedObject = (ManagedObject)moIterator.next();
                try {
                    TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
                    Control control = null;
                    control = transFact.create(0);
                    Coordinator coordinator = control.getCoordinator();
                    try {
                        managedObject.setAttribute("administrativeState", (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
                    }
                    catch (MoAccessException mae) {
                        RbsConfigurationReportLoggerFactory.getLogger().logFailure("Failed to unlock", "Could not unlock the MME : " + managedObject.getLocalDistinguishedName() + " Please unlock this manually later!");
                        control.getTerminator().rollback();
                        continue;
                    }
                    control.getTerminator().commit();
                }
                catch (TransactionRolledBackException e) {
                    logger.traceDebugStackTrace(THIS_CLASS, (Throwable)e);
                    continue;
                }
                catch (InactiveTransactionException e) {
                    logger.traceDebugStackTrace(THIS_CLASS, (Throwable)e);
                    continue;
                }
                RbsConfigurationReportLoggerFactory.getLogger().logAttribute(managedObject.getRelativeDistinguishedName(), "administrativeState", "UNLOCKED");
            }
            this.clearAllCreatedMmes();
        }
        logger.traceReturn(THIS_CLASS, "unlockAllCreatedMmes()");
    }
}

