/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.io.IOException;
import java.security.GeneralSecurityException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.RbsConfigurationIsiHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.SecurityHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.RestartNodeTp;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivation;

public class ResetHelper {
    private static final Class THIS_CLASS = ResetHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RbsConfigurationMao rbsConfigurationMao;

    public ResetHelper(RbsConfigurationMao aRbsConfigurationMao) {
        this.rbsConfigurationMao = aRbsConfigurationMao;
    }

    public void resetSecurityActivationAndRestartNode(String failureSlogan, ExpressSecurityActivation esa, Object esaLock) {
        logger.traceEnter(THIS_CLASS, "resetSecurityActivationAndRestartNode()");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            logger.traceDebug(THIS_CLASS, "Interrupted while sleeping: " + e.getMessage());
        }
        if (SecurityParameters.instance(this.rbsConfigurationMao).getActivateIpSecurityAsBoolean()) {
            SecurityHelper securityHelper = new SecurityHelper();
            securityHelper.resetSecurityActivation(failureSlogan, this.rbsConfigurationMao, esa, esaLock);
        }
        if (FileParameters.instance(this.rbsConfigurationMao).getNodeSelfConfigurationMode().equalsIgnoreCase("InitialSoftwareInstallationPerformed")) {
            RbsConfigurationIsiHelper isiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationIsiHelper.class);
            try {
                String cvName = isiHelper.getNlRollBackCv("/c/systemfiles/lte/autointegration/Nlh.xml");
                FileHelper.writeToFile((String)RbsConfigurationDefinitions.CV_POINTER, (String)cvName, (boolean)false);
                logger.traceDebug(THIS_CLASS, "Set startable cv to : " + cvName);
            }
            catch (IOException e) {
                logger.traceDebug(THIS_CLASS, "Fail to set startable cv due to: " + e.getMessage());
                FileHelper.writeToFile((String)RbsConfigurationDefinitions.CV_POINTER, (String)"basic_cv", (boolean)false);
                logger.traceDebug(THIS_CLASS, "Set startable cv to default: basic_cv");
            }
            catch (GeneralSecurityException secException) {
                logger.traceDebug(THIS_CLASS, "Fail to decrypt nlh.xml to: " + secException.getMessage());
            }
        }
        TransactionHandler.runWithLoopWithoutException(new RestartNodeTp(this.rbsConfigurationMao, failureSlogan, "Configuration failed!"));
        logger.traceReturn(THIS_CLASS, "resetSecurityActivationAndRestartNode()");
    }
}

