/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.io.File;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.AbstractRbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.CryptionHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.SensitiveDataStore;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.StringEncryptor;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class SensitiveDataHelper
extends AbstractRbsConfigurationHelper {
    public static final String SMRS_USERNAME = "smrsUsername";
    public static final String SMRS_PASSWORD = "smrsPassword";
    public static final String RBS_INTEGRATION_CODE = "rbsIntegrationCode";
    private static final Class THIS_CLASS = SensitiveDataHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String filePath = "";
    private SensitiveDataStore sensitiveDataStore = null;
    protected String smrsUserName = "";
    protected String smrsPassword = "";
    protected String rbsIntegrationCode = "";

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String inputFilePath) throws RbsConfigurationFailedException {
        this.filePath = inputFilePath;
        File inputFile = new File(this.filePath);
        File outputDir = inputFile.getParentFile();
        if (inputFile.exists()) {
            try {
                this.sensitiveDataStore = SensitiveDataStore.restoreFromDisc(inputFilePath);
                this.smrsUserName = this.retrieveSmrsUserName();
                this.smrsPassword = this.retrieveSmrsPassword();
                this.rbsIntegrationCode = this.retrieveRbsIntegrationCode();
            }
            catch (RbsConfigurationFailedException e) {
                logger.traceAbnormal(THIS_CLASS, "Error: /c/configuration/rbs_auto_integration_data.dat is faulty");
                this.sensitiveDataStore = new SensitiveDataStore();
            }
        } else {
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                throw new RbsConfigurationFailedException("Sensitive data storage failure", "Failed to create directory: " + outputDir);
            }
            this.sensitiveDataStore = new SensitiveDataStore();
        }
    }

    public void storeSmrsUserName(String inputSmrsUserName, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storeSmrsUserName()");
        if (inputSmrsUserName == null) {
            throw new RbsConfigurationFailedException("Sensitive data storage failure", "Specified SMRS user name is null");
        }
        this.smrsUserName = inputSmrsUserName;
        StringEncryptor stringEncryptor = new StringEncryptor();
        CryptionHolder userNameCryptionHolder = stringEncryptor.encrypt(inputSmrsUserName);
        String dataBaseString = CryptionHolder.convertToString(userNameCryptionHolder.getDatabaseCryption());
        if (coordinator == null) {
            this.rbsConfiguration.storePersistently(SMRS_USERNAME, dataBaseString);
        } else {
            this.rbsConfiguration.storePersistently(SMRS_USERNAME, dataBaseString, coordinator);
        }
        String fileString = CryptionHolder.convertToString(userNameCryptionHolder.getFileCryption());
        if (this.sensitiveDataStore != null) {
            this.sensitiveDataStore.setSmrsUserName(fileString);
            this.sensitiveDataStore.storeToDisc(this.filePath);
        }
        logger.traceReturn(THIS_CLASS, "storeSmrsUserName()");
    }

    public String retrieveSmrsUserName() {
        String result2;
        logger.traceEnter(THIS_CLASS, "retrieveSmrsUserName()");
        if (this.smrsUserName == null || this.smrsUserName.equalsIgnoreCase("")) {
            String rawDataBaseUserName = (String)this.rbsConfiguration.retrievePersistently(SMRS_USERNAME);
            if (rawDataBaseUserName == null || rawDataBaseUserName.equalsIgnoreCase("")) {
                result2 = "";
            } else {
                long[] dataBaseUserName = CryptionHolder.convertToArray(rawDataBaseUserName);
                String rawFileUserName = this.sensitiveDataStore.getSmrsUserName();
                long[] fileUserName = CryptionHolder.convertToArray(rawFileUserName);
                CryptionHolder cryptionHolder = new CryptionHolder(fileUserName, dataBaseUserName);
                StringEncryptor stringEncryptor = new StringEncryptor();
                result2 = stringEncryptor.decrypt(cryptionHolder);
            }
        } else {
            result2 = this.smrsUserName;
        }
        logger.traceReturn(THIS_CLASS, "retrieveSmrsUserName()");
        return result2;
    }

    public void removeSmrsUserName(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "removeSmrsUserName()");
        this.smrsUserName = "";
        this.rbsConfiguration.removeAdditionalAttribute(SMRS_USERNAME, coordinator);
        if (this.sensitiveDataStore != null) {
            this.sensitiveDataStore.setSmrsUserName("");
            this.sensitiveDataStore.storeToDisc(this.filePath);
        }
        logger.traceReturn(THIS_CLASS, "removeSmrsUserName()");
    }

    public void storeSmrsPassword(String inputSmrsPassword, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storeSmrsPassword()");
        if (inputSmrsPassword == null) {
            throw new RbsConfigurationFailedException("Sensitive data storage failure", "Specified SMRS password is null");
        }
        this.smrsPassword = inputSmrsPassword;
        StringEncryptor stringEncryptor = new StringEncryptor();
        CryptionHolder pwdCryptionHolder = stringEncryptor.encrypt(inputSmrsPassword);
        String dataBaseString = CryptionHolder.convertToString(pwdCryptionHolder.getDatabaseCryption());
        if (coordinator == null) {
            this.rbsConfiguration.storePersistently(SMRS_PASSWORD, dataBaseString);
        } else {
            this.rbsConfiguration.storePersistently(SMRS_PASSWORD, dataBaseString, coordinator);
        }
        String fileString = CryptionHolder.convertToString(pwdCryptionHolder.getFileCryption());
        if (this.sensitiveDataStore != null) {
            this.sensitiveDataStore.setSmrsPassword(fileString);
            this.sensitiveDataStore.storeToDisc(this.filePath);
        }
        logger.traceReturn(THIS_CLASS, "storeSmrsPassword()");
    }

    public String retrieveSmrsPassword() {
        String result2;
        logger.traceEnter(THIS_CLASS, "retrieveSmrsPassword()");
        if (this.smrsPassword == null || this.smrsPassword.equalsIgnoreCase("")) {
            String rawDataBasePassword = (String)this.rbsConfiguration.retrievePersistently(SMRS_PASSWORD);
            if (rawDataBasePassword == null || rawDataBasePassword.equalsIgnoreCase("")) {
                result2 = "";
            } else {
                long[] dataBasePassword = CryptionHolder.convertToArray(rawDataBasePassword);
                String rawFilePassword = this.sensitiveDataStore.getSmrsPassword();
                long[] filePassword = CryptionHolder.convertToArray(rawFilePassword);
                CryptionHolder cryptionHolder = new CryptionHolder(filePassword, dataBasePassword);
                StringEncryptor stringEncryptor = new StringEncryptor();
                result2 = stringEncryptor.decrypt(cryptionHolder);
            }
        } else {
            result2 = this.smrsPassword;
        }
        logger.traceReturn(THIS_CLASS, "retrieveSmrsPassword()");
        return result2;
    }

    public void removeSmrsPassword(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "removeSmrsPassword()");
        this.smrsPassword = "";
        this.rbsConfiguration.removeAdditionalAttribute(SMRS_PASSWORD, coordinator);
        if (this.sensitiveDataStore != null) {
            this.sensitiveDataStore.setSmrsPassword("");
            this.sensitiveDataStore.storeToDisc(this.filePath);
        }
        logger.traceReturn(THIS_CLASS, "removeSmrsPassword()");
    }

    public void storeRbsIntegrationCode(String inputRbsIntegrationCode, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storeRbsIntegrationCode()");
        if (inputRbsIntegrationCode == null) {
            throw new RbsConfigurationFailedException("Sensitive data storage failure", "Specified RBS integration code is null");
        }
        this.rbsIntegrationCode = inputRbsIntegrationCode;
        StringEncryptor stringEncryptor = new StringEncryptor();
        CryptionHolder ricCryptionHolder = stringEncryptor.encrypt(inputRbsIntegrationCode);
        String dataBaseString = CryptionHolder.convertToString(ricCryptionHolder.getDatabaseCryption());
        if (coordinator == null) {
            this.rbsConfiguration.storePersistently(RBS_INTEGRATION_CODE, dataBaseString);
        } else {
            this.rbsConfiguration.storePersistently(RBS_INTEGRATION_CODE, dataBaseString, coordinator);
        }
        String fileString = CryptionHolder.convertToString(ricCryptionHolder.getFileCryption());
        this.sensitiveDataStore.setRbsIntegrationCode(fileString);
        this.sensitiveDataStore.storeToDisc(this.filePath);
        logger.traceReturn(THIS_CLASS, "storeRbsIntegrationCode()");
    }

    public String retrieveRbsIntegrationCode() {
        String result2;
        logger.traceEnter(THIS_CLASS, "retrieveRbsIntegrationCode()");
        if (this.rbsIntegrationCode == null || this.rbsIntegrationCode.equalsIgnoreCase("")) {
            String rawDataBaseRic = (String)this.rbsConfiguration.retrievePersistently(RBS_INTEGRATION_CODE);
            if (rawDataBaseRic == null || rawDataBaseRic.equalsIgnoreCase("")) {
                result2 = "";
            } else {
                long[] dataBaseRic = CryptionHolder.convertToArray(rawDataBaseRic);
                String rawFileRic = this.sensitiveDataStore.getRbsIntegrationCode();
                long[] fileRic = CryptionHolder.convertToArray(rawFileRic);
                CryptionHolder cryptionHolder = new CryptionHolder(fileRic, dataBaseRic);
                StringEncryptor stringEncryptor = new StringEncryptor();
                result2 = stringEncryptor.decrypt(cryptionHolder);
            }
        } else {
            result2 = this.rbsIntegrationCode;
        }
        logger.traceReturn(THIS_CLASS, "retrieveRbsIntegrationCode()");
        return result2;
    }

    public void removeRbsIntegrationCode(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "removeRbsIntegrationCode()");
        this.rbsIntegrationCode = "";
        this.rbsConfiguration.removeAdditionalAttribute(RBS_INTEGRATION_CODE, coordinator);
        if (this.sensitiveDataStore != null) {
            this.sensitiveDataStore.setRbsIntegrationCode("");
            this.sensitiveDataStore.storeToDisc(this.filePath);
        }
        logger.traceReturn(THIS_CLASS, "removeRbsIntegrationCode()");
    }

    public String getHelperName() {
        return this.getClass().getName();
    }

    public void clearSensitiveData(Coordinator coordinator) throws MoAccessException {
        this.storeSmrsUserName("", coordinator);
        this.storeSmrsPassword("", coordinator);
        this.storeRbsIntegrationCode("", coordinator);
    }
}

