/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.cat.common.StringHelper;

public class UpgradePackageHelper {
    private static final int VALUE_COLUMN_INDEX = 50;
    private static final char INDENT_CHAR = ' ';

    private UpgradePackageHelper() {
    }

    public static String getUpgradePackageInfo(UpgradePackageMo upgradePackageMo, Coordinator coordinator) throws MoAccessException {
        int defaultStringWidth = 100;
        String separatorString = StringHelper.createFilledString((char)'=', (int)100);
        StringBuffer result2 = new StringBuffer(5000);
        String ldn = upgradePackageMo.getLocalDistinguishedName();
        String headeIndent = StringHelper.createFilledString((char)' ', (int)((100 - ldn.length()) / 2));
        result2.append(separatorString);
        result2.append('\n');
        result2.append(headeIndent);
        result2.append(ldn);
        result2.append('\n');
        result2.append(separatorString);
        result2.append('\n');
        result2.append(UpgradePackageHelper.createLineString("UpgradePackageId", upgradePackageMo.getUpgradePackageId(coordinator)));
        result2.append(UpgradePackageHelper.createLineString("actionResult", UpgradePackageHelper.getStructArrayAsString(upgradePackageMo.getActionResult(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("actualTypeOfUP", Integer.toString(upgradePackageMo.getActualTypeOfUP(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("administrativeData", UpgradePackageHelper.getStructAsString(upgradePackageMo.getAdministrativeData(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("basedOnUpgradePackages", UpgradePackageHelper.getStructArrayAsString(upgradePackageMo.getBasedOnUpgradePackages(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("confirmationDeadline", upgradePackageMo.getConfirmationDeadline(coordinator)));
        result2.append(UpgradePackageHelper.createLineString("cppUpVersion", UpgradePackageHelper.getStructAsString(upgradePackageMo.getCppUpVersion(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("deletePreventingCVs", UpgradePackageHelper.getStringArrayAsString(upgradePackageMo.getDeletePreventingCVs(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("ftpServerIpAddress", upgradePackageMo.getFtpServerIpAddress(coordinator)));
        result2.append(UpgradePackageHelper.createLineString("isDeletable", Boolean.toString(upgradePackageMo.getIsDeletable(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("loadModuleList", UpgradePackageHelper.getLoadModuleListAsString(upgradePackageMo.getLoadModuleList(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("otherReferringCVs", UpgradePackageHelper.getStringArrayAsString(upgradePackageMo.getOtherReferringCVs(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("progressCount", Integer.toString(upgradePackageMo.getProgressCount(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("progressHeader", Integer.toString(upgradePackageMo.getProgressHeader(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("progressHeaderAddInfo", UpgradePackageHelper.getStringArrayAsString(upgradePackageMo.getProgressHeaderAddInfo(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("progressTotal", Integer.toString(upgradePackageMo.getProgressTotal(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("requestedTypeOfUP", Integer.toString(upgradePackageMo.getRequestedTypeOfUP(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("state", Integer.toString(upgradePackageMo.getState(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("typeOfUP", Integer.toString(upgradePackageMo.getTypeOfUP(coordinator))));
        result2.append(UpgradePackageHelper.createLineString("upCompatibilityIndex", upgradePackageMo.getUpCompatibilityIndex(coordinator)));
        result2.append(UpgradePackageHelper.createLineString("upFilePathOnFtpServer", upgradePackageMo.getUpFilePathOnFtpServer(coordinator)));
        result2.append(UpgradePackageHelper.createLineString("upgradeControlFilePath", upgradePackageMo.getUpgradeControlFilePath(coordinator)));
        result2.append(UpgradePackageHelper.createLineString("upgradePackageDocumentId", upgradePackageMo.getUpgradePackageDocumentId(coordinator)));
        result2.append(UpgradePackageHelper.createLineString("user", upgradePackageMo.getUser(coordinator)));
        result2.append(UpgradePackageHelper.createLineString("userLabel", upgradePackageMo.getUserLabel(coordinator)));
        result2.append(separatorString);
        return result2.toString();
    }

    private static Object getLoadModuleListAsString(ManagedObject[] managedObjectArray) {
        StringBuffer result2 = new StringBuffer(1000);
        result2.append('[');
        result2.append(Integer.toString(managedObjectArray.length));
        result2.append("]=\n");
        for (int i = 0; i < managedObjectArray.length; ++i) {
            result2.append(" >>> loadModuleList = ");
            result2.append(managedObjectArray[i].getLocalDistinguishedName());
            result2.append('\n');
        }
        return result2.toString();
    }

    private static Object getStringArrayAsString(String[] stringArray) {
        StringBuffer result2 = new StringBuffer(500);
        result2.append('\n');
        for (int i = 0; i < stringArray.length; ++i) {
            result2.append(' ');
            result2.append(Integer.toString(i + 1));
            result2.append(". ");
            result2.append(stringArray[i]);
            result2.append('\n');
        }
        return result2.toString();
    }

    private static String getStructAsString(Struct struct) throws MoAccessException {
        StringBuffer result2 = new StringBuffer(50);
        String[] structNames = struct.getNames();
        result2.append("Struct{");
        result2.append(Integer.toString(structNames.length));
        result2.append("}\n");
        for (int i = 0; i < structNames.length; ++i) {
            result2.append(" >>> ");
            result2.append(Integer.toString(i + 1));
            result2.append('.');
            result2.append(UpgradePackageHelper.getNameAndValue(structNames[i], struct.getValue(structNames[i])));
            result2.append('\n');
        }
        return result2.toString();
    }

    private static String getStructArrayAsString(Struct[] structArray) throws MoAccessException {
        StringBuffer result2 = new StringBuffer(50);
        for (int i = 0; i < structArray.length; ++i) {
            result2.append("\n >>> Struct[");
            result2.append(Integer.toString(i));
            result2.append("] has ");
            result2.append(Integer.toString(structArray[i].size()));
            result2.append(" members\n");
            Struct struct = structArray[i];
            String[] structNames = struct.getNames();
            for (int j = 0; j < structNames.length; ++j) {
                result2.append(" >>> ");
                result2.append(Integer.toString(j + 1));
                result2.append('.');
                result2.append(UpgradePackageHelper.getNameAndValue(structNames[j], struct.getValue(structNames[j])));
                if (j >= structNames.length - 1) continue;
                result2.append('\n');
            }
        }
        return result2.toString();
    }

    private static String getNameAndValue(String name, Object value) {
        StringBuffer result2 = new StringBuffer(50);
        result2.append(name);
        result2.append(" = ");
        result2.append(value.toString());
        return result2.toString();
    }

    private static StringBuffer createLineString(String name, Object value) {
        StringBuffer result2 = new StringBuffer(100);
        result2.append(name);
        result2.append(StringHelper.createFilledString((char)' ', (int)(50 - name.length())));
        result2.append(value.toString());
        if (!value.toString().endsWith("\n")) {
            result2.append('\n');
        }
        return result2;
    }
}

