/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper.smrs;

import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.smrs.SftpInfo;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class SftpDataHandler {
    private static final Class THIS_CLASS = SftpDataHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private SftpInfo sftpInfo = null;
    private final RbsConfigurationMao rbsConfigurationMao;

    public SftpDataHandler(RbsConfigurationMao inRbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "SftpDataHandler()");
        this.rbsConfigurationMao = inRbsConfigurationMao;
        this.refreshSftpInfo();
        logger.traceReturn(THIS_CLASS, "SftpDataHandler()");
    }

    public void refreshSftpInfo() {
        logger.traceEnter(THIS_CLASS, "refreshSftpInfo()");
        FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
        this.sftpInfo = new SftpInfo(fp.getSftpUser(), fp.getSftpPassword(), fp.getSftpAddress(), fp.getSftpSummaryFilePath());
        logger.traceReturn(THIS_CLASS, "refreshSftpInfo()");
    }

    public SftpInfo getRefreshedSftpInfo() {
        this.refreshSftpInfo();
        return this.sftpInfo;
    }

    public SftpInfo getSftpInfo() {
        if (this.sftpInfo == null) {
            this.refreshSftpInfo();
        }
        return this.sftpInfo;
    }

    public boolean isSftpInfoSet() {
        return false;
    }
}

