/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper.smrs;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.smrs.SmrsInfo;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class SmrsDataHandler {
    private static final Class THIS_CLASS = SmrsDataHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String SMRS_ADDRESS = "smrsAddress";
    public static final String SMRS_SUMMARY_FILE_PATH = "smrsSummryPath";
    private SmrsInfo smrsInfo = null;
    private final RbsConfigurationMao rbsConfigurationMao;

    public SmrsDataHandler(RbsConfigurationMao inputRbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "SmrsDataHandler()");
        this.rbsConfigurationMao = inputRbsConfigurationMao;
        logger.traceReturn(THIS_CLASS, "SmrsDataHandler()");
    }

    public SmrsInfo getSmrsInfo() {
        if (this.smrsInfo == null) {
            this.readSmrsInfo();
        }
        return this.smrsInfo;
    }

    public SmrsInfo getRefreshedSmrsInfo() {
        this.readSmrsInfo();
        return this.smrsInfo;
    }

    public void readSmrsInfo() {
        logger.traceEnter(THIS_CLASS, "readSmrsInfo()");
        FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
        this.smrsInfo = new SmrsInfo("", fp.getSmrsUserName(), fp.getSmrsPassword(), fp.getSmrsAddress(), fp.getSmrsSummaryFilePath());
        logger.traceReturn(THIS_CLASS, "readSmrsInfo()");
    }

    public void storeSmrsDataPersistently(String smrsUserName, String smrsPassword, String smrsServer, String summaryFilePath) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storeSmrsDataPersistently()");
        FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
        fp.setSmrsUserName(smrsUserName);
        fp.setSmrsPassword(smrsPassword);
        fp.setSmrsAddress(smrsServer);
        fp.setSmrsSummaryFilePath(summaryFilePath);
        logger.traceGeneral(THIS_CLASS, "Stored updated SMRS address persistently: " + StringHelper.doubleQuote((String)smrsServer));
        logger.traceGeneral(THIS_CLASS, "Stored updated SMRS summary file path persistently: " + StringHelper.doubleQuote((String)summaryFilePath));
        this.readSmrsInfo();
        logger.traceReturn(THIS_CLASS, "storeSmrsDataPersistently()");
    }

    public void storeSmrsServerAddressIfEmpty(String smrsServer) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storeSmrsServerAddressIfEmpty(" + smrsServer + ")");
        FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
        if (!RbsConfigurationHelper.existsAndNotEmpty(fp.getSmrsAddress())) {
            fp.setSmrsAddress(smrsServer);
            this.readSmrsInfo();
        }
        logger.traceReturn(THIS_CLASS, "storeSmrsServerAddressIfEmpty()");
    }

    public void storeSummaryFilePathIfEmpty(String smrsSummaryFilePath) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storeSummaryFilePathIfEmpty(" + smrsSummaryFilePath + ")");
        FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
        if (!RbsConfigurationHelper.existsAndNotEmpty(fp.getSmrsSummaryFilePath())) {
            fp.setSmrsSummaryFilePath(smrsSummaryFilePath);
            this.readSmrsInfo();
        }
        logger.traceReturn(THIS_CLASS, "storeSummaryFilePathIfEmpty()");
    }
}

