/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.AllConflictingAttributes;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.ConflictingAttributes;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStackImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages.StaticRouteReader;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.StaticRoutesData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class CurrentConfigurationDeletor {
    private IpOamConfigurationService ipOamConfigurationService = IpOamConfigurationServiceImpl.getInstance();
    private IpForOamSettingHelper ipForOamSettingHelper = IpForOamSettingHelperImpl.getInstance();
    private IpRollbackStack ipRollbackStack = IpRollbackStackImpl.getInstance();
    private final AbstractLogger logger = LoggingService.getLogger((String)this.getClass().getName());
    private final String slogan = "Deletion of the current configuration failed!";

    public void deleteCurrentConfiguration() throws RbsConfigurationFailedException {
        this.logger.traceEnter(this.getClass(), "deleteCurrentConfiguration()");
        RbsConfigurationHelper helper = null;
        try {
            String defaultRoute;
            ArrayList<String> mosToBeDeleted = new ArrayList<String>();
            RbsConfigurationMao rbsConfigurationMao = (RbsConfigurationMao)this.ipOamConfigurationService.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
            RbsConfigurationContext rbsConfigurationContext = rbsConfigurationMao.getRbsConfigurationContext();
            helper = (RbsConfigurationHelper)rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
            String ipHostLinkMoLdn = ((ManagedObject)this.ipOamConfigurationService.getAllMosOfType("IpHostLink").get(0)).getLocalDistinguishedName();
            ManagedObject ipInterfaceMoRef = (ManagedObject)this.ipOamConfigurationService.getAttribute(ipHostLinkMoLdn, "ipInterfaceMoRef");
            if (ipInterfaceMoRef == null) {
                throw new RbsConfigurationFailedException("Deletion of the current configuration failed!", "ipInterfaceMoRef is null for MO " + ipHostLinkMoLdn + ". This is not a supported configuration!");
            }
            if (ipInterfaceMoRef instanceof VpnInterfaceMo) {
                String[] tmp = (String[])this.ipOamConfigurationService.getAttribute(ipHostLinkMoLdn, "ipv4Addresses");
                defaultRoute = tmp != null ? tmp[0] : ((String[])this.ipOamConfigurationService.getAttribute(ipHostLinkMoLdn, "ipv6Addresses"))[0];
                String vpnInterfaceMoLdn = ipInterfaceMoRef.getLocalDistinguishedName();
                if (!this.ipOamConfigurationService.isTrafficMo(vpnInterfaceMoLdn)) {
                    ManagedObject ipAccessHostEtRef = (ManagedObject)this.ipOamConfigurationService.getAttribute(vpnInterfaceMoLdn, "ipAccessHostEtRef");
                    if (ipAccessHostEtRef == null) {
                        throw new RbsConfigurationFailedException("Deletion of the current configuration failed!", "ipAccessHostEtRef is null in MO " + vpnInterfaceMoLdn + "! This is not a supported configuration!");
                    }
                    String ipAccessHostEtMoLdn = ipAccessHostEtRef.getLocalDistinguishedName();
                    if (!this.ipOamConfigurationService.isTrafficMo(ipAccessHostEtMoLdn)) {
                        ipInterfaceMoRef = (ManagedObject)this.ipOamConfigurationService.getAttribute(ipAccessHostEtMoLdn, "ipInterfaceMoRef");
                        String ipInterfaceMoLdn = ipInterfaceMoRef.getLocalDistinguishedName();
                        if (!this.ipOamConfigurationService.isTrafficMo(ipInterfaceMoLdn)) {
                            this.checkIpInterface(ipInterfaceMoLdn, mosToBeDeleted);
                        }
                        this.checkIpAccessHostEt(ipAccessHostEtMoLdn, mosToBeDeleted);
                    }
                    this.checkVpnInterface(vpnInterfaceMoLdn, mosToBeDeleted);
                }
                mosToBeDeleted.add(ipHostLinkMoLdn);
            } else {
                String ipInterfaceMoLdn = ipInterfaceMoRef.getLocalDistinguishedName();
                defaultRoute = (String)this.ipOamConfigurationService.getAttribute(ipInterfaceMoLdn, "defaultRouter0");
                if (!this.ipOamConfigurationService.isTrafficMo(ipInterfaceMoLdn)) {
                    this.checkIpInterface(ipInterfaceMoLdn, mosToBeDeleted);
                }
                mosToBeDeleted.add(ipHostLinkMoLdn);
            }
            CurrentConfigurationSaver saver = new CurrentConfigurationSaver();
            Map ldnToAttributeMap = saver.saveAttributesForLdnList(mosToBeDeleted);
            AttrList attributes = null;
            this.ipOamConfigurationService.changeNodeInterfaceNameWithRollback("le0");
            for (int i = mosToBeDeleted.size() - 1; i >= 0; --i) {
                String ldn = (String)mosToBeDeleted.get(i);
                try {
                    if (ldn.indexOf("IpAccessHostEt") > -1) {
                        this.ipOamConfigurationService.lockMoWithRollback(ldn);
                    }
                    this.ipOamConfigurationService.deleteMo(ldn);
                }
                catch (RbsConfigurationFailedException e) {
                    this.logger.traceError(this.getClass(), "Could not delete MO " + ldn, (Throwable)((Object)e));
                    throw new RbsConfigurationFailedException("Deletion of the current configuration failed!", "Could not delete MO " + ldn, (Exception)((Object)e));
                }
                attributes = (AttrList)ldnToAttributeMap.get(ldn);
                this.ipRollbackStack.pushCreate(ldn, attributes);
            }
            this.deleteStaticRoute(defaultRoute);
        }
        catch (MoAccessException e) {
            String errMessage = "Deletion of current OAM configuration failed.";
            helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, errMessage, "Delete current configuration failed due to :" + e.getMessage());
            throw new RbsConfigurationFailedException("Deletion of the current configuration failed!", "Something went wrong during the deletion of the current OAM configuration.", (Exception)((Object)e));
        }
        this.logger.traceReturn(this.getClass(), "deleteCurrentConfiguration()");
    }

    private void checkIpInterface(String ipInterfaceLdn, List mosToBeDeletedList) throws MoAccessException {
        this.logger.traceEnter(this.getClass(), "checkIpInterface()");
        List referencedMos = this.ipForOamSettingHelper.getReferencedMos();
        if (!referencedMos.contains(ipInterfaceLdn)) {
            String vlanRef;
            String accessControlListMoLdn;
            if (this.ipOamConfigurationService.getAttribute(ipInterfaceLdn, "accessControlListRef") != null && !referencedMos.contains(accessControlListMoLdn = ((ManagedObject)this.ipOamConfigurationService.getAttribute(ipInterfaceLdn, "accessControlListRef")).getLocalDistinguishedName()) && !this.ipOamConfigurationService.isTrafficMo(accessControlListMoLdn)) {
                mosToBeDeletedList.add(accessControlListMoLdn);
            }
            if (this.ipOamConfigurationService.getAttribute(ipInterfaceLdn, "vlanRef") != null && !referencedMos.contains(vlanRef = ((ManagedObject)this.ipOamConfigurationService.getAttribute(ipInterfaceLdn, "vlanRef")).getLocalDistinguishedName()) && !this.ipOamConfigurationService.isTrafficMo(vlanRef)) {
                mosToBeDeletedList.add(vlanRef);
            }
            mosToBeDeletedList.add(ipInterfaceLdn);
        }
        this.logger.traceReturn(this.getClass(), "checkIpInterface()");
    }

    private void checkIpAccessHostEt(String ipAccessHostEtLdn, List mosToBeDeletedList) {
        this.logger.traceEnter(this.getClass(), "checkIpAccessHostEt()");
        if (!this.ipForOamSettingHelper.getReferencedMos().contains(ipAccessHostEtLdn)) {
            mosToBeDeletedList.add(ipAccessHostEtLdn);
        }
        this.logger.traceReturn(this.getClass(), "checkIpAccessHostEt()");
    }

    private void checkVpnInterface(String vpnInterfaceLdn, List mosToBeDeletedList) throws MoAccessException {
        this.logger.traceEnter(this.getClass(), "checkVpnInterface()");
        List referencedMos = this.ipForOamSettingHelper.getReferencedMos();
        if (!referencedMos.contains(vpnInterfaceLdn)) {
            mosToBeDeletedList.add(vpnInterfaceLdn);
            if (this.ipOamConfigurationService.getAttribute(vpnInterfaceLdn, "reservedBy") != null) {
                List ipSecTunnelMos = this.ipOamConfigurationService.getAllMosOfType("IpSecTunnel");
                String ldn = null;
                for (int i = 0; i < ipSecTunnelMos.size(); ++i) {
                    String ikePeerMoLdn;
                    ldn = ((ManagedObject)ipSecTunnelMos.get(i)).getLocalDistinguishedName();
                    ManagedObject vpnInterfaceRef = (ManagedObject)this.ipOamConfigurationService.getAttribute(ldn, "vpnInterfaceRef");
                    if (!vpnInterfaceRef.getLocalDistinguishedName().equals(vpnInterfaceLdn)) continue;
                    String ipSecTunnelMoLdn = ldn;
                    if (this.ipOamConfigurationService.getAttribute(ipSecTunnelMoLdn, "ikePeerRef") != null && !referencedMos.contains(ikePeerMoLdn = ((ManagedObject)this.ipOamConfigurationService.getAttribute(ipSecTunnelMoLdn, "ikePeerRef")).getLocalDistinguishedName()) && !this.ipOamConfigurationService.isTrafficMo(ikePeerMoLdn)) {
                        mosToBeDeletedList.add(ikePeerMoLdn);
                    }
                    if (referencedMos.contains(ipSecTunnelMoLdn) || this.ipOamConfigurationService.isTrafficMo(ipSecTunnelMoLdn)) break;
                    mosToBeDeletedList.add(ipSecTunnelMoLdn);
                    break;
                }
            }
        }
        this.logger.traceReturn(this.getClass(), "checkVpnInterface()");
    }

    private void deleteStaticRoute(String hopIpAddress) throws RbsConfigurationFailedException {
        this.logger.traceEnter(this.getClass(), "deleteStaticRoute()");
        StaticRouteReader staticRouteReader = new StaticRouteReader();
        TransactionHandler.run(staticRouteReader);
        StaticRoutesData initRoutingTableEntry = staticRouteReader.getStaticRoute(hopIpAddress);
        if (initRoutingTableEntry == null) {
            this.logger.info(this.getClass(), "No RoutingTableEntry with this hopIpAddress was found! Skipping to delete " + hopIpAddress);
            return;
        }
        this.ipOamConfigurationService.performActionDeleteStaticRoute(initRoutingTableEntry.getIpAddress(), hopIpAddress);
        this.ipRollbackStack.pushAction("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1", "actionAddStaticRoute", new String[]{"ipAddress", "networkMask", "nextHopIpAddr", "routeMetric", "redistribute"}, new Object[]{initRoutingTableEntry.getIpAddress(), initRoutingTableEntry.getNetworkMask(), initRoutingTableEntry.getNextHopIpAddr(), initRoutingTableEntry.getRouteMetric(), initRoutingTableEntry.getRedistribute()});
        this.logger.traceReturn(this.getClass(), "deleteStaticRoute()");
    }

    private void removeConflictingAttributes(String moType, AttrList attributes) {
        this.logger.traceEnter(this.getClass(), "removeConflictingAttributes()");
        Map allConflictingAttributes = AllConflictingAttributes.getAllConflictingAttributes();
        ConflictingAttributes[] conflictingAttributes = (ConflictingAttributes[])allConflictingAttributes.get(moType);
        if (conflictingAttributes == null) {
            return;
        }
        for (int i = 0; i < conflictingAttributes.length; ++i) {
            ConflictingAttributes currentConflictingAttributes = conflictingAttributes[i];
            String deprecatedAttribute = currentConflictingAttributes.getDeprecatedAttribute();
            String newAttribute = currentConflictingAttributes.getNewAttribute();
            String[] conflictingAttributesToSearchFor = new String[]{deprecatedAttribute, newAttribute};
            if (!attributes.contains(conflictingAttributesToSearchFor)) continue;
            int indexToRemove = attributes.indexOf(deprecatedAttribute);
            attributes.removeElementAt(indexToRemove);
        }
        this.logger.traceReturn(this.getClass(), "removeConflictingAttributes()");
    }

    private class CurrentConfigurationSaver {
        private CurrentConfigurationSaver() {
        }

        public Map saveAttributesForLdnList(List aList) throws MoAccessException {
            CurrentConfigurationDeletor.this.logger.traceEnter(this.getClass(), "saveAttributesForLdnList( " + aList.toString() + ")");
            HashMap<String, AttrList> ldnToAttributeMap = new HashMap<String, AttrList>();
            for (int i = aList.size() - 1; i >= 0; --i) {
                String ldn = (String)aList.get(i);
                AttrList attributes = CurrentConfigurationDeletor.this.ipOamConfigurationService.getNonReadOnlyAttributes(ldn);
                CurrentConfigurationDeletor.this.removeConflictingAttributes(((IpOamConfigurationServiceImpl)CurrentConfigurationDeletor.this.ipOamConfigurationService).getMoTypeFromLdn(ldn), attributes);
                ldnToAttributeMap.put(ldn, attributes);
            }
            CurrentConfigurationDeletor.this.logger.traceReturn(this.getClass(), "saveAttributesForLdnList( " + aList.toString() + ")");
            return ldnToAttributeMap;
        }
    }
}

