/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.ipsec.IpSecTunnelMo;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.OrbSupervisingThread;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.CurrentConfigurationDeletor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.CvHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpSecCertificateInstaller;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.MomParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.NewConfigurationCreator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.AccessControlListDataConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.AlternativeAccessDataConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.IkePeerDataConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.IpAccessHostEtDataConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.IpHostLinkDataConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.IpInterfaceDataConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.IpSecDataConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.IpSecTunnelDataConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.OssCorbaNameServiceAddressConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.VpnInterfaceDataConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStackImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages.IpOamPinger;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages.IpSecCertificateChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages.MoCreator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages.MoDeletor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages.OamAlternativeAccessHelperTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages.StaticRouteAdder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages.StaticRouteDeletorTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.OssInformer;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.OssInformerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.NodeIpAddressChangePackage.NotAcceptedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.OssNodeIpAddressChangedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.Reason;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.OaMAlternativeAccessHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.RbsConfigurationSiteBasicHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class IpOamConfigurationServiceImpl
implements IpOamConfigurationService {
    private static final Class THIS_CLASS = IpOamConfigurationServiceImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final Object INSTANCE_MUTEX = new Object();
    private static IpOamConfigurationService instance;
    private final IpForOamSettingHelper ipOamHelper = IpForOamSettingHelperImpl.getInstance();
    protected final MoRepositoryWrapper moRepositoryWrapper;
    protected final MoFactoryMgrWrapper moFactoryMgrWrapper;
    protected final GenericMaoContext genericMaoContext;
    private final IpForOamSettingHelper ipForOamSettingHelper;
    private final IpRollbackStack ipRollbackStack;
    private MomParser momParser;

    private IpOamConfigurationServiceImpl(GenericMaoContext inGenericMaoContext) {
        this.genericMaoContext = inGenericMaoContext;
        this.moRepositoryWrapper = this.genericMaoContext.getMoRepositoryWrapper();
        this.moFactoryMgrWrapper = this.genericMaoContext.getMoFactoryMgrWrapper();
        this.ipForOamSettingHelper = IpForOamSettingHelperImpl.getInstance();
        this.ipRollbackStack = IpRollbackStackImpl.getInstance();
    }

    public static IpOamConfigurationService getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IpOamConfigurationService getInstance(GenericMaoContext inGenericMaoContext) {
        logger.traceEnter(THIS_CLASS, "getInstance(GenericMaoContext)");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null || inGenericMaoContext != ((IpOamConfigurationServiceImpl)IpOamConfigurationServiceImpl.instance).genericMaoContext) {
                instance = new IpOamConfigurationServiceImpl(inGenericMaoContext);
            }
        }
        logger.traceReturn(THIS_CLASS, "getInstance(GenericMaoContext)");
        return instance;
    }

    public ManagedObject getMo(String ldn) throws MoNotFoundException {
        ManagedObject mo = this.moRepositoryWrapper.lookup(ldn);
        if (mo == null) {
            throw new MoNotFoundException(ldn + "could not be found.");
        }
        return mo;
    }

    public List getAllMosOfType(String moType) {
        logger.traceEnter(THIS_CLASS, "getAllMosOfType(" + moType + ")");
        ArrayList<ManagedObject> allMosOfType = new ArrayList<ManagedObject>();
        MoIterator iterator = this.moRepositoryWrapper.lookupType(moType);
        if (iterator != null) {
            while (iterator.hasMoreElements()) {
                ManagedObject object = (ManagedObject)iterator.nextElement();
                allMosOfType.add(object);
            }
        }
        logger.traceReturn(THIS_CLASS, "getAllMosOfType(" + moType + ")");
        return allMosOfType;
    }

    public Object getAttribute(String ldn, String attributeName) throws MoAccessException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getAttribute(" + ldn + ", " + attributeName + ")");
        String errorSlogan = "Get attribute failed";
        String errorMessage = "Could not get the attribute " + attributeName + " from the MO " + ldn;
        ManagedObject mo = this.getMo(ldn);
        Object attributeValue = null;
        TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
        try {
            Control control = transFact.create(1000);
            attributeValue = mo.getAttribute(attributeName, control.getCoordinator());
            try {
                control.getTerminator().commit();
            }
            catch (InactiveTransactionException exception) {
                control.getTerminator().rollback();
                throw new RbsConfigurationFailedException("Get attribute failed", errorMessage, (Exception)((Object)exception));
            }
        }
        catch (TransactionRolledBackException exception) {
            throw new RbsConfigurationFailedException("Get attribute failed", errorMessage, (Exception)((Object)exception));
        }
        catch (InactiveTransactionException exception) {
            throw new RbsConfigurationFailedException("Get attribute failed", errorMessage, (Exception)((Object)exception));
        }
        logger.traceReturn(THIS_CLASS, "getAttribute(" + ldn + ", " + attributeName + ")");
        return attributeValue;
    }

    public Object getAttributeFromConfigurationData(String ldn, String attributeName) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getAttributeFromConfigurationData(" + ldn + ", " + attributeName + ")");
        Map configurationData = this.ipForOamSettingHelper.getIpForOamSettingData();
        if (!configurationData.containsKey(ldn)) {
            throw new RbsConfigurationFailedException("IpForOamSettingData fault.", "Could not find MO " + ldn + " in IpForOamSettingData.");
        }
        AttrList attrList = (AttrList)configurationData.get(ldn);
        int index = attrList.indexOf(attributeName);
        if (index == -1) {
            logger.traceReturn(THIS_CLASS, "getAttributeFromConfigurationData(" + ldn + ", " + attributeName + ")");
            return null;
        }
        try {
            logger.traceReturn(THIS_CLASS, "getAttributeFromConfigurationData(" + ldn + ", " + attributeName + ")");
            return attrList.getValue(index);
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException("IpForOamSettingData fault.", "The attribute " + attributeName + " is not a valid attribute for the MO " + ldn, (Exception)((Object)e));
        }
    }

    public AttrList getNonReadOnlyAttributes(String ldn) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getNonReadOnlyAttributes(" + ldn + ")");
        if (this.momParser == null) {
            this.momParser = new MomParser(RbsConfigurationDefinitions.MOM_PARSER_USE_CELLO_MOM);
        }
        Map nonReadOnlyAttributeNameMap = this.momParser.getNonReadOnlyAttributes(this.getMoTypeFromLdn(ldn));
        Iterator nonReadOnlyAttributeNameIterator = nonReadOnlyAttributeNameMap.keySet().iterator();
        AttrListImpl attrList = new AttrListImpl();
        while (nonReadOnlyAttributeNameIterator.hasNext()) {
            String attributeName = (String)nonReadOnlyAttributeNameIterator.next();
            Object attributeValue = this.getAttribute(ldn, attributeName);
            if (attributeValue == null) continue;
            if (attributeValue instanceof ManagedObject) {
                attributeValue = new StringReplacingManagedObject(((ManagedObject)attributeValue).getLocalDistinguishedName());
            }
            attrList.addElement(attributeName, attributeValue);
        }
        logger.traceReturn(THIS_CLASS, "getNonReadOnlyAttributes(" + ldn + ")");
        return attrList;
    }

    public String getMoTypeFromLdn(String ldn) {
        int start = ldn.lastIndexOf(",") + 1;
        int end = ldn.lastIndexOf("=");
        String moType = "";
        if (start != -1 && end != -1) {
            moType = ldn.substring(start, end);
        }
        return moType;
    }

    public void setAttribute(String ldn, String attributeName, Object attributeValue) throws MoAccessException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setAttribute(" + ldn + ", " + attributeName + ", " + attributeValue + ")");
        String errorSlogan = "Set attribute failed";
        String errorMessage = "Could not set the attribute " + attributeName;
        ManagedObject mo = this.getMo(ldn);
        TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
        try {
            Control control = transFact.create(1000);
            mo.setAttribute(attributeName, attributeValue, control.getCoordinator());
            try {
                control.getTerminator().commit();
            }
            catch (InactiveTransactionException exception) {
                control.getTerminator().rollback();
                throw new RbsConfigurationFailedException("Set attribute failed", errorMessage, (Exception)((Object)exception));
            }
        }
        catch (TransactionRolledBackException exception) {
            throw new RbsConfigurationFailedException("Set attribute failed", errorMessage, (Exception)((Object)exception));
        }
        catch (InactiveTransactionException exception) {
            throw new RbsConfigurationFailedException("Set attribute failed", errorMessage, (Exception)((Object)exception));
        }
        logger.traceReturn(THIS_CLASS, "setAttribute(" + ldn + ", " + attributeName + ", " + attributeValue + ")");
    }

    public boolean isTrafficMo(String ldn) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "isTrafficMo(" + ldn + ")");
        if (this.ipForOamSettingHelper.getTrafficMos().isEmpty()) {
            try {
                this.listTrafficMos();
            }
            catch (MoAccessException e) {
                throw new RbsConfigurationFailedException("isTrafficMo failed!", "Could not build list of Traffic Mos.", (Exception)((Object)e));
            }
        }
        if (this.ipForOamSettingHelper.getTrafficMos().contains(ldn)) {
            logger.traceReturn(THIS_CLASS, "isTrafficMo(" + ldn + ")");
            return true;
        }
        logger.traceReturn(THIS_CLASS, "isTrafficMo(" + ldn + ")");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void listTrafficMos() throws MoAccessException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "listTrafficMos()");
        String slogan = "Incorrect IP configuration found!";
        List trafficMos = this.ipForOamSettingHelper.getTrafficMos();
        List ipAccessHostEtMos = this.getAllMosOfType("IpAccessHostEt");
        if (ipAccessHostEtMos.isEmpty()) {
            logger.info(THIS_CLASS, "No MOs for the CP/UP interface was found on the RBS.");
            logger.traceReturn(THIS_CLASS, "listTrafficMos()");
            return;
        }
        if (ipAccessHostEtMos.size() == 1) {
            String ipAccessHostEtMoLdn = ((ManagedObject)ipAccessHostEtMos.get(0)).getLocalDistinguishedName();
            trafficMos.add(ipAccessHostEtMoLdn);
            this.addIpInterfaceMo(ipAccessHostEtMoLdn);
        } else {
            String ipAccessHostEtMoLdn = this.findIpAccessHostEtMoWithoutVpnInterface(ipAccessHostEtMos);
            trafficMos.add(ipAccessHostEtMoLdn);
            ManagedObject ipInterfaceMoRef = (ManagedObject)this.getAttribute(ipAccessHostEtMoLdn, "ipInterfaceMoRef");
            if (ipInterfaceMoRef == null) {
                throw new RbsConfigurationFailedException("Incorrect IP configuration found!", "IpInterfaceMoRef is null for MO " + ipAccessHostEtMoLdn);
            }
            if (ipInterfaceMoRef instanceof VpnInterfaceMo) {
                ManagedObject ipAccessHostEtRef;
                String vpnInterfaceMoLdn = ipInterfaceMoRef.getLocalDistinguishedName();
                trafficMos.add(vpnInterfaceMoLdn);
                if (this.getAttribute(vpnInterfaceMoLdn, "reservedBy") != null) {
                    this.addIpSecTunnelAndIkePeer(vpnInterfaceMoLdn);
                }
                if ((ipAccessHostEtRef = (ManagedObject)this.getAttribute(vpnInterfaceMoLdn, "ipAccessHostEtRef")) == null) throw new RbsConfigurationFailedException("Incorrect IP configuration found!", "There is no value for IpAccessHostEtRef in MO " + vpnInterfaceMoLdn);
                String outerIpAccessHostEtMoLdn = ipAccessHostEtRef.getLocalDistinguishedName();
                trafficMos.add(outerIpAccessHostEtMoLdn);
                this.addIpInterfaceMo(outerIpAccessHostEtMoLdn);
            } else {
                if (!(ipInterfaceMoRef instanceof IpInterfaceMo)) throw new RbsConfigurationFailedException("Incorrect IP configuration found!", "The value of ipInterfaceMoRef in MO " + ipAccessHostEtMoLdn + " is neither a VpnInterface nor a IpInterface!");
                trafficMos.add(ipInterfaceMoRef.getLocalDistinguishedName());
                this.ipOamHelper.addAccessControlListAndVlanRef(ipInterfaceMoRef.getLocalDistinguishedName());
            }
        }
        logger.traceReturn(THIS_CLASS, "listTrafficMos()");
    }

    public String findTrafficMoWithMoType(String moType) throws RbsConfigurationFailedException {
        String slogan = "findTrafficMoWithMoType() failed.";
        List managedObjects = this.getAllMosOfType(moType);
        for (int i = 0; i < managedObjects.size(); ++i) {
            String ldn = ((ManagedObject)managedObjects.get(i)).getLocalDistinguishedName();
            if (moType.equals("IpAccessHostEt")) {
                ManagedObject ipInterfaceMoRef;
                try {
                    ipInterfaceMoRef = (ManagedObject)this.getAttribute(ldn, "ipInterfaceMoRef");
                }
                catch (MoAccessException e) {
                    throw new RbsConfigurationFailedException("findTrafficMoWithMoType() failed.", "Could not access the MO " + ldn, (Exception)((Object)e));
                }
                if (!(ipInterfaceMoRef instanceof VpnInterfaceMo) || !this.isTrafficMo(ldn)) continue;
                return ldn;
            }
            if (!this.isTrafficMo(ldn)) continue;
            return ldn;
        }
        return null;
    }

    private void addIpInterfaceMo(String ipAccessHostEtLdn) throws MoAccessException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "addIpInterfaceMo(" + ipAccessHostEtLdn + ")");
        ManagedObject ipInterfaceMoRef = (ManagedObject)this.getAttribute(ipAccessHostEtLdn, "ipInterfaceMoRef");
        if (ipInterfaceMoRef == null) {
            throw new RbsConfigurationFailedException("Incorrect IP configuration found!", "There is no value for IpInterfaceMoRef in MO " + ipAccessHostEtLdn);
        }
        String ipInterfaceMoLdn = ipInterfaceMoRef.getLocalDistinguishedName();
        this.ipForOamSettingHelper.getTrafficMos().add(ipInterfaceMoLdn);
        this.ipOamHelper.addAccessControlListAndVlanRef(ipInterfaceMoLdn);
        logger.traceReturn(THIS_CLASS, "addIpInterfaceMo(" + ipAccessHostEtLdn + ")");
    }

    private String findIpAccessHostEtMoWithoutVpnInterface(List ipAccessHostEtMos) throws MoAccessException, RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "findIpAccessHostEtMoWithoutVpnInterface()");
        for (int i = 0; i < ipAccessHostEtMos.size(); ++i) {
            String ldn = ((ManagedObject)ipAccessHostEtMos.get(i)).getLocalDistinguishedName();
            ManagedObject[] ipAccessHostEtsReservedBy = (ManagedObject[])this.getAttribute(ldn, "reservedBy");
            if (ipAccessHostEtsReservedBy != null) {
                boolean vpnInterfaceFound = false;
                for (int j = 0; j < ipAccessHostEtsReservedBy.length; ++j) {
                    if (!(ipAccessHostEtsReservedBy[j] instanceof VpnInterfaceMo)) continue;
                    vpnInterfaceFound = true;
                    break;
                }
                if (vpnInterfaceFound) continue;
                logger.traceReturn(THIS_CLASS, "findIpAccessHostEtMoWithoutVpnInterface()");
                return ldn;
            }
            logger.traceReturn(THIS_CLASS, "findIpAccessHostEtMoWithoutVpnInterface()");
            return ldn;
        }
        throw new RbsConfigurationFailedException("Incorrect IP-configuration.", "No IpAccessHostEt MO for traffic was found!");
    }

    private void addIpSecTunnelAndIkePeer(String vpnInterfaceLdn) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addIpSecTunnelAndIkePeer(" + vpnInterfaceLdn + ")");
        ManagedObject[] vpnInterfacesReservedBy = (ManagedObject[])this.getAttribute(vpnInterfaceLdn, "reservedBy");
        for (int i = 0; i < vpnInterfacesReservedBy.length; ++i) {
            if (!(vpnInterfacesReservedBy[i] instanceof IpSecTunnelMo)) continue;
            String ipSecTunnelMoLdn = vpnInterfacesReservedBy[i].getLocalDistinguishedName();
            this.ipForOamSettingHelper.getTrafficMos().add(ipSecTunnelMoLdn);
            ManagedObject ikePeerRef = (ManagedObject)this.getAttribute(ipSecTunnelMoLdn, "ikePeerRef");
            if (ikePeerRef == null) continue;
            String ikePeerMoLdn = ikePeerRef.getLocalDistinguishedName();
            this.ipForOamSettingHelper.getTrafficMos().add(ikePeerMoLdn);
        }
        logger.traceReturn(THIS_CLASS, "addIpSecTunnelAndIkePeer(" + vpnInterfaceLdn + ")");
    }

    public boolean shouldBeCreated(String moType) {
        return this.ipForOamSettingHelper.getMoTypeToLdnMap().containsKey(moType);
    }

    public void convertBackMoReferencesInAttrList(AttrList inAttrList) throws MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "convertBackMoReferencesInAttrList()");
        AttrListImpl attrList = (AttrListImpl)inAttrList;
        int i = 0;
        while (i < attrList.size()) {
            Object attributeValue = attrList.getValue(i);
            if (attributeValue instanceof StringReplacingManagedObject) {
                String attributeName = attrList.getName(i);
                attrList.removeElementAt(i);
                StringReplacingManagedObject moAsString = (StringReplacingManagedObject)attributeValue;
                logger.traceDebug(THIS_CLASS, "Trying to convert back " + attributeName + "=[" + moAsString + "] from StringReplacingManagedObject to ManagedObject");
                ManagedObject newAttributeValue = this.convertBackMoReference(moAsString);
                attrList.addElement(attributeName, (Object)newAttributeValue);
                continue;
            }
            ++i;
        }
        logger.traceReturn(THIS_CLASS, "convertBackMoReferencesInAttrList()");
    }

    public ManagedObject convertBackMoReference(StringReplacingManagedObject stringReplacingManagedObject) throws MoNotFoundException {
        ManagedObject managedObject = stringReplacingManagedObject.getMo(this.moRepositoryWrapper);
        if (managedObject == null) {
            throw new MoNotFoundException("Could not find " + stringReplacingManagedObject.getLdn());
        }
        return managedObject;
    }

    public void performConsistencyCheck() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "performConsistencyCheck()");
        try {
            new OssCorbaNameServiceAddressConsistencyChecker().checkConsistency();
            new IpSecDataConsistencyChecker().checkConsistency();
            new IpHostLinkDataConsistencyChecker().checkConsistency();
            new VpnInterfaceDataConsistencyChecker().checkConsistency();
            new IpAccessHostEtDataConsistencyChecker().checkConsistency();
            new IpInterfaceDataConsistencyChecker().checkConsistency();
            new IpSecTunnelDataConsistencyChecker().checkConsistency();
            new IkePeerDataConsistencyChecker().checkConsistency();
            new AccessControlListDataConsistencyChecker().checkConsistency();
            new AlternativeAccessDataConsistencyChecker().checkConsistency();
        }
        catch (RbsConfigurationFailedException e) {
            String errorMsg = "Consistency check failed.";
            this.getRbsConfigurationHelper().setFaultReason(RbsConfigurationDefinitions.RBS_FR_OAM_CONFIG_FILE_FAULT, "ConsistencyCheck-error", "Consistency check failed.");
            throw e;
        }
        logger.traceReturn(THIS_CLASS, "performConsistencyCheck()");
    }

    public void checkIpSecLicense() throws RbsConfigurationFailedException {
        Integer licenseState;
        ManagedObject ipSecMo;
        logger.traceEnter(THIS_CLASS, "checkIpSecLicense()");
        String slogan = "IP Sec license check failed!";
        try {
            ipSecMo = this.getMo("ManagedElement=1,IpSystem=1,IpSec=1");
        }
        catch (MoNotFoundException e) {
            logger.info(this.getClass(), "IpSec MO not found. Creating a new IpSec MO.");
            ipSecMo = this.createMo("ManagedElement=1,IpSystem=1,IpSec=1", (AttrList)new AttrListImpl());
        }
        try {
            licenseState = (Integer)this.getAttribute(ipSecMo.getLocalDistinguishedName(), "licenseState");
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException("IP Sec license check failed!", "Could not access the IpSec MO while fetching licenseState", (Exception)((Object)e));
        }
        boolean LICENSE_DISABLED = false;
        if (licenseState == 0) {
            throw new RbsConfigurationFailedException("IP Sec license check failed!", "An IP Sec license is not installed on the node.");
        }
        logger.traceReturn(THIS_CLASS, "checkIpSecLicense()");
    }

    public boolean isIpSecCertificateInstalled() throws RbsConfigurationFailedException {
        IpSecMo ipSecMo;
        logger.traceEnter(THIS_CLASS, "isIpSecCertificateInstalled()");
        try {
            ipSecMo = (IpSecMo)this.getMo("ManagedElement=1,IpSystem=1,IpSec=1");
        }
        catch (MoNotFoundException e) {
            throw new RbsConfigurationFailedException("Check of IpSec Certificate failed!", "Could not fetch IpSec MO", (Exception)((Object)e));
        }
        IpSecCertificateChecker ipSecCertificateChecker = new IpSecCertificateChecker(ipSecMo);
        TransactionHandler.run(ipSecCertificateChecker);
        logger.traceReturn(THIS_CLASS, "isIpSecCertificateInstalled()");
        return ipSecCertificateChecker.isCertificateInstalled();
    }

    public String installIpSecCertificate(String localIscfFilePath, String rbsIntegrationCode, String smrsUserId) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "installIpSecCertificate()");
        IpSecCertificateInstaller ipSecCertificateInstaller = new IpSecCertificateInstaller(localIscfFilePath, rbsIntegrationCode, smrsUserId);
        String fingerPrint = ipSecCertificateInstaller.installCertificate();
        logger.traceReturn(THIS_CLASS, "installIpSecCertificate()");
        return fingerPrint;
    }

    public void deleteCurrentConfiguration() throws RbsConfigurationFailedException {
        this.deactivateAlternativeAccessIfRequested();
        CurrentConfigurationDeletor currentConfigurationDeletor = new CurrentConfigurationDeletor();
        currentConfigurationDeletor.deleteCurrentConfiguration();
    }

    protected void deactivateAlternativeAccessIfRequested() throws RbsConfigurationFailedException {
        boolean deactivationRequested;
        IpData ipData = this.ipForOamSettingHelper.getIpData();
        boolean bl = deactivationRequested = ipData != null && ipData.getOaMAlternativeAccess() != null && (ipData.getOaMAlternativeAccess() == false || this.isAlternativeAccessConfigured());
        if (deactivationRequested) {
            OaMAlternativeAccessHelper alternativeAccessHelper = new OaMAlternativeAccessHelper();
            alternativeAccessHelper.deactivateOaMAlternativeAccess();
        }
    }

    private boolean isAlternativeAccessConfigured() throws RbsConfigurationFailedException {
        String ipLdn = "ManagedElement=1,IpOam=1,Ip=1";
        String attrName = "ipAccessHostEtRef";
        try {
            return this.getAttribute(ipLdn, attrName) != null;
        }
        catch (MoAccessException e) {
            String slogan = "Delete of the current OAM configuration failed.";
            String faultMsg = "Exception was thrown while fetching the attribute " + attrName + " from the MO " + ipLdn;
            throw new RbsConfigurationFailedException(slogan, faultMsg, (Exception)((Object)e));
        }
    }

    public void createConfiguration() throws RbsConfigurationFailedException {
        boolean configurationRequested;
        NewConfigurationCreator newConfigurationCreator = new NewConfigurationCreator();
        newConfigurationCreator.createNewConfiguration();
        IpData ipData = this.ipForOamSettingHelper.getIpData();
        boolean bl = configurationRequested = ipData != null && ipData.getOaMAlternativeAccess() != null && ipData.getOaMAlternativeAccess() != false;
        if (configurationRequested) {
            boolean configurationDataProvided;
            boolean bl2 = configurationDataProvided = ipData != null && ipData.getOaMAlternativeAccessSourceData() != null && ipData.getOaMAlternativeAccessSourceData().length > 0;
            if (configurationDataProvided) {
                this.configureAlternativeAccess();
            } else {
                logger.traceAbnormal(THIS_CLASS, "Incomplete configuration for alternative O&M connection provided, alternative access will not be configured");
            }
        }
    }

    public void configureAlternativeAccess() throws RbsConfigurationFailedException {
        RbsConfigurationMao rbsConfigurationMao;
        logger.traceEnter(THIS_CLASS, "configureAlternativeAccess()");
        String slogan = "Configuration of Alternative Access failed.";
        try {
            rbsConfigurationMao = (RbsConfigurationMao)this.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
        }
        catch (MoNotFoundException e1) {
            throw new RbsConfigurationFailedException("Configuration of Alternative Access failed.", "RbsConfigurationMao not found", (Exception)((Object)e1));
        }
        RbsConfigurationSiteBasicHelper rbsConfigurationSiteBasicHelper = new RbsConfigurationSiteBasicHelper(rbsConfigurationMao, this.moRepositoryWrapper);
        OaMAlternativeAccessHelper oaMAlternativeAccessHelper = new OaMAlternativeAccessHelper();
        IpData ipData = this.ipForOamSettingHelper.getIpData();
        TransactionHandler.run(new OamAlternativeAccessHelperTp(oaMAlternativeAccessHelper, ipData, rbsConfigurationSiteBasicHelper, this.moRepositoryWrapper, this.moFactoryMgrWrapper));
        logger.traceReturn(THIS_CLASS, "configureAlternativeAccess()");
    }

    public void verifyOamConnectivity() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "verifyOamConnectivity()");
        String ipAddressToPing = null;
        try {
            ipAddressToPing = (String)this.getAttribute("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1", "ossCorbaNameServiceAddress");
        }
        catch (MoAccessException e) {
            logger.traceError(THIS_CLASS, "Could not access MO ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1. Trying to recover from this error.");
            String errorSlogan = "Verification of OAM connectivity failed";
            String errorMessage = "Could not fetch attribute ossCorbaNameServiceAddress from RbsConfigurationMao.";
            RbsConfigurationHelper helper = this.getRbsConfigurationHelper();
            helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Verification of OAM connectivity failed", "Could not fetch attribute ossCorbaNameServiceAddress from RbsConfigurationMao.");
            throw new RbsConfigurationFailedException("Verification of OAM connectivity failed", "Could not fetch attribute ossCorbaNameServiceAddress from RbsConfigurationMao.", (Exception)((Object)e));
        }
        if (ipAddressToPing == null || ipAddressToPing.equals("")) {
            logger.traceAbnormal(THIS_CLASS, "The attribute ossCorbaNameServiceAddress of the RbsConfiguration MO is not set. Informing OSS directly instead of verifying connectivity first.");
            logger.traceReturn(THIS_CLASS, "verifyOamConnectivity()");
            return;
        }
        TransactionHandler.run(new IpOamPinger(ipAddressToPing));
        logger.traceReturn(THIS_CLASS, "verifyOamConnectivity()");
    }

    public void notifyOssOfChangedIpAddress(String inOldIpAddress, String hash, Reason reason) throws RbsConfigurationFailedException {
        String newIp;
        RbsConfigurationMao rbsConfigurationMao;
        ManagedObject managedElement;
        logger.traceEnter(THIS_CLASS, "notificationOfChangedIpAddress()");
        String errorSlogan = "Notification of new OAM IP address to OSS failed.";
        try {
            managedElement = this.getMo("ManagedElement=1");
        }
        catch (MoNotFoundException e) {
            throw new RbsConfigurationFailedException("Notification of new OAM IP address to OSS failed.", "ManagedElement not found.", (Exception)((Object)e));
        }
        String managedElementFdn = managedElement.getFullDistinguishedName();
        int indexOfLastSeparator = managedElementFdn.lastIndexOf(",");
        String nodeId = "";
        if (indexOfLastSeparator != -1) {
            nodeId = managedElementFdn.substring(0, indexOfLastSeparator);
        }
        try {
            rbsConfigurationMao = (RbsConfigurationMao)this.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
        }
        catch (MoNotFoundException e) {
            throw new RbsConfigurationFailedException("Notification of new OAM IP address to OSS failed.", "RbsConfigurationMao not found.", (Exception)((Object)e));
        }
        RbsConfigurationContext rbsConfigurationContext = rbsConfigurationMao.getRbsConfigurationContext();
        String oldIp = inOldIpAddress;
        ManagedObject ipHostLinkMo = (ManagedObject)this.getAllMosOfType("IpHostLink").get(0);
        try {
            newIp = ((String[])this.getAttribute(ipHostLinkMo.getLocalDistinguishedName(), "ipv4Addresses"))[0];
        }
        catch (MoAccessException e1) {
            throw new RbsConfigurationFailedException("Notification of new OAM IP address to OSS failed.", "Could not get the new IP address from the IpHostLink MO.", (Exception)((Object)e1));
        }
        logger.info(THIS_CLASS, "Informing OSS about:\nnodeId: " + nodeId + ", oldIp: " + oldIp + ", newIp: " + newIp + ", reason: " + reason);
        OssInformer ossInformer = OssInformerFactory.createOssInformer(rbsConfigurationContext);
        try {
            ossInformer.notificationOfChangedIpAddress(nodeId, oldIp, newIp, reason, hash);
        }
        catch (NotAcceptedException e) {
            throw new RbsConfigurationFailedException("Notification of new OAM IP address to OSS failed.", "The NodeIpAddressChange service could not be invoked.", (Exception)((Object)e));
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException("Notification of new OAM IP address to OSS failed.", "The OSS address could not be retrieved.", (Exception)((Object)e));
        }
        catch (OssNodeIpAddressChangedException e) {
            throw new RbsConfigurationFailedException("Notification of new OAM IP address to OSS failed.", "The NodeIpAddressChange service could not be retrieved from name service.", e);
        }
        logger.traceReturn(THIS_CLASS, "notificationOfChangedIpAddress()");
    }

    public ManagedObject createMo(String ldn, AttrList attributeList) throws RbsConfigurationFailedException {
        ManagedObject createdMo;
        logger.traceEnter(THIS_CLASS, "createMo(" + ldn + ")");
        MoCreator moCreator = new MoCreator(this.moFactoryMgrWrapper, ldn, attributeList);
        TransactionHandler.run(moCreator);
        try {
            createdMo = this.getMo(ldn);
        }
        catch (MoNotFoundException e) {
            throw new RbsConfigurationFailedException("MO was not found", "The created MO " + ldn + " was not found on the node.", (Exception)((Object)e));
        }
        Thread.yield();
        long creation_delay = 1000L;
        String isUnitTest = System.getProperty("UNIT_TEST");
        if (isUnitTest != null && isUnitTest.equalsIgnoreCase("TRUE")) {
            creation_delay = 10L;
        }
        try {
            Thread.sleep(creation_delay);
        }
        catch (InterruptedException e) {
            throw new RbsConfigurationFailedException("InterruptedException exception", "Interrupted sleep after MO creation: " + ldn, e);
        }
        logger.traceReturn(THIS_CLASS, "createMo(" + ldn + ")");
        return createdMo;
    }

    public void deleteMo(String ldn) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "deleteMo(" + ldn + ")");
        String errSlogan = "Deletion of MO " + ldn + " failed.";
        MoDeletor moDeletor = new MoDeletor(ldn);
        TransactionHandler.run(moDeletor);
        Thread.yield();
        long deletion_delay = 1000L;
        String isUnitTest = System.getProperty("UNIT_TEST");
        if (isUnitTest != null && isUnitTest.equalsIgnoreCase("TRUE")) {
            deletion_delay = 10L;
        }
        try {
            Thread.sleep(deletion_delay);
        }
        catch (InterruptedException e) {
            throw new RbsConfigurationFailedException(errSlogan, "InterruptedException exception thrown.", e);
        }
        logger.traceReturn(THIS_CLASS, "deleteMo(" + ldn + ")");
    }

    public void lockMo(String ldn) throws MoAccessException {
        logger.traceEnter(this.getClass(), "lockMo(" + ldn + ")");
        String attributeName = "administrativeState";
        Integer newState = RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_LOCKED;
        this.setAttribute(ldn, "administrativeState", newState);
        logger.traceReturn(this.getClass(), "lockMo(" + ldn + ")");
    }

    public void lockMoWithRollback(String ldn) throws MoAccessException {
        logger.traceEnter(this.getClass(), "lockMoWithRollback(" + ldn + ")");
        String attributeName = "administrativeState";
        Integer oldState = (Integer)this.getAttribute(ldn, "administrativeState");
        this.lockMo(ldn);
        this.ipRollbackStack.pushSet(ldn, new String[]{"administrativeState"}, new Object[]{oldState});
        logger.traceReturn(this.getClass(), "lockMoWithRollback(" + ldn + ")");
    }

    public void performActionAddStaticRoute(String ipAddress, String subnetMask, String hopIpAddress, Integer routeMetric, boolean redistribute) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "performActionAddStaticRoute(" + ipAddress + "," + subnetMask + "," + hopIpAddress + "," + routeMetric.toString() + "," + redistribute + ")");
        StaticRouteAdder staticRouteAdder = new StaticRouteAdder(ipAddress, subnetMask, hopIpAddress, routeMetric, redistribute);
        TransactionHandler.run(staticRouteAdder);
        logger.traceReturn(THIS_CLASS, "performActionAddStaticRoute(" + ipAddress + "," + subnetMask + "," + hopIpAddress + "," + routeMetric.toString() + "," + redistribute + ")");
    }

    public void performActionDeleteStaticRoute(String destinationIpAddress, String nextHopIpAddress) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "performActionDeleteStaticRoute(" + destinationIpAddress + "," + nextHopIpAddress + ")");
        StaticRouteDeletorTp staticRouteDeleter = new StaticRouteDeletorTp(destinationIpAddress, nextHopIpAddress);
        TransactionHandler.run(staticRouteDeleter);
        logger.traceReturn(THIS_CLASS, "performActionDeleteStaticRoute(" + destinationIpAddress + "," + nextHopIpAddress + ")");
    }

    public void changeNodeInterfaceName(String newNodeInterfaceName) throws RbsConfigurationFailedException {
        logger.traceEnter(this.getClass(), "changeNodeInterfaceName(" + newNodeInterfaceName + ")");
        String errorSlogan = "Changing node interface failed.";
        String ipMoLdn = "ManagedElement=1,IpOam=1,Ip=1";
        String nodeInterfaceNameAttribute = "nodeInterfaceName";
        long orbRestartMaxWaitingTime = 90000L;
        String isUnitTest = System.getProperty("UNIT_TEST");
        if (isUnitTest != null && isUnitTest.equalsIgnoreCase("TRUE")) {
            orbRestartMaxWaitingTime = 10L;
        }
        OrbSupervisingThread orbSupervisingThread = new OrbSupervisingThread();
        orbSupervisingThread.start();
        try {
            this.setAttribute("ManagedElement=1,IpOam=1,Ip=1", "nodeInterfaceName", newNodeInterfaceName);
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException("Changing node interface failed.", "The change of nodeInterfaceName to " + newNodeInterfaceName, (Exception)((Object)e));
        }
        Thread.yield();
        try {
            logger.traceDebug(THIS_CLASS, "Waiting for ORB to be restarted");
            orbSupervisingThread.join(orbRestartMaxWaitingTime);
            if (!orbSupervisingThread.orbHasBeenDownAndComeUpAgain()) {
                String errorMessage = "The ORB did not go down and come up again within " + orbRestartMaxWaitingTime / 1000L + " seconds.";
                logger.traceAbnormal(THIS_CLASS, errorMessage);
            }
        }
        catch (InterruptedException e) {
            String errorMessage = "The ORB waiting was interrupted.";
            logger.traceError(THIS_CLASS, "Changing node interface failed. The ORB waiting was interrupted.");
            throw new RbsConfigurationFailedException("Changing node interface failed.", "The ORB waiting was interrupted.", e);
        }
        logger.traceReturn(this.getClass(), "changeNodeInterfaceName(" + newNodeInterfaceName + ")");
    }

    public void changeNodeInterfaceNameWithRollback(String newNodeInterfaceName) throws RbsConfigurationFailedException {
        logger.traceEnter(this.getClass(), "changeNodeInterfaceNameWithRollback(" + newNodeInterfaceName + ")");
        String errorSlogan = "Changing node interface failed.";
        String ipMoLdn = "ManagedElement=1,IpOam=1,Ip=1";
        String nodeInterfaceNameAttribute = "nodeInterfaceName";
        String changeNodeInterfaceName = "actionChangeNodeInterfaceName";
        try {
            String oldNodeInterfaceName = (String)this.getAttribute("ManagedElement=1,IpOam=1,Ip=1", "nodeInterfaceName");
            this.changeNodeInterfaceName(newNodeInterfaceName);
            this.ipRollbackStack.pushAction("ManagedElement=1,IpOam=1,Ip=1", "actionChangeNodeInterfaceName", new String[]{"nodeInterfaceName"}, new String[]{oldNodeInterfaceName});
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException("Changing node interface failed.", "The change of nodeInterfaceName to " + newNodeInterfaceName + " failed.", (Exception)((Object)e));
        }
        logger.traceReturn(this.getClass(), "changeNodeInterfaceNameWithRollback(" + newNodeInterfaceName + ")");
    }

    public RbsConfigurationHelper getRbsConfigurationHelper() throws RbsConfigurationFailedException {
        RbsConfigurationHelper helper = null;
        String slogan = "Could not access MO RbsConfiguration";
        try {
            RbsConfigurationMao rbsConfigurationMao = (RbsConfigurationMao)this.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
            RbsConfigurationContext rbsConfigurationContext = rbsConfigurationMao.getRbsConfigurationContext();
            helper = (RbsConfigurationHelper)rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        }
        catch (MoAccessException e) {
            logger.traceError(this.getClass(), "Could not access MO  RbsConfiguration :ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
            String errMessage = "Action Failed, Could not access MO  RbsConfiguration.";
            throw new RbsConfigurationFailedException("Could not access MO RbsConfiguration", "Action Failed, Could not access MO  RbsConfiguration.", (Exception)((Object)e));
        }
        return helper;
    }

    public void resetMomParser() {
        this.momParser = null;
    }

    public static void setInstanceOnlyForBasicTest(IpOamConfigurationService ipOamConfigurationService) {
        instance = ipOamConfigurationService;
    }

    public void createCv() throws RbsConfigurationFailedException {
        String slogan = "CV autocreation failed at the end of changeIpForOamSetting execution.";
        try {
            RbsConfigurationMao rbsConfigurationMao = (RbsConfigurationMao)this.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
            RbsConfigurationContext rbsConfigurationContext = rbsConfigurationMao.getRbsConfigurationContext();
            CvHelper cvHelper = new CvHelper(rbsConfigurationContext);
            cvHelper.createCv();
        }
        catch (MoAccessException e) {
            logger.traceError(this.getClass(), "Could not create new CV");
            String errMessage = "Could not create new CV.";
            throw new RbsConfigurationFailedException("CV autocreation failed at the end of changeIpForOamSetting execution.", "Could not create new CV.", (Exception)((Object)e));
        }
    }
}

