/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.AccessControlListParameterConverter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.IkePeerParameterConverter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.IpAccessHostEtParameterConverter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.IpHostLinkParameterConverter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.IpInterfaceParameterConverter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.IpParameterConverter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.IpSecParameterConverter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.IpSecTunnelParameterConverter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.VpnInterfaceParameterConverter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AccessControlListData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IkePeerData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpAccessHostEtData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpHostLinkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpInterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSecData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSecTunnelData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SiteBasicData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.VpnInterfaceData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpSecConfigurationData {
    private static final Class THIS_CLASS = IpSecConfigurationData.class;
    private final IpForOamSettingHelper ipOamHelper = IpForOamSettingHelperImpl.getInstance();
    private SiteBasicData siteBasicData;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private IpInterfaceData[] ipInterfaceData;
    private IpAccessHostEtData[] ipAccessHostEtData;
    private IpHostLinkData ipHostLinkData;
    private VpnInterfaceData[] vpnInterfaceData;
    private IkePeerData[] ikePeerData;
    private IpSecTunnelData[] ipSecTunnelData;
    private AccessControlListData[] accessControlListData;
    private IpData ipData;
    private final String slogan = "Parsing of XML file failed.";

    public void putConfigurationData(SiteBasicData theSiteBasicData) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "putConfigurationData()");
        this.siteBasicData = theSiteBasicData;
        this.putIntoHelperIpInterfacedata();
        this.putIntoHelperIpdata();
        this.putIntoHelperIpSecData();
        this.putIntoHelperIpHostLinkdata();
        this.putIntoHelperIpAccessHostEtData();
        this.putIntoHelperVpnInterfaceData();
        this.putIntoHelperIpSecTunnelData();
        this.putIntoHelperIkePeerData();
        this.putIntoAccessControlListData();
        logger.traceReturn(THIS_CLASS, "putConfigurationData()");
    }

    private void putIntoHelperIpInterfacedata() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "putIntoHelperIpInterfacedata()");
        if (this.siteBasicData == null || this.siteBasicData.getIpInterfaceData() == null || this.siteBasicData.getIpInterfaceData().length == 0) {
            logger.traceReturn(THIS_CLASS, "putIntoHelperIpInterfacedata()");
            return;
        }
        this.ipInterfaceData = this.siteBasicData.getIpInterfaceData();
        if (this.ipInterfaceData.length > 1) {
            throw new RbsConfigurationFailedException("Parsing of XML file failed.", "There is more than one instance of the IpInterface MO in the XML-file.");
        }
        IpInterfaceParameterConverter ipInterfaceParameterConverter = new IpInterfaceParameterConverter(this.ipInterfaceData[0]);
        AttrList attrList = ipInterfaceParameterConverter.convert();
        String ldn = ipInterfaceParameterConverter.getLdn();
        this.ipOamHelper.getIpForOamSettingData().put(ldn, attrList);
        this.ipOamHelper.getMoTypeToLdnMap().put(ipInterfaceParameterConverter.getMoType(), ldn);
        logger.traceReturn(THIS_CLASS, "putIntoHelperIpInterfacedata()");
    }

    private void putIntoHelperIpdata() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "putIntoHelperIpdata()");
        if (this.siteBasicData == null || this.siteBasicData.getIpData() == null) {
            logger.traceReturn(THIS_CLASS, "putIntoHelperIpdata()");
            return;
        }
        this.ipData = this.siteBasicData.getIpData();
        IpParameterConverter ipParameterConverter = new IpParameterConverter(this.ipData);
        AttrList attrList = ipParameterConverter.convert();
        String ldn = ipParameterConverter.getLdn();
        this.ipOamHelper.getIpForOamSettingData().put(ldn, attrList);
        this.ipOamHelper.getMoTypeToLdnMap().put(ipParameterConverter.getMoType(), ldn);
        this.ipOamHelper.setIpData(this.ipData);
        logger.traceReturn(THIS_CLASS, "putIntoHelperIpdata()");
    }

    private void putIntoHelperIpSecData() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "putIntoHelperIpSecData()");
        if (this.siteBasicData == null || this.siteBasicData.getIpSystemData() == null || this.siteBasicData.getIpSystemData().getIpsecData() == null) {
            logger.traceReturn(THIS_CLASS, "putIntoHelperIpSecData()");
            return;
        }
        IpSecData ipSecData = this.siteBasicData.getIpSystemData().getIpsecData();
        IpSecParameterConverter ipSecParameterConverter = new IpSecParameterConverter(ipSecData);
        AttrList attrList = ipSecParameterConverter.convert();
        String ldn = ipSecParameterConverter.getLdn();
        this.ipOamHelper.getIpForOamSettingData().put(ldn, attrList);
        this.ipOamHelper.getMoTypeToLdnMap().put(ipSecParameterConverter.getMoType(), ldn);
        logger.traceReturn(THIS_CLASS, "putIntoHelperIpSecData()");
    }

    private void putIntoHelperIpHostLinkdata() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "putIntoHelperIpHostLinkdata()");
        if (this.siteBasicData == null || this.siteBasicData.getIpData() == null || this.siteBasicData.getIpData().getIpHostLinkData() == null) {
            logger.traceReturn(THIS_CLASS, "putIntoHelperIpHostLinkdata()");
            return;
        }
        this.ipHostLinkData = this.siteBasicData.getIpData().getIpHostLinkData();
        IpHostLinkParameterConverter ipHostLinkParameterConverter = new IpHostLinkParameterConverter(this.ipHostLinkData);
        AttrList attrList = ipHostLinkParameterConverter.convert();
        String ldn = ipHostLinkParameterConverter.getLdn();
        this.ipOamHelper.getIpForOamSettingData().put(ldn, attrList);
        this.ipOamHelper.getMoTypeToLdnMap().put(ipHostLinkParameterConverter.getMoType(), ldn);
        logger.traceReturn(THIS_CLASS, "putIntoHelperIpHostLinkdata()");
    }

    private void putIntoHelperIpAccessHostEtData() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "putIntoHelperIpAccessHostEtData()");
        if (this.siteBasicData == null || this.siteBasicData.getIpSystemData() == null || this.siteBasicData.getIpSystemData().getIpAccessHostEtData() == null) {
            logger.traceReturn(THIS_CLASS, "putIntoHelperIpAccessHostEtData()");
            return;
        }
        this.ipAccessHostEtData = this.siteBasicData.getIpSystemData().getIpAccessHostEtData();
        if (this.ipAccessHostEtData != null && this.ipAccessHostEtData.length > 1) {
            throw new RbsConfigurationFailedException("Parsing of XML file failed.", "There is more than one instance of the IpAccessHostEt MO in the XML file.");
        }
        IpAccessHostEtParameterConverter ipAccessHostEtParameterConverter = new IpAccessHostEtParameterConverter(this.ipAccessHostEtData[0]);
        AttrList attrList = ipAccessHostEtParameterConverter.convert();
        String ldn = ipAccessHostEtParameterConverter.getLdn();
        this.ipOamHelper.getIpForOamSettingData().put(ldn, attrList);
        this.ipOamHelper.getMoTypeToLdnMap().put(ipAccessHostEtParameterConverter.getMoType(), ldn);
        logger.traceReturn(THIS_CLASS, "putIntoHelperIpAccessHostEtData()");
    }

    private void putIntoHelperVpnInterfaceData() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "putIntoHelperVpnInterfaceData()");
        if (this.siteBasicData == null || this.siteBasicData.getIpSystemData() == null || this.siteBasicData.getIpSystemData().getVpnInterfaceData() == null) {
            logger.traceReturn(THIS_CLASS, "putIntoHelperVpnInterfaceData()");
            return;
        }
        this.vpnInterfaceData = this.siteBasicData.getIpSystemData().getVpnInterfaceData();
        if (this.vpnInterfaceData.length > 1) {
            throw new RbsConfigurationFailedException("Parsing of XML file failed.", "There is more than one instance of the VpnInterface MO in the XML file.");
        }
        VpnInterfaceParameterConverter vpnInterfaceParameterConverter = new VpnInterfaceParameterConverter(this.vpnInterfaceData[0]);
        AttrList attrList = vpnInterfaceParameterConverter.convert();
        String ldn = vpnInterfaceParameterConverter.getLdn();
        this.ipOamHelper.getIpForOamSettingData().put(ldn, attrList);
        this.ipOamHelper.getMoTypeToLdnMap().put(vpnInterfaceParameterConverter.getMoType(), ldn);
        logger.traceReturn(THIS_CLASS, "putIntoHelperVpnInterfaceData()");
    }

    private void putIntoHelperIpSecTunnelData() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "putIntoHelperIpSecTunnelData()");
        if (this.siteBasicData == null || this.siteBasicData.getIpSystemData() == null || this.siteBasicData.getIpSystemData().getIpsecData() == null || this.siteBasicData.getIpSystemData().getIpsecData().getIpSecTunnelData() == null) {
            logger.traceReturn(THIS_CLASS, "putIntoHelperIpSecTunnelData()");
            return;
        }
        this.ipSecTunnelData = this.siteBasicData.getIpSystemData().getIpsecData().getIpSecTunnelData();
        if (this.ipSecTunnelData.length > 1) {
            throw new RbsConfigurationFailedException("Parsing of XML file failed.", "There is more than one instance of the IpSecTunnel MO in the XML file.");
        }
        IpSecTunnelParameterConverter ipSecTunnelParameterConverter = new IpSecTunnelParameterConverter(this.ipSecTunnelData[0]);
        AttrList attrList = ipSecTunnelParameterConverter.convert();
        String ldn = ipSecTunnelParameterConverter.getLdn();
        this.ipOamHelper.getIpForOamSettingData().put(ldn, attrList);
        this.ipOamHelper.getMoTypeToLdnMap().put(ipSecTunnelParameterConverter.getMoType(), ldn);
        logger.traceReturn(THIS_CLASS, "putIntoHelperIpSecTunnelData()");
    }

    private void putIntoHelperIkePeerData() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "putIntoHelperIkePeerData()");
        if (this.siteBasicData == null || this.siteBasicData.getIpSystemData() == null || this.siteBasicData.getIpSystemData().getIpsecData() == null || this.siteBasicData.getIpSystemData().getIpsecData().getIkePeerData() == null) {
            logger.traceReturn(THIS_CLASS, "putIntoHelperIkePeerData()");
            return;
        }
        this.ikePeerData = this.siteBasicData.getIpSystemData().getIpsecData().getIkePeerData();
        if (this.ikePeerData.length > 1) {
            throw new RbsConfigurationFailedException("Parsing of XML file failed.", "There is more than one instance of the IkePeerData MO in the XML-file.");
        }
        IkePeerParameterConverter ikePeerParameterConverter = new IkePeerParameterConverter(this.ikePeerData[0]);
        AttrList attrList = ikePeerParameterConverter.convert();
        String ldn = ikePeerParameterConverter.getLdn();
        this.ipOamHelper.getIpForOamSettingData().put(ldn, attrList);
        this.ipOamHelper.getMoTypeToLdnMap().put(ikePeerParameterConverter.getMoType(), ldn);
        logger.traceReturn(THIS_CLASS, "putIntoHelperIkePeerData()");
    }

    private void putIntoAccessControlListData() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, " enter putIntoAccessControlListData()");
        if (this.siteBasicData == null || this.siteBasicData.getIpSystemData() == null || this.siteBasicData.getIpSystemData().getAccessControlListData() == null) {
            logger.traceReturn(THIS_CLASS, "putIntoAccessControlListData()");
            return;
        }
        this.accessControlListData = this.siteBasicData.getIpSystemData().getAccessControlListData();
        if (this.accessControlListData.length > 1) {
            throw new RbsConfigurationFailedException("Parsing of XML file failed.", "There is more than one instance of the AccessControlList MO in the XML-file.");
        }
        AccessControlListParameterConverter accessControlListParameterConverter = new AccessControlListParameterConverter(this.accessControlListData[0]);
        AttrList attrList = accessControlListParameterConverter.convert();
        String ldn = accessControlListParameterConverter.getLdn();
        this.ipOamHelper.getIpForOamSettingData().put(ldn, attrList);
        this.ipOamHelper.getMoTypeToLdnMap().put(accessControlListParameterConverter.getMoType(), ldn);
        logger.traceReturn(THIS_CLASS, "putIntoAccessControlListData()");
    }
}

