/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.MomParserExecutor;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.Definitions;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.factory.MoFactory;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class MomParser {
    private static final Class THIS_CLASS = MomParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final Map moMap = new HashMap();
    private String fileName = "";
    private String filePath = "";

    public MomParser(Integer momVersion) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "MomParser()");
        this.fileName = this.findXmlMom(momVersion);
        if (this.fileName == null) {
            String reason = "Could not find XML MOM file.";
            logger.traceError(THIS_CLASS, "Could not find XML MOM file.");
            throw new RbsConfigurationFailedException("MOM parsing failure", "Could not find XML MOM file.");
        }
        try {
            this.fillInMoMap();
            logger.traceReturn(THIS_CLASS, "MomParser()");
        }
        catch (IOException e) {
            String reason = "Failure when parsing the MOM. " + e.getMessage();
            logger.traceError(THIS_CLASS, reason);
            throw new RbsConfigurationFailedException("MOM parsing failure", reason, e);
        }
    }

    public MomParser(String inFileName, String inFilePath) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "MomParser()");
        this.fileName = inFileName;
        this.filePath = inFilePath;
        try {
            this.fillInMoMap();
            logger.traceReturn(THIS_CLASS, "MomParser()");
        }
        catch (IOException e) {
            String reason = "Failure when parsing the MOM. " + e.getMessage();
            logger.traceError(THIS_CLASS, reason);
            throw new RbsConfigurationFailedException("MOM parsing failure", reason, e);
        }
    }

    private void fillInMoMap() throws IOException {
        logger.traceEnter(THIS_CLASS, "fillInMoMap()");
        MomParserExecutor momParser = new MomParserExecutor(this.fileName, this.filePath);
        List nodeMomElements = momParser.getXMLelements();
        XMLElement mimElement = (XMLElement)nodeMomElements.get(nodeMomElements.size() - 1);
        List mimChildren = mimElement.getChildren();
        Iterator mimChildIter = mimChildren.iterator();
        while (mimChildIter.hasNext()) {
            XMLElement currentMimChild = (XMLElement)mimChildIter.next();
            String mimChildType = currentMimChild.getType();
            if (!"class".equals(mimChildType)) continue;
            MoFactory.storeMo((XMLElement)currentMimChild, (Map)this.moMap);
        }
        logger.traceReturn(THIS_CLASS, "fillInMoMap()");
    }

    public Map getNonReadOnlyAttributes(String moType) {
        logger.traceEnter(THIS_CLASS, "getNonReadOnlyAttributes()");
        HashMap<String, AttributeMetaData> attrMap = new HashMap<String, AttributeMetaData>();
        if (!this.moMap.containsKey(moType)) {
            logger.traceError(THIS_CLASS, moType + " not found in MoMap");
            return null;
        }
        MoMetaData moMetaData = (MoMetaData)this.moMap.get(moType);
        Map allAttributesMap = moMetaData.getAttributes();
        Iterator attrIter = allAttributesMap.values().iterator();
        while (attrIter.hasNext()) {
            AttributeMetaData currentAttribute = (AttributeMetaData)attrIter.next();
            if (currentAttribute.getName().equals(moType + "Id") || Definitions.isPmAttribute((String)currentAttribute.getName()) || currentAttribute.isReadOnly()) continue;
            attrMap.put(currentAttribute.getName(), currentAttribute);
        }
        logger.traceReturn(THIS_CLASS, "getNonReadOnlyAttributes()");
        return attrMap;
    }

    private String findXmlMom(Integer momVersion) throws RbsConfigurationFailedException {
        ManagedObject[] loadModules;
        ManagedObject currentUpgradePackage;
        ManagedObject configVersionMo;
        String xmlFileName;
        String momCxcNumber;
        logger.traceEnter(THIS_CLASS, "findXmlMom()");
        String errorSlogan = "Could not find the MOM on the node.";
        IpOamConfigurationService ipOamConfigurationService = IpOamConfigurationServiceImpl.getInstance();
        if (momVersion.equals(RbsConfigurationDefinitions.MOM_PARSER_USE_CELLO_MOM)) {
            logger.traceDebug(THIS_CLASS, "Chosen to use Cello MOM for MOM parsing");
            momCxcNumber = "CXC1737839";
            xmlFileName = "CelloMOMRbs.xml";
        } else if (momVersion.equals(RbsConfigurationDefinitions.MOM_PARSER_USE_RBS_NODE_COMPLETE_MOM)) {
            logger.traceDebug(THIS_CLASS, "Chosen to use complete Node MOM for MOM parsing");
            momCxcNumber = "CXC1725482/2";
            xmlFileName = "RbsNodeComplete.xml";
        } else {
            String errorMessage = "Unknown MOM type: " + momVersion;
            logger.traceError(THIS_CLASS, "Could not find the MOM on the node. " + errorMessage);
            throw new RbsConfigurationFailedException("Could not find the MOM on the node.", errorMessage);
        }
        try {
            configVersionMo = ipOamConfigurationService.getMo("ManagedElement=1,SwManagement=1,ConfigurationVersion=1");
        }
        catch (MoNotFoundException e) {
            String errorMessage = "Could not get ConfigurationVersion MO.";
            logger.traceError(this.getClass(), "Could not find the MOM on the node. Could not get ConfigurationVersion MO.", (Throwable)e);
            throw new RbsConfigurationFailedException("Could not find the MOM on the node.", "Could not get ConfigurationVersion MO.", (Exception)((Object)e));
        }
        String currentUpgradePackageAttrName = "currentUpgradePackage";
        try {
            currentUpgradePackage = (ManagedObject)ipOamConfigurationService.getAttribute(configVersionMo.getLocalDistinguishedName(), "currentUpgradePackage");
        }
        catch (MoAccessException e) {
            String errorMessage = "Could not get attribute currentUpgradePackage for " + configVersionMo.getLocalDistinguishedName();
            logger.traceError(this.getClass(), "Could not find the MOM on the node. " + errorMessage, (Throwable)e);
            throw new RbsConfigurationFailedException("Could not find the MOM on the node.", errorMessage, (Exception)((Object)e));
        }
        String loadModuleListAttrName = "loadModuleList";
        try {
            loadModules = (ManagedObject[])ipOamConfigurationService.getAttribute(currentUpgradePackage.getLocalDistinguishedName(), "loadModuleList");
        }
        catch (MoAccessException e) {
            String errorMessage = "Could not get attribute loadModuleList for " + currentUpgradePackage.getLocalDistinguishedName();
            logger.traceError(this.getClass(), "Could not find the MOM on the node. " + errorMessage, (Throwable)e);
            throw new RbsConfigurationFailedException("Could not find the MOM on the node.", errorMessage, (Exception)((Object)e));
        }
        String loadModulePath = "";
        String loadModuleFilePathAttrName = "loadModuleFilePath";
        for (int i = 0; i < loadModules.length; ++i) {
            if (loadModules[i].getLocalDistinguishedName().indexOf(momCxcNumber) == -1) continue;
            try {
                loadModulePath = (String)ipOamConfigurationService.getAttribute(loadModules[i].getLocalDistinguishedName(), "loadModuleFilePath");
                break;
            }
            catch (MoAccessException e) {
                String errorMessage = "Could not get attribute loadModuleFilePath for " + loadModules[i].getLocalDistinguishedName();
                logger.traceError(this.getClass(), "Could not find the MOM on the node. " + errorMessage, (Throwable)e);
                throw new RbsConfigurationFailedException("Could not find the MOM on the node.", errorMessage, (Exception)((Object)e));
            }
        }
        if (loadModulePath.equals("")) {
            String errorMessage = "The MOM with CXC number " + momCxcNumber + " could not be found";
            logger.traceError(this.getClass(), "Could not find the MOM on the node. " + errorMessage);
            throw new RbsConfigurationFailedException("Could not find the MOM on the node.", errorMessage);
        }
        loadModulePath = loadModulePath + (loadModulePath.endsWith("/") ? "" : "/");
        logger.traceReturn(THIS_CLASS, "findXmlMom()");
        return this.findFileRecursively(loadModulePath, xmlFileName);
    }

    private String findFileRecursively(String searchPath, String fileNameToSearchFor) {
        File root = new File(searchPath);
        File[] allFiles = root.listFiles();
        if (allFiles == null) {
            return null;
        }
        for (int i = 0; i < allFiles.length; ++i) {
            String foundFileName;
            File file = allFiles[i];
            if (file.isFile() && file.getName().equals(fileNameToSearchFor)) {
                return file.getAbsolutePath();
            }
            if (!file.isDirectory() || (foundFileName = this.findFileRecursively(file.getAbsolutePath(), fileNameToSearchFor)) == null) continue;
            return foundFileName;
        }
        return null;
    }
}

