/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.XmlFileResolver;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.XMLElement;
import se.ericsson.crbs.omf.mao.xml.XMLElementFactoryImpl;
import se.ericsson.crbs.omf.mao.xml.XmlElementsReadable;

public class MomParserExecutor
implements XmlElementsReadable,
Parser {
    private static final String ORG_APACHE_XERCES_PARSERS_SAX_PARSER_STRING = "org.apache.xerces.parsers.SAXParser";
    private boolean isClosed = false;
    private static final AbstractLogger logger = LoggingService.getLogger();
    private final transient List xmlElementsInParsedFile = new ArrayList();

    public MomParserExecutor(String xmlFileName, String filePath) throws IOException {
        this.parseSchema(xmlFileName, filePath);
    }

    private XMLElement domElementToXMLElement(Element elementToTransform) {
        String elementText = elementToTransform.getText();
        XMLElement domElementAsXMLElement = XMLElementFactoryImpl.createXMLElement((String)elementToTransform.getName(), (String)elementText);
        List domElementAttributes = elementToTransform.getAttributes();
        Iterator attributeIter = domElementAttributes.iterator();
        while (attributeIter.hasNext()) {
            Attribute currentAttribute = (Attribute)attributeIter.next();
            domElementAsXMLElement.addAttribute(currentAttribute.getName(), currentAttribute.getValue());
        }
        List domElementChildren = elementToTransform.getChildren();
        this.processChildrenForElement(domElementChildren, domElementAsXMLElement);
        return domElementAsXMLElement;
    }

    public List getXMLelements() {
        if (this.isClosed) {
            throw new IllegalStateException("Parser is already closed!");
        }
        return this.xmlElementsInParsedFile;
    }

    private void parseSchema(String xmlFileName, String filePath) throws IOException {
        SAXBuilder builder = new SAXBuilder(ORG_APACHE_XERCES_PARSERS_SAX_PARSER_STRING, false);
        builder.setValidation(false);
        builder.setFeature("http://xml.org/sax/features/validation", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        XmlFileResolver resolver = this.createXmlFileResolver(filePath);
        builder.setEntityResolver((EntityResolver)resolver);
        try {
            Document schemaDoc = null;
            logger.traceDebug(this.getClass(), "Starting build " + xmlFileName);
            InputSource src = resolver.resolveEntity("", xmlFileName);
            schemaDoc = builder.build(src);
            logger.traceDebug(this.getClass(), "Finished build " + xmlFileName);
            Element root = schemaDoc.getRootElement();
            List children = root.getChildren();
            this.processChildrenForRoot(children);
        }
        catch (JDOMException e) {
            logger.traceError(this.getClass(), "", (Throwable)e);
            IOException ioe = new IOException("Problems occurred:" + e.getMessage());
            throw ioe;
        }
    }

    private XmlFileResolver createXmlFileResolver(String filePath) {
        ArrayList<String> tmpFilePaths = new ArrayList<String>();
        tmpFilePaths.add(filePath);
        return new XmlFileResolver(tmpFilePaths, null);
    }

    private void processChildrenForElement(List children, XMLElement parent) {
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            Element currentChild = (Element)childIter.next();
            XMLElement currentChildAsXMLElement = this.domElementToXMLElement(currentChild);
            parent.addChild(currentChildAsXMLElement);
        }
    }

    private void processChildrenForRoot(List children) {
        logger.traceEnter(this.getClass(), "processChildrenForRoot()");
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            Element currentChild = (Element)childIter.next();
            XMLElement currentChildAsXMLElement = this.domElementToXMLElement(currentChild);
            this.xmlElementsInParsedFile.add(currentChildAsXMLElement);
        }
        logger.traceReturn(this.getClass(), "processChildrenForRoot()");
    }

    public void close() {
        this.xmlElementsInParsedFile.clear();
        this.isClosed = true;
    }
}

