/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

class XmlFileResolver
implements EntityResolver2 {
    private static final Class THIS_CLASS = XmlFileResolver.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String FILE_SEPARATOR = "/";
    private List extraPathsBefore = null;
    private List extraPathsAfter = null;
    private String dtdFilePath = null;

    XmlFileResolver() {
    }

    XmlFileResolver(List pathsBefore, List pathsAfter) {
        this.extraPathsBefore = pathsBefore;
        this.extraPathsAfter = pathsAfter;
    }

    private URL findLocalFile(List pathsToCheck) {
        logger.traceEnter(THIS_CLASS, "findLocalFile()");
        URL ret = null;
        Iterator iterator = pathsToCheck.iterator();
        while (ret == null && iterator.hasNext()) {
            String fileToCheck = (String)iterator.next();
            logger.traceDebug(this.getClass(), "Check if file " + fileToCheck + " exists");
            try {
                ret = new URL(fileToCheck);
            }
            catch (MalformedURLException ignore) {
                File file = new File(fileToCheck);
                if (!file.exists()) continue;
                try {
                    ret = new File(this.encodePercent(fileToCheck)).toURL();
                }
                catch (MalformedURLException e) {
                    logger.traceError(this.getClass(), " Error in converting file " + file + " to URL", (Throwable)e);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "findLocalFile()");
        return ret;
    }

    private String encodePercent(String fileToCheck) {
        String ret = fileToCheck;
        int lastIndex = -1;
        int index = ret.indexOf(37);
        while (index != -1) {
            ret = ret.substring(0, (index += lastIndex + 1) + 1) + "25" + ret.substring(index + 1);
            lastIndex = index;
            index = ret.substring(index + 1).indexOf(37);
        }
        return ret;
    }

    private List createPathList(String href) {
        ArrayList<String> pathsToCheck = new ArrayList<String>();
        if (this.extraPathsBefore != null) {
            this.addPaths(pathsToCheck, this.extraPathsBefore, href);
        }
        pathsToCheck.add(href);
        if (this.extraPathsAfter != null) {
            this.addPaths(pathsToCheck, this.extraPathsAfter, href);
        }
        return pathsToCheck;
    }

    private void addPaths(List paths, List extraPaths, String href) {
        Iterator iterator = extraPaths.iterator();
        while (iterator.hasNext()) {
            String path = ((String)iterator.next()).trim();
            if (path.length() <= 0) continue;
            if (!path.endsWith(FILE_SEPARATOR)) {
                path = path + FILE_SEPARATOR;
            }
            paths.add(path + href);
        }
    }

    private String getSystemId(String href) {
        logger.traceEnter(this.getClass(), "getSystemId(" + href + ")");
        String systemId = "";
        if (href != null && !href.trim().equals("")) {
            List pathsToCheck = this.createPathList(href);
            URL url = this.findFileViaClassLoader(pathsToCheck);
            if (url == null) {
                url = this.findLocalFile(pathsToCheck);
            }
            if (url == null) {
                logger.traceError(this.getClass(), " Error in getting file:" + href);
            } else {
                systemId = url.toExternalForm();
            }
        }
        logger.traceReturn(this.getClass(), "getSystemId(" + href + ") = " + systemId);
        return systemId;
    }

    private URL findFileViaClassLoader(List pathsToCheck) {
        String fileToCheck;
        URL resource = null;
        Iterator iterator = pathsToCheck.iterator();
        do {
            fileToCheck = (String)iterator.next();
            logger.traceDebug(this.getClass(), "Check if file " + fileToCheck + " can be found using class loader");
        } while ((resource = ClassLoader.getSystemClassLoader().getResource(fileToCheck)) == null && iterator.hasNext());
        if (resource != null) {
            logger.traceDebug(THIS_CLASS, "Found file using class loader");
        }
        return resource;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        logger.traceEnter(this.getClass(), "resolveEntity(" + publicId + ", " + systemId + ")");
        String receivedSystemId = this.getSystemId(systemId);
        InputSource source = new InputSource(receivedSystemId);
        logger.traceReturn(this.getClass(), "resolveEntity(" + publicId + ", " + systemId + ") = " + source.getSystemId());
        return source;
    }

    public InputSource getExternalSubset(String rootElement, String baseUri) throws SAXException, IOException {
        InputSource source = null;
        if (this.dtdFilePath != null) {
            String docTypeString = this.dtdFilePath;
            source = new InputSource(this.getSystemId(docTypeString));
        }
        return source;
    }

    public InputSource resolveEntity(String externalEntity, String publicId, String baseUri, String systemId) throws SAXException, IOException {
        return null;
    }
}

