/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.ConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class AlternativeAccessDataConsistencyChecker
extends ConsistencyChecker {
    private static Class THIS_CLASS;
    private static AbstractLogger logger;
    private String faultMsg;

    public AlternativeAccessDataConsistencyChecker() {
        THIS_CLASS = AlternativeAccessDataConsistencyChecker.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }

    public void checkConsistency() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "checkConsistency()");
        ManagedObject ipAccessHostEtRef = this.getAlternativeAccessRef();
        if (ipAccessHostEtRef != null) {
            if (!this.xmlContainsAlternativeAccessData()) {
                String ipInterfaceMoRef = this.getIpHostLinksIpInterfaceMoRef().getLdn();
                String ipMoLdn = "ManagedElement=1,IpOam=1,Ip=1";
                String oaMAlternativeAccess = "oaMAlternativeAccess";
                if (!this.isVpnInterface(ipInterfaceMoRef)) {
                    this.faultMsg = "Missing required data for attribute " + oaMAlternativeAccess + " for MO " + ipMoLdn + " in the XML file.";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
                }
                String oamIpAccessHostEtLdn = this.vpnInterfaceDataLdn != null ? this.getOamOuterIpAccessHostEt(this.vpnInterfaceDataLdn).getLdn() : this.getOamOuterIpAccessHostEtFromNode(ipInterfaceMoRef);
                boolean reUsedReferencedMo = ipAccessHostEtRef.getLocalDistinguishedName().equals(oamIpAccessHostEtLdn);
                if (this.ipAccessHostEtDataLdn != null || !reUsedReferencedMo) {
                    this.faultMsg = "Missing required data for attribute " + oaMAlternativeAccess + " for MO " + ipMoLdn + " in the XML file.";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
                }
            }
        } else {
            logger.info(THIS_CLASS, "Alternative Access is currently not configured on the node. Skipping consistency check.");
        }
        logger.traceReturn(THIS_CLASS, "checkConsistency()");
    }

    private ManagedObject getAlternativeAccessRef() throws RbsConfigurationFailedException {
        try {
            return (ManagedObject)this.ipOamService.getAttribute("ManagedElement=1,IpOam=1,Ip=1", "ipAccessHostEtRef");
        }
        catch (MoAccessException e) {
            this.faultMsg = "Could not fetch attribute ipAccessHostEtRef from MO ManagedElement=1,IpOam=1,Ip=1";
            throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
        }
    }

    private boolean xmlContainsAlternativeAccessData() throws RbsConfigurationFailedException {
        int index;
        String attrName = "oaMAlternativeAccess";
        AttrList ipAttrList = (AttrList)this.ipOamHelper.getIpForOamSettingData().get("ManagedElement=1,IpOam=1,Ip=1");
        return !this.isAttributeValueNull(ipAttrList, index = ipAttrList.indexOf(attrName));
    }

    private boolean isAttributeValueNull(AttrList attrList, int index) throws RbsConfigurationFailedException {
        if (index == -1) {
            return true;
        }
        try {
            return attrList.getValue(index) == null;
        }
        catch (MoAccessException e) {
            this.faultMsg = "Exception thrown while fetching attribute from AttrList.";
            throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
        }
    }

    private String getOamOuterIpAccessHostEtFromNode(String vpnInterfaceLdn) throws RbsConfigurationFailedException {
        String attrIpAccessHostEtRef = "ipAccessHostEtRef";
        try {
            return ((ManagedObject)this.ipOamService.getAttribute(vpnInterfaceLdn, attrIpAccessHostEtRef)).getLocalDistinguishedName();
        }
        catch (MoAccessException e) {
            this.faultMsg = "Exception was thrown when fetching the attribute " + attrIpAccessHostEtRef + " from MO " + vpnInterfaceLdn;
            throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
        }
    }

    private boolean isVpnInterface(String ldn) {
        return ldn.indexOf("VpnInterface") > -1;
    }

    private StringReplacingManagedObject getIpHostLinksIpInterfaceMoRef() throws RbsConfigurationFailedException {
        StringReplacingManagedObject ipInterfaceMoRef = (StringReplacingManagedObject)this.ipOamService.getAttributeFromConfigurationData(this.ipHostLinkDataLdn, "ipInterfaceMoRef");
        return ipInterfaceMoRef;
    }
}

