/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.ConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IkePeerDataConsistencyChecker
extends ConsistencyChecker {
    private static Class THIS_CLASS;
    private static AbstractLogger logger;
    private String faultMsg;

    public IkePeerDataConsistencyChecker() {
        THIS_CLASS = IkePeerDataConsistencyChecker.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }

    public void checkConsistency() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "checkConsistency()");
        if (this.ikePeerDataLdn == null) {
            logger.info(THIS_CLASS, "No IkePeer data found in the XML-file. Skipping consistency check for this MO.");
            logger.traceReturn(THIS_CLASS, "checkConsistency()");
            return;
        }
        String ikePeerLdn = this.ipOamService.findTrafficMoWithMoType("IkePeer");
        if (ikePeerLdn != null) {
            String ipAccessHostEtRefAttrName;
            boolean ipAccessHostEtRefIsTrafficMo;
            if (!this.isMoIdUnique(ikePeerLdn, "IkePeerId", "IkePeer")) {
                this.faultMsg = "The IkePeer Mo has the same ID as another IkePeer MO.";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
            }
            StringReplacingManagedObject ipInterfaceMoRef = (StringReplacingManagedObject)this.ipOamService.getAttributeFromConfigurationData(this.ipHostLinkDataLdn, "ipInterfaceMoRef");
            String referencedVpnInterfaceLdn = ipInterfaceMoRef.getLdn();
            if (referencedVpnInterfaceLdn.indexOf("VpnInterface=") > -1 && (ipAccessHostEtRefIsTrafficMo = this.checkIfReferencedMoIsTrafficMo(referencedVpnInterfaceLdn, ipAccessHostEtRefAttrName = "ipAccessHostEtRef"))) {
                String peerIpAddressOnNode;
                try {
                    peerIpAddressOnNode = (String)this.ipOamService.getAttribute(ikePeerLdn, "peerIpAddress");
                }
                catch (MoAccessException e) {
                    this.faultMsg = "Could not access the MO " + ikePeerLdn + ".";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
                }
                if (peerIpAddressOnNode.equals((String)this.ipOamService.getAttributeFromConfigurationData(this.ikePeerDataLdn, "peerIpAddress"))) {
                    this.faultMsg = "The IkePeer Mo has the same peerIpAddress as another IkePeer MO.";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
                }
            }
        }
        logger.info(THIS_CLASS, "checkConsistency() passed");
        logger.traceReturn(THIS_CLASS, "checkConsistency()");
    }

    private boolean checkIfReferencedMoIsTrafficMo(String ldn, String referredMoAttrName) throws RbsConfigurationFailedException {
        if (this.ipOamHelper.getMoTypeToLdnMap().containsValue(ldn)) {
            StringReplacingManagedObject referredMo = (StringReplacingManagedObject)this.ipOamService.getAttributeFromConfigurationData(ldn, referredMoAttrName);
            return this.ipOamService.isTrafficMo(referredMo.getLdn());
        }
        try {
            ManagedObject referredMo = (ManagedObject)this.ipOamService.getAttribute(ldn, referredMoAttrName);
            return this.ipOamService.isTrafficMo(referredMo.getLocalDistinguishedName());
        }
        catch (MoAccessException e) {
            this.faultMsg = "The MO " + ldn + " could not be found";
            throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
        }
    }
}

