/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.ConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpAccessHostEtDataConsistencyChecker
extends ConsistencyChecker {
    private static Class THIS_CLASS;
    private static AbstractLogger logger;
    private String faultMsg;

    public IpAccessHostEtDataConsistencyChecker() {
        THIS_CLASS = IpAccessHostEtDataConsistencyChecker.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }

    public void checkConsistency() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "checkIpAccessHostEtData()");
        if (this.ipAccessHostEtDataLdn != null) {
            List allIpAccessHostEtMos = this.ipOamService.getAllMosOfType("IpAccessHostEt");
            for (int i = 0; i < allIpAccessHostEtMos.size(); ++i) {
                String ipAddressOnNode;
                String ipAccessHostEtLdn = ((ManagedObject)allIpAccessHostEtMos.get(i)).getLocalDistinguishedName();
                if (!this.ipOamService.isTrafficMo(ipAccessHostEtLdn)) continue;
                try {
                    ipAddressOnNode = (String)this.ipOamService.getAttribute(ipAccessHostEtLdn, "ipAddress");
                }
                catch (MoAccessException e) {
                    this.faultMsg = "Could not access the MO " + ipAccessHostEtLdn + ".";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
                }
                try {
                    if (ipAddressOnNode != null && ipAddressOnNode.equals((String)this.ipOamService.getAttributeFromConfigurationData(this.ipAccessHostEtDataLdn, "ipAddress"))) {
                        this.faultMsg = "The IpAccessHostEt MO has the same IP address as the already existing MO " + ipAccessHostEtLdn;
                        throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
                    }
                    if (this.isMoIdUnique(ipAccessHostEtLdn, "IpAccessHostEtId", "IpAccessHostEt")) continue;
                    this.faultMsg = "The IpAccessHostEt MO has the same ID as the already existing MO " + ipAccessHostEtLdn;
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
                }
                catch (MoAccessException e) {
                    this.faultMsg = "Could not access the XML data for MO " + this.ipAccessHostEtDataLdn;
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
                }
            }
            StringReplacingManagedObject ipInterfaceMoRef = (StringReplacingManagedObject)this.ipOamService.getAttributeFromConfigurationData(this.ipAccessHostEtDataLdn, "ipInterfaceMoRef");
            String ipInterfaceMoLdn = ipInterfaceMoRef.getLdn();
            if (this.ipInterfaceDataLdn != null) {
                if (!ipInterfaceMoLdn.equals(this.ipInterfaceDataLdn)) {
                    this.faultMsg = "The attribute ipInterfaceMoRef in MO " + this.ipAccessHostEtDataLdn + " is inconsistent! Does not reference the IpInterface MO in the XML-file.";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
                }
            } else {
                try {
                    if (this.ipOamService.getMo(ipInterfaceMoLdn) != null) {
                        this.referencedMos.add(ipInterfaceMoLdn);
                        logger.traceDebug(THIS_CLASS, "The IpAccessHostEt MO references the existing IpInterface MO " + ipInterfaceMoLdn);
                    }
                }
                catch (MoNotFoundException e) {
                    this.faultMsg = "The referenced MO " + ipInterfaceMoLdn + " was not found!";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
                }
            }
            logger.info(THIS_CLASS, "checkIpAccessHostEtData() passed");
        } else {
            logger.info(THIS_CLASS, "No IpAccessHostEtData found in the XML-file. Skipping consistency check for this MO.");
        }
        logger.traceReturn(THIS_CLASS, "checkIpAccessHostEtData()");
    }
}

