/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.ConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpHostLinkDataConsistencyChecker
extends ConsistencyChecker {
    private static Class THIS_CLASS;
    private static AbstractLogger logger;
    private String faultMsg;

    public IpHostLinkDataConsistencyChecker() {
        THIS_CLASS = IpHostLinkDataConsistencyChecker.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }

    /*
     * Unable to fully structure code
     */
    public void checkConsistency() throws RbsConfigurationFailedException {
        IpHostLinkDataConsistencyChecker.logger.traceEnter(IpHostLinkDataConsistencyChecker.THIS_CLASS, "checkConsistency()");
        if (this.ipHostLinkDataLdn == null) {
            this.faultMsg = "No IpHostLink data was found in the XML file.";
            throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
        }
        ipInterfaceMoRef = (StringReplacingManagedObject)this.ipOamService.getAttributeFromConfigurationData(this.ipHostLinkDataLdn, "ipInterfaceMoRef");
        if (ipInterfaceMoRef == null) {
            throw new RbsConfigurationFailedException(this.slogan, "The attribute ipInterfaceMoRef is empty for the IpHostLink MO!");
        }
        if (ipInterfaceMoRef.getLdn().indexOf("IpInterface=") > -1) {
            if (this.ipInterfaceDataLdn != null) {
                IpHostLinkDataConsistencyChecker.logger.traceDebug(IpHostLinkDataConsistencyChecker.THIS_CLASS, "ipInterfaceDataLdn=" + this.ipInterfaceDataLdn);
                IpHostLinkDataConsistencyChecker.logger.traceDebug(IpHostLinkDataConsistencyChecker.THIS_CLASS, "Referenced IpInterface: " + ipInterfaceMoRef.getLdn());
                if (!ipInterfaceMoRef.getLdn().equals(this.ipInterfaceDataLdn)) {
                    this.faultMsg = "The attribute IpInterfaceMoRef in MO " + this.ipHostLinkDataLdn + " is not consistent.";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
                }
            } else {
                try {
                    if (this.ipOamService.getMo(ipInterfaceMoRef.getLdn()) == null) ** GOTO lbl47
                    this.referencedMos.add(ipInterfaceMoRef.getLdn());
                    IpHostLinkDataConsistencyChecker.logger.traceDebug(IpHostLinkDataConsistencyChecker.THIS_CLASS, "The IpHostLink MO references the existing IpInterface MO " + ipInterfaceMoRef);
                }
                catch (MoNotFoundException e) {
                    this.faultMsg = "The referenced MO " + ipInterfaceMoRef.getLdn() + " was not found!";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)e);
                }
            }
        } else if (ipInterfaceMoRef.getLdn().indexOf("VpnInterface=") > -1) {
            if (this.vpnInterfaceDataLdn != null) {
                if (!ipInterfaceMoRef.getLdn().equals(this.vpnInterfaceDataLdn)) {
                    this.faultMsg = "The attribute IpInterfaceMoRef in MO " + this.ipHostLinkDataLdn + " is not consistent.";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
                }
            } else {
                try {
                    if (this.ipOamService.getMo(ipInterfaceMoRef.getLdn()) == null) ** GOTO lbl47
                    this.referencedMos.add(ipInterfaceMoRef.getLdn());
                    ipAccessHostEtLdn = this.getVpnInterfacesIpAccessHostEtRef(ipInterfaceMoRef.getLdn());
                    this.referencedMos.add(ipAccessHostEtLdn);
                    this.referencedMos.add(this.getIpAccessHostEtsIpInterfaceMoRef(ipAccessHostEtLdn));
                    IpHostLinkDataConsistencyChecker.logger.traceDebug(IpHostLinkDataConsistencyChecker.THIS_CLASS, "The IpHostLink MO references the existing vpnInterface MO " + ipInterfaceMoRef);
                }
                catch (MoNotFoundException e) {
                    this.faultMsg = "The referenced MO " + ipInterfaceMoRef.getLdn() + " was not found!";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)e);
                }
            }
        } else {
            this.faultMsg = "The attribute IpInterfaceMoRef in MO " + this.ipHostLinkDataLdn + " is inconsistent!";
            throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
        }
lbl47:
        // 6 sources

        IpHostLinkDataConsistencyChecker.logger.traceReturn(IpHostLinkDataConsistencyChecker.THIS_CLASS, "checkConsistency()");
    }

    private String getVpnInterfacesIpAccessHostEtRef(String vpnInterfaceLdn) throws RbsConfigurationFailedException {
        ManagedObject ipAccessHostEtRef;
        try {
            ipAccessHostEtRef = (ManagedObject)this.ipOamService.getAttribute(vpnInterfaceLdn, "ipAccessHostEtRef");
        }
        catch (MoAccessException e) {
            this.faultMsg = "Could not fetch attribute ipAccessHostEtRef from MO " + vpnInterfaceLdn;
            throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
        }
        if (ipAccessHostEtRef != null) {
            return ipAccessHostEtRef.getLocalDistinguishedName();
        }
        this.faultMsg = "The attribute ipAccessHostEtRef is empty for MO " + vpnInterfaceLdn;
        throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
    }
}

