/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.ConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpSecTunnelDataConsistencyChecker
extends ConsistencyChecker {
    private static Class THIS_CLASS;
    private static AbstractLogger logger;
    private String faultMsg;

    public IpSecTunnelDataConsistencyChecker() {
        THIS_CLASS = IpSecTunnelDataConsistencyChecker.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }

    public void checkConsistency() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "checkConsistency()");
        if (this.ipSecTunnelDataLdn == null) {
            logger.info(THIS_CLASS, "No IpSecTunnel data found in the XML-file. Skipping consistency check for this MO.");
            logger.traceReturn(THIS_CLASS, "checkConsistency()");
            return;
        }
        this.checkConsistencyOfIpSecTunnelId();
        StringReplacingManagedObject vpnInterfaceRef = (StringReplacingManagedObject)this.ipOamService.getAttributeFromConfigurationData(this.ipSecTunnelDataLdn, "vpnInterfaceRef");
        if (vpnInterfaceRef != null) {
            this.checkConsistencyOfVpnInterfaceRef(vpnInterfaceRef.getLdn());
        } else {
            logger.info(THIS_CLASS, "vpnInterfaceRef in MO " + this.ipSecTunnelDataLdn + " is empty so no consistency check will be performed for this attribute.");
        }
        StringReplacingManagedObject ikePeerRef = (StringReplacingManagedObject)this.ipOamService.getAttributeFromConfigurationData(this.ipSecTunnelDataLdn, "ikePeerRef");
        if (ikePeerRef != null) {
            this.checkConsistencyOfIkePeerRef(ikePeerRef.getLdn());
        } else {
            logger.info(THIS_CLASS, "ikePeerRef in MO " + this.ipSecTunnelDataLdn + " is empty so no consistency check will be performed for this attribute.");
        }
        logger.traceReturn(THIS_CLASS, "checkConsistency()");
    }

    private void checkConsistencyOfIpSecTunnelId() throws RbsConfigurationFailedException {
        List ipSecTunnelMos = this.ipOamService.getAllMosOfType("IpSecTunnel");
        if (!ipSecTunnelMos.isEmpty()) {
            String idInXml = this.ipOamHelper.getId("IpSecTunnel");
            for (int i = 0; i < ipSecTunnelMos.size(); ++i) {
                ManagedObject ipSecTunnelMo = (ManagedObject)ipSecTunnelMos.get(i);
                try {
                    String idOnNode = (String)this.ipOamService.getAttribute(ipSecTunnelMo.getLocalDistinguishedName(), "IpSecTunnelId");
                    if (!idOnNode.equals(idInXml)) continue;
                    this.faultMsg = "The IpSecTunnel MO has the same ID as another IpSecTunnel MO.";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
                }
                catch (MoAccessException e) {
                    this.faultMsg = "Could not access the MO " + ipSecTunnelMo.getLocalDistinguishedName() + "!";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
                }
            }
        }
    }

    private void checkConsistencyOfVpnInterfaceRef(String vpnInterfaceLdn) throws RbsConfigurationFailedException {
        if (this.vpnInterfaceDataLdn != null) {
            if (!vpnInterfaceLdn.equals(this.vpnInterfaceDataLdn)) {
                this.faultMsg = "The attribute vpnInterfaceRef in MO " + this.ipSecTunnelDataLdn + " is inconsistent! Does not reference the VpnInterface MO in the XML-file.";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
            }
        } else {
            try {
                ManagedObject vpnInterfaceMo = this.ipOamService.getMo(vpnInterfaceLdn);
                this.referencedMos.add(vpnInterfaceMo.getLocalDistinguishedName());
                logger.traceDebug(THIS_CLASS, "The IpSecTunnel MO references the existing VpnInterface MO " + vpnInterfaceLdn);
            }
            catch (MoNotFoundException e) {
                this.faultMsg = "The referenced MO " + vpnInterfaceLdn + " was not found!";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
            }
        }
    }

    private void checkConsistencyOfIkePeerRef(String ikePeerLdn) throws RbsConfigurationFailedException {
        if (this.ikePeerDataLdn != null) {
            if (!ikePeerLdn.equals(this.ikePeerDataLdn)) {
                this.faultMsg = "The attribute ikePeerRef in MO " + this.ipSecTunnelDataLdn + " is inconsistent! Does not reference the IkePeer MO in the XML-file.";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
            }
        } else {
            try {
                ManagedObject ikePeerMo = this.ipOamService.getMo(ikePeerLdn);
                this.referencedMos.add(ikePeerMo.getLocalDistinguishedName());
                logger.traceDebug(THIS_CLASS, "The IpSecTunnel MO references the existing IkePeer MO " + ikePeerLdn);
            }
            catch (MoNotFoundException e) {
                this.faultMsg = "The referenced MO " + ikePeerLdn + " was not found!";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
            }
        }
    }
}

